/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.blogs.EntryContentException;
import com.liferay.portlet.blogs.EntryDisplayDateException;
import com.liferay.portlet.blogs.EntrySmallImageNameException;
import com.liferay.portlet.blogs.EntrySmallImageSizeException;
import com.liferay.portlet.blogs.EntryTitleException;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.base.BlogsEntryLocalServiceBaseImpl;
import com.liferay.portlet.blogs.util.BlogsUtil;
import com.liferay.portlet.blogs.util.LinkbackProducerUtil;
import com.liferay.portlet.blogs.util.comparator.EntryDisplayDateComparator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsEntryLocalServiceImpl
extends BlogsEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(BlogsEntryLocalServiceImpl.class);

    public BlogsEntry addEntry(long userId, String title, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, boolean smallImage, String smallImageURL, String smallImageFileName, InputStream smallImageInputStream, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryDisplayDateException());
        byte[] smallImageBytes = null;
        try {
            if (smallImageInputStream != null && smallImage) {
                smallImageBytes = FileUtil.getBytes((InputStream)smallImageInputStream);
            }
        }
        catch (IOException iOException) {}
        Date now = new Date();
        this.validate(title, content, smallImage, smallImageURL, smallImageFileName, smallImageBytes);
        long entryId = this.counterLocalService.increment();
        BlogsEntry entry = this.blogsEntryPersistence.create(entryId);
        entry.setUuid(serviceContext.getUuid());
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(serviceContext.getCreateDate(now));
        entry.setModifiedDate(serviceContext.getModifiedDate(now));
        entry.setTitle(title);
        entry.setUrlTitle(this.getUniqueUrlTitle(entryId, groupId, title));
        entry.setDescription(description);
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setAllowPingbacks(allowPingbacks);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setSmallImage(smallImage);
        entry.setSmallImageId(this.counterLocalService.increment());
        entry.setSmallImageURL(smallImageURL);
        entry.setStatus(2);
        entry.setStatusDate(serviceContext.getModifiedDate(now));
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addEntryResources(entry, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addEntryResources(entry, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.saveImages(smallImage, entry.getSmallImageId(), smallImageBytes);
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, entry.getUserName(), groupId, BlogsEntry.class.getName(), entryId, 1);
        }
        if (trackbacks != null && trackbacks.length > 0) {
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
        } else {
            serviceContext.setAttribute("trackbacks", null);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (Object)entry, (ServiceContext)serviceContext);
        return entry;
    }

    public void addEntryResources(BlogsEntry entry, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addEntryResources(BlogsEntry entry, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), BlogsEntry.class.getName(), entry.getEntryId(), groupPermissions, guestPermissions);
    }

    public void addEntryResources(long entryId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, addGroupPermissions, addGuestPermissions);
    }

    public void addEntryResources(long entryId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.addEntryResources(entry, groupPermissions, guestPermissions);
    }

    public void deleteEntries(long groupId) throws PortalException, SystemException {
        for (BlogsEntry entry : this.blogsEntryPersistence.findByGroupId(groupId)) {
            this.deleteEntry(entry);
        }
    }

    public void deleteEntry(BlogsEntry entry) throws PortalException, SystemException {
        this.blogsEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), BlogsEntry.class.getName(), 4, entry.getEntryId());
        this.imageLocalService.deleteImage(entry.getSmallImageId());
        this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), entry.getUserId());
        this.assetEntryLocalService.deleteEntry(BlogsEntry.class.getName(), entry.getEntryId());
        this.expandoValueLocalService.deleteValues(BlogsEntry.class.getName(), entry.getEntryId());
        this.mbMessageLocalService.deleteDiscussionMessages(BlogsEntry.class.getName(), entry.getEntryId());
        this.ratingsStatsLocalService.deleteStats(BlogsEntry.class.getName(), entry.getEntryId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(BlogsEntry.class);
        indexer.delete((Object)entry);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId());
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, Date displayDate, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByC_LtD(companyId, displayDate, start, end);
        }
        return this.blogsEntryPersistence.findByC_LtD_S(companyId, displayDate, status, start, end);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, Date displayDate, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByC_LtD(companyId, displayDate, start, end, obc);
        }
        return this.blogsEntryPersistence.findByC_LtD_S(companyId, displayDate, status, start, end, obc);
    }

    public int getCompanyEntriesCount(long companyId, Date displayDate, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.countByC_LtD(companyId, displayDate);
        }
        return this.blogsEntryPersistence.countByC_LtD_S(companyId, displayDate, status);
    }

    public BlogsEntry[] getEntriesPrevAndNext(long entryId) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        return this.blogsEntryPersistence.findByG_S_PrevAndNext(entry.getEntryId(), entry.getGroupId(), 0, (OrderByComparator)new EntryDisplayDateComparator(true));
    }

    public BlogsEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.blogsEntryPersistence.findByPrimaryKey(entryId);
    }

    public BlogsEntry getEntry(long groupId, String urlTitle) throws PortalException, SystemException {
        return this.blogsEntryPersistence.findByG_UT(groupId, urlTitle);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByG_LtD(groupId, displayDate, start, end);
        }
        return this.blogsEntryPersistence.findByG_LtD_S(groupId, displayDate, status, start, end);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByG_LtD(groupId, displayDate, start, end, obc);
        }
        return this.blogsEntryPersistence.findByG_LtD_S(groupId, displayDate, status, start, end, obc);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByGroupId(groupId, start, end);
        }
        return this.blogsEntryPersistence.findByG_S(groupId, status, start, end);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByGroupId(groupId, start, end, obc);
        }
        return this.blogsEntryPersistence.findByG_S(groupId, status, start, end, obc);
    }

    public int getGroupEntriesCount(long groupId, Date displayDate, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.countByG_LtD(groupId, displayDate);
        }
        return this.blogsEntryPersistence.countByG_LtD_S(groupId, displayDate, status);
    }

    public int getGroupEntriesCount(long groupId, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.countByGroupId(groupId);
        }
        return this.blogsEntryPersistence.countByG_S(groupId, status);
    }

    public List<BlogsEntry> getGroupsEntries(long companyId, long groupId, Date displayDate, int status, int start, int end) throws SystemException {
        return this.blogsEntryFinder.findByGroupIds(companyId, groupId, displayDate, status, start, end);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, Date displayDate, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByG_U_LtD(groupId, userId, displayDate, start, end);
        }
        return this.blogsEntryPersistence.findByG_U_LtD_S(groupId, userId, displayDate, status, start, end);
    }

    public List<BlogsEntry> getGroupUserEntries(long groupId, long userId, Date displayDate, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.findByG_U_LtD(groupId, userId, displayDate, start, end, obc);
        }
        return this.blogsEntryPersistence.findByG_U_LtD_S(groupId, userId, displayDate, status, start, end, obc);
    }

    public int getGroupUserEntriesCount(long groupId, long userId, Date displayDate, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.countByG_U_LtD(groupId, userId, displayDate);
        }
        return this.blogsEntryPersistence.countByG_U_LtD_S(groupId, userId, displayDate, status);
    }

    public List<BlogsEntry> getNoAssetEntries() throws SystemException {
        return this.blogsEntryFinder.findByNoAssets();
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, Date displayDate, int status, int start, int end) throws SystemException {
        return this.blogsEntryFinder.findByOrganizationId(organizationId, displayDate, status, start, end, null);
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, Date displayDate, int status, int start, int end, OrderByComparator obc) throws SystemException {
        return this.blogsEntryFinder.findByOrganizationId(organizationId, displayDate, status, start, end, obc);
    }

    public int getOrganizationEntriesCount(long organizationId, Date displayDate, int status) throws SystemException {
        return this.blogsEntryFinder.countByOrganizationId(organizationId, displayDate, status);
    }

    public void subscribe(long userId, long groupId) throws PortalException, SystemException {
        this.subscriptionLocalService.addSubscription(userId, groupId, BlogsEntry.class.getName(), groupId);
    }

    public void unsubscribe(long userId, long groupId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, BlogsEntry.class.getName(), groupId);
    }

    public void updateAsset(long userId, BlogsEntry entry, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        boolean visible = false;
        if (entry.isApproved()) {
            visible = true;
        }
        String summary = HtmlUtil.extractText((String)StringUtil.shorten((String)entry.getContent(), (int)500));
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), entry.getUuid(), 0L, assetCategoryIds, assetTagNames, visible, null, null, entry.getDisplayDate(), null, "text/html", entry.getTitle(), null, summary, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public BlogsEntry updateEntry(long userId, long entryId, String title, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, boolean smallImage, String smallImageURL, String smallImageFileName, InputStream smallImageInputStream, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new EntryDisplayDateException());
        byte[] smallImageBytes = null;
        try {
            if (smallImageInputStream != null && smallImage) {
                smallImageBytes = FileUtil.getBytes((InputStream)smallImageInputStream);
            }
        }
        catch (IOException iOException) {}
        this.validate(title, content, smallImage, smallImageURL, smallImageFileName, smallImageBytes);
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        String oldUrlTitle = entry.getUrlTitle();
        entry.setModifiedDate(serviceContext.getModifiedDate(null));
        entry.setTitle(title);
        entry.setUrlTitle(this.getUniqueUrlTitle(entryId, entry.getGroupId(), title));
        entry.setDescription(description);
        entry.setContent(content);
        entry.setDisplayDate(displayDate);
        entry.setAllowPingbacks(allowPingbacks);
        entry.setAllowTrackbacks(allowTrackbacks);
        entry.setSmallImage(smallImage);
        if (entry.getSmallImageId() == 0L) {
            entry.setSmallImageId(this.counterLocalService.increment());
        }
        entry.setSmallImageURL(smallImageURL);
        if (!entry.isPending()) {
            entry.setStatus(2);
        }
        entry.setExpandoBridgeAttributes(serviceContext);
        this.blogsEntryPersistence.update((BaseModel)entry, false);
        if (serviceContext.getGroupPermissions() != null || serviceContext.getGuestPermissions() != null) {
            this.updateEntryResources(entry, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.saveImages(smallImage, entry.getSmallImageId(), smallImageBytes);
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        boolean pingOldTrackbacks = false;
        if (!oldUrlTitle.equals(entry.getUrlTitle())) {
            pingOldTrackbacks = true;
        }
        serviceContext.setAttribute("pingOldTrackbacks", (Serializable)((Object)String.valueOf(pingOldTrackbacks)));
        if (Validator.isNotNull((Object[])trackbacks)) {
            serviceContext.setAttribute("trackbacks", (Serializable)trackbacks);
        } else {
            serviceContext.setAttribute("trackbacks", null);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)entry.getGroupId(), (long)userId, (String)BlogsEntry.class.getName(), (long)entry.getEntryId(), (Object)entry, (ServiceContext)serviceContext);
        return entry;
    }

    public void updateEntryResources(BlogsEntry entry, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.updateResources(entry.getCompanyId(), entry.getGroupId(), BlogsEntry.class.getName(), entry.getEntryId(), groupPermissions, guestPermissions);
    }

    public BlogsEntry updateStatus(long userId, long entryId, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(entryId);
        int oldStatus = entry.getStatus();
        long oldStatusByUserId = entry.getStatusByUserId();
        entry.setModifiedDate(serviceContext.getModifiedDate(now));
        entry.setStatus(status);
        entry.setStatusByUserId(user.getUserId());
        entry.setStatusByUserName(user.getFullName());
        entry.setStatusDate(serviceContext.getModifiedDate(now));
        this.blogsEntryPersistence.update((BaseModel)entry, false);
        Indexer indexer = IndexerRegistryUtil.getIndexer(BlogsEntry.class);
        if (status == 0) {
            this.blogsStatsUserLocalService.updateStatsUser(entry.getGroupId(), user.getUserId(), entry.getDisplayDate());
            if (oldStatus != 0) {
                this.assetEntryLocalService.updateVisible(BlogsEntry.class.getName(), entryId, true);
                if (oldStatusByUserId == 0L) {
                    this.socialActivityLocalService.addUniqueActivity(user.getUserId(), entry.getGroupId(), BlogsEntry.class.getName(), entryId, 2, "", 0L);
                } else {
                    this.socialActivityLocalService.addActivity(user.getUserId(), entry.getGroupId(), BlogsEntry.class.getName(), entryId, 3, "", 0L);
                }
            }
            indexer.reindex((Object)entry);
            this.notifySubscribers(entry, serviceContext);
            String[] trackbacks = (String[])serviceContext.getAttribute("trackbacks");
            Boolean pingOldTrackbacks = GetterUtil.getBoolean((String)((String)((Object)serviceContext.getAttribute("pingOldTrackbacks"))));
            this.pingGoogle(entry, serviceContext);
            this.pingPingback(entry, serviceContext);
            this.pingTrackbacks(entry, trackbacks, pingOldTrackbacks, serviceContext);
        } else if (status != 0) {
            this.assetEntryLocalService.updateVisible(BlogsEntry.class.getName(), entryId, false);
            indexer.delete((Object)entry);
        }
        return entry;
    }

    protected String getUniqueUrlTitle(long entryId, long groupId, String title) throws SystemException {
        BlogsEntry entry;
        String urlTitle = BlogsUtil.getUrlTitle(entryId, title);
        String newUrlTitle = ModelHintsUtil.trimString((String)BlogsEntry.class.getName(), (String)"urlTitle", (String)urlTitle);
        int i = 1;
        while ((entry = this.blogsEntryPersistence.fetchByG_UT(groupId, newUrlTitle)) != null && entry.getEntryId() != entryId) {
            String suffix = "-" + i;
            String prefix = newUrlTitle;
            if (newUrlTitle.length() > suffix.length()) {
                prefix = newUrlTitle.substring(0, newUrlTitle.length() - suffix.length());
            }
            newUrlTitle = String.valueOf(prefix) + suffix;
            ++i;
        }
        return newUrlTitle;
    }

    protected void notifySubscribers(BlogsEntry entry, ServiceContext serviceContext) throws SystemException {
        if (!entry.isApproved()) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = entry.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "33";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(entry.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(serviceContext.isCommandAdd() && BlogsUtil.getEmailEntryAddedEnabled(preferences) || serviceContext.isCommandUpdate() && BlogsUtil.getEmailEntryUpdatedEnabled(preferences))) {
            return;
        }
        String entryURL = String.valueOf(layoutFullURL) + "/-/" + "blogs" + "/" + entry.getEntryId();
        String fromName = BlogsUtil.getEmailFromName(preferences, entry.getCompanyId());
        String fromAddress = BlogsUtil.getEmailFromAddress(preferences, entry.getCompanyId());
        Map<Locale, String> localizedSubjectMap = null;
        Map<Locale, String> localizedBodyMap = null;
        if (serviceContext.isCommandUpdate()) {
            localizedSubjectMap = BlogsUtil.getEmailEntryUpdatedSubjectMap(preferences);
            localizedBodyMap = BlogsUtil.getEmailEntryUpdatedBodyMap(preferences);
        } else {
            localizedSubjectMap = BlogsUtil.getEmailEntryAddedSubjectMap(preferences);
            localizedBodyMap = BlogsUtil.getEmailEntryAddedBodyMap(preferences);
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(entry.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$BLOGS_ENTRY_URL$]", entryURL});
        subscriptionSender.setContextUserPrefix("BLOGS_ENTRY");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("blogs_entry", new Object[]{entry.getEntryId()});
        subscriptionSender.setPortletId("33");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(entry.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(entry.getUserId());
        subscriptionSender.addPersistedSubscribers(BlogsEntry.class.getName(), entry.getGroupId());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void pingGoogle(BlogsEntry entry, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!PropsValues.BLOGS_PING_GOOGLE_ENABLED || !entry.isApproved()) {
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((long)serviceContext.getScopeGroupId(), (String)"33");
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        if (layoutFullURL.contains("://localhost")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not pinging Google because of localhost URL " + layoutFullURL));
            }
            return;
        }
        Group group = this.groupPersistence.findByPrimaryKey(entry.getGroupId());
        StringBundler sb = new StringBundler(6);
        String name = group.getDescriptiveName();
        String url = String.valueOf(layoutFullURL) + "/-/" + "blogs";
        String changesURL = String.valueOf(layoutFullURL) + "/-/" + "blogs/rss";
        sb.append("http://blogsearch.google.com/ping?name=");
        sb.append(HttpUtil.encodeURL((String)name));
        sb.append("&url=");
        sb.append(HttpUtil.encodeURL((String)url));
        sb.append("&changesURL=");
        sb.append(HttpUtil.encodeURL((String)changesURL));
        String location = sb.toString();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Pinging Google at " + location));
        }
        try {
            String response = HttpUtil.URLtoString((String)sb.toString());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Google ping response: " + response));
            }
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to ping Google at " + location), (Throwable)ioe);
        }
    }

    protected void pingPingback(BlogsEntry entry, ServiceContext serviceContext) {
        if (!(PropsValues.BLOGS_PINGBACK_ENABLED && entry.isAllowPingbacks() && entry.isApproved())) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        String sourceUri = String.valueOf(layoutFullURL) + "/-/" + "blogs/" + entry.getUrlTitle();
        Source source = new Source((CharSequence)entry.getContent());
        List tags = source.getAllStartTags("a");
        for (StartTag tag : tags) {
            String targetUri = tag.getAttributeValue("href");
            if (!Validator.isNotNull((String)targetUri)) continue;
            try {
                LinkbackProducerUtil.sendPingback(sourceUri, targetUri);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending pingback " + targetUri), (Throwable)e);
            }
        }
    }

    protected void pingTrackbacks(BlogsEntry entry, String[] trackbacks, boolean pingOldTrackbacks, ServiceContext serviceContext) throws SystemException {
        if (!(PropsValues.BLOGS_TRACKBACK_ENABLED && entry.isAllowTrackbacks() && entry.isApproved())) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        HashMap<String, String> parts = new HashMap<String, String>();
        String excerpt = StringUtil.shorten((String)HtmlUtil.extractText((String)entry.getContent()), (int)PropsValues.BLOGS_LINKBACK_EXCERPT_LENGTH);
        String url = String.valueOf(layoutFullURL) + "/-/" + "blogs/" + entry.getUrlTitle();
        parts.put("title", entry.getTitle());
        parts.put("excerpt", excerpt);
        parts.put("url", url);
        parts.put("blog_name", entry.getUserName());
        HashSet trackbacksSet = null;
        trackbacksSet = Validator.isNotNull((Object[])trackbacks) ? SetUtil.fromArray((Object[])trackbacks) : new HashSet();
        if (pingOldTrackbacks) {
            trackbacksSet.addAll(SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks())));
            entry.setTrackbacks("");
            this.blogsEntryPersistence.update((BaseModel)entry, false);
        }
        Set oldTrackbacks = SetUtil.fromArray((Object[])StringUtil.split((String)entry.getTrackbacks()));
        HashSet<String> validTrackbacks = new HashSet<String>();
        for (String trackback : trackbacksSet) {
            if (oldTrackbacks.contains(trackback)) continue;
            try {
                if (!LinkbackProducerUtil.sendTrackback(trackback, parts)) continue;
                validTrackbacks.add(trackback);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending trackback at " + trackback), (Throwable)e);
            }
        }
        if (!validTrackbacks.isEmpty()) {
            String newTrackbacks = StringUtil.merge(validTrackbacks);
            if (Validator.isNotNull((String)entry.getTrackbacks())) {
                newTrackbacks = String.valueOf(newTrackbacks) + "," + entry.getTrackbacks();
            }
            entry.setTrackbacks(newTrackbacks);
            this.blogsEntryPersistence.update((BaseModel)entry, false);
        }
    }

    protected void saveImages(boolean smallImage, long smallImageId, byte[] smallImageBytes) throws PortalException, SystemException {
        if (smallImage) {
            if (smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected void validate(String title, String content, boolean smallImage, String smallImageURL, String smallImageFileName, byte[] smallImageBytes) throws PortalException, SystemException {
        if (Validator.isNull((String)title)) {
            throw new EntryTitleException();
        }
        if (Validator.isNull((String)content)) {
            throw new EntryContentException();
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("blogs.image.extensions", ",");
        if (smallImage && Validator.isNull((String)smallImageURL) && smallImageBytes != null) {
            long smallImageMaxSize;
            if (smallImageFileName != null) {
                boolean validSmallImageExtension = false;
                String[] stringArray = imageExtensions;
                int n = imageExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String _imageExtension = stringArray[n2];
                    if ("*".equals(_imageExtension) || StringUtil.endsWith((String)smallImageFileName, (String)_imageExtension)) {
                        validSmallImageExtension = true;
                        break;
                    }
                    ++n2;
                }
                if (!validSmallImageExtension) {
                    throw new EntrySmallImageNameException(smallImageFileName);
                }
            }
            if ((smallImageMaxSize = PrefsPropsUtil.getLong("blogs.image.small.max.size")) > 0L && (smallImageBytes == null || (long)smallImageBytes.length > smallImageMaxSize)) {
                throw new EntrySmallImageSizeException();
            }
        }
    }
}

