/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.lar.WordPressImporter;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryUtil;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import javax.portlet.PortletPreferences;

public class BlogsPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "blogs";
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("blogs", "categories");
    private static PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("blogs", "comments");
    private static PortletDataHandlerBoolean _entries = new PortletDataHandlerBoolean("blogs", "entries", true, true);
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("blogs", "ratings");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("blogs", "tags");
    private static PortletDataHandlerBoolean _wordpress = new PortletDataHandlerBoolean("blogs", "wordpress");

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_entries, _categories, _comments, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_entries, _categories, _comments, _ratings, _tags, _wordpress};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.BLOGS_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(BlogsPortletDataHandlerImpl.class, "deleteData")) {
            BlogsEntryLocalServiceUtil.deleteEntries((long)portletDataContext.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.blogs", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("blogs-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element entriesElement = rootElement.addElement("entries");
        Element dlFileEntryTypesElement = entriesElement.addElement("dl-file-entry-types");
        Element dlFoldersElement = entriesElement.addElement("dl-folders");
        Element dlFileEntriesElement = entriesElement.addElement("dl-file-entries");
        Element dlFileRanksElement = entriesElement.addElement("dl-file-ranks");
        List entries = BlogsEntryUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (BlogsEntry entry : entries) {
            this.exportEntry(portletDataContext, entriesElement, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, entry);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.blogs", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element entriesElement = rootElement.element("entries");
        if (entriesElement != null) {
            JournalPortletDataHandlerImpl.importReferencedData(portletDataContext, entriesElement);
        } else {
            entriesElement = rootElement;
        }
        for (Element entryElement : entriesElement.elements("entry")) {
            String path = entryElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            BlogsEntry entry = (BlogsEntry)portletDataContext.getZipEntryAsObject(path);
            this.importEntry(portletDataContext, entryElement, entry);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "wordpress")) {
            WordPressImporter.importData(portletDataContext);
        }
        return null;
    }

    protected void exportEntry(PortletDataContext portletDataContext, Element entriesElement, Element dlFileEntryTypesElement, Element dlFoldersElement, Element dlFileEntriesElement, Element dlFileRanksElement, BlogsEntry entry) throws Exception {
        if (!portletDataContext.isWithinDateRange(entry.getModifiedDate())) {
            return;
        }
        if (entry.getStatus() != 0) {
            return;
        }
        String path = this.getEntryPath(portletDataContext, entry);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        entry = (BlogsEntry)entry.clone();
        Element entryElement = (Element)entriesElement.selectSingleNode("//page[@path='".concat(path).concat("']"));
        if (entryElement == null) {
            entryElement = entriesElement.addElement("entry");
        }
        String content = JournalPortletDataHandlerImpl.exportReferencedContent(portletDataContext, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, entryElement, entry.getContent());
        entry.setContent(content);
        String imagePath = this.getEntryImagePath(portletDataContext, entry);
        entryElement.addAttribute("image-path", imagePath);
        Image smallImage = ImageUtil.fetchByPrimaryKey((long)entry.getSmallImageId());
        if (entry.isSmallImage() && smallImage != null) {
            String smallImagePath = this.getEntrySmallImagePath(portletDataContext, entry);
            entryElement.addAttribute("small-image-path", smallImagePath);
            entry.setSmallImageType(smallImage.getType());
            portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
        }
        portletDataContext.addClassedModel(entryElement, path, (ClassedModel)entry, _NAMESPACE);
    }

    protected String getEntryImagePath(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("33"));
        sb.append("/entry/");
        sb.append(entry.getUuid());
        sb.append("/");
        return sb.toString();
    }

    protected String getEntryPath(PortletDataContext portletDataContext, BlogsEntry entry) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("33"));
        sb.append("/entries/");
        sb.append(entry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getEntrySmallImagePath(PortletDataContext portletDataContext, BlogsEntry entry) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("33"));
        sb.append("/entries/");
        sb.append(entry.getUuid());
        sb.append("/thumbnail");
        sb.append(".");
        sb.append(entry.getSmallImageType());
        return sb.toString();
    }

    protected void importEntry(PortletDataContext portletDataContext, Element entryElement, BlogsEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        String content = JournalPortletDataHandlerImpl.importReferencedContent(portletDataContext, entryElement, entry.getContent());
        entry.setContent(content);
        Calendar displayDateCal = CalendarFactoryUtil.getCalendar();
        displayDateCal.setTime(entry.getDisplayDate());
        int displayDateMonth = displayDateCal.get(2);
        int displayDateDay = displayDateCal.get(5);
        int displayDateYear = displayDateCal.get(1);
        int displayDateHour = displayDateCal.get(10);
        int displayDateMinute = displayDateCal.get(12);
        if (displayDateCal.get(9) == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = entry.isAllowPingbacks();
        boolean allowTrackbacks = entry.isAllowTrackbacks();
        String[] trackbacks = StringUtil.split((String)entry.getTrackbacks());
        int status = entry.getStatus();
        ServiceContext serviceContext = portletDataContext.createServiceContext(entryElement, (ClassedModel)entry, _NAMESPACE);
        if (status != 0) {
            serviceContext.setWorkflowAction(2);
        }
        String smallImageFileName = null;
        InputStream smallImageInputStream = null;
        try {
            String smallImagePath = entryElement.attributeValue("small-image-path");
            if (entry.isSmallImage() && Validator.isNotNull((String)smallImagePath)) {
                smallImageFileName = String.valueOf(entry.getSmallImageId()).concat(".").concat(entry.getSmallImageType());
                smallImageInputStream = portletDataContext.getZipEntryAsInputStream(smallImagePath);
            }
            BlogsEntry importedEntry = null;
            if (portletDataContext.isDataStrategyMirror()) {
                BlogsEntry existingEntry = BlogsEntryUtil.fetchByUUID_G((String)entry.getUuid(), (long)portletDataContext.getScopeGroupId());
                if (existingEntry == null) {
                    serviceContext.setUuid(entry.getUuid());
                    importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.isSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
                } else {
                    importedEntry = BlogsEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.getSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
                }
            } else {
                importedEntry = BlogsEntryLocalServiceUtil.addEntry((long)userId, (String)entry.getTitle(), (String)entry.getDescription(), (String)entry.getContent(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)entry.getSmallImage(), (String)entry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
            }
            portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry, _NAMESPACE);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(smallImageInputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)smallImageInputStream);
    }
}

