/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.blogs.asset.BlogsEntryAssetRenderer;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.BlogsEntryServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.blogs.service.permission.BlogsPermission;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BlogsEntryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = BlogsEntry.class.getName();
    public static final String TYPE = "blog";
    private static final boolean _LINKABLE = true;

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        return new BlogsEntryAssetRenderer(entry);
    }

    public AssetRenderer getAssetRenderer(long groupId, String urlTitle) throws PortalException, SystemException {
        BlogsEntry entry = BlogsEntryServiceUtil.getEntry((long)groupId, (String)urlTitle);
        return new BlogsEntryAssetRenderer(entry);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException, SystemException {
        HttpServletRequest request = liferayPortletRequest.getHttpServletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (!BlogsPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_ENTRY")) {
            return null;
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)request, (String)"33", (long)this.getControlPanelPlid(themeDisplay), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/blogs/edit_entry");
        return portletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return BlogsEntryPermission.contains(permissionChecker, classPK, actionId);
    }

    public boolean isLinkable() {
        return true;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/blogs/blogs.png";
    }
}

