/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class BlogsEntryAssetRenderer
extends BaseAssetRenderer {
    private BlogsEntry _entry;

    public BlogsEntryAssetRenderer(BlogsEntry entry) {
        this._entry = entry;
    }

    public long getClassPK() {
        return this._entry.getEntryId();
    }

    public String getDiscussionPath() {
        if (PropsValues.BLOGS_ENTRY_COMMENTS_ENABLED) {
            return "edit_entry_discussion";
        }
        return null;
    }

    public long getGroupId() {
        return this._entry.getGroupId();
    }

    public String getSummary(Locale locale) {
        return HtmlUtil.stripHtml((String)this._entry.getDescription());
    }

    public String getTitle(Locale locale) {
        return this._entry.getTitle();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "33", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/blogs/edit_entry");
        portletURL.setParameter("entryId", String.valueOf(this._entry.getEntryId()));
        return portletURL;
    }

    public String getUrlTitle() {
        return this._entry.getUrlTitle();
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL("33", "RENDER_PHASE");
        portletURL.setWindowState(windowState);
        portletURL.setParameter("struts_action", "/blogs/view_entry");
        portletURL.setParameter("entryId", String.valueOf(this._entry.getEntryId()));
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/blogs/find_entry", "entryId", this._entry.getEntryId());
    }

    public long getUserId() {
        return this._entry.getUserId();
    }

    public String getUuid() {
        return this._entry.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return BlogsEntryPermission.contains(permissionChecker, this._entry, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return BlogsEntryPermission.contains(permissionChecker, this._entry, "VIEW");
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("BLOGS_ENTRY", (Object)this._entry);
            return "/html/portlet/blogs/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/blogs/blogs.png";
    }
}

