/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPublisherUtil {
    private static Log _log = LogFactoryUtil.getLog(AssetPublisherUtil.class);

    public static void addAndStoreSelection(PortletRequest portletRequest, String className, long classPK, int assetEntryOrder) throws Exception {
        String referringPortletResource = ParamUtil.getString((PortletRequest)portletRequest, (String)"referringPortletResource");
        if (Validator.isNull((String)referringPortletResource)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)themeDisplay.getRefererPlid());
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((long)themeDisplay.getScopeGroupId(), (Layout)layout, (String)referringPortletResource, null);
        String selectionStyle = portletPreferences.getValue("selectionStyle", "dynamic");
        if (selectionStyle.equals("dynamic")) {
            return;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
        AssetPublisherUtil.addSelection(className, assetEntry.getEntryId(), assetEntryOrder, portletPreferences);
        portletPreferences.store();
    }

    public static void addRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        AssetPublisherUtil._getRecentFolderIds(portletRequest).put(className, classPK);
    }

    public static void addSelection(PortletRequest portletRequest, PortletPreferences portletPreferences) throws Exception {
        String assetEntryType = ParamUtil.getString((PortletRequest)portletRequest, (String)"assetEntryType");
        long assetEntryId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"assetEntryId");
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"assetEntryOrder");
        AssetPublisherUtil.addSelection(assetEntryType, assetEntryId, assetEntryOrder, portletPreferences);
    }

    public static void addSelection(String assetEntryType, long assetEntryId, int assetEntryOrder, PortletPreferences portletPreferences) throws Exception {
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((long)assetEntryId);
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        String assetEntryXml = AssetPublisherUtil._getAssetEntryXml(assetEntryType, assetEntry.getClassUuid());
        if (assetEntryOrder > -1) {
            assetEntryXmls[assetEntryOrder] = assetEntryXml;
        } else {
            assetEntryXmls = (String[])ArrayUtil.append((Object[])assetEntryXmls, (Object)assetEntryXml);
        }
        portletPreferences.setValues("assetEntryXml", (String[])assetEntryXmls);
    }

    public static void addUserAttributes(User user, String[] customUserAttributeNames, AssetEntryQuery assetEntryQuery) throws Exception {
        if (user == null || customUserAttributeNames.length == 0) {
            return;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)user.getCompanyId());
        long[] allCategoryIds = assetEntryQuery.getAllCategoryIds();
        PrimitiveLongList allCategoryIdsList = new PrimitiveLongList(allCategoryIds.length + customUserAttributeNames.length);
        allCategoryIdsList.addAll(allCategoryIds);
        String[] stringArray = customUserAttributeNames;
        int n = customUserAttributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String customUserAttributeName = stringArray[n2];
            ExpandoBridge userCustomAttributes = user.getExpandoBridge();
            Serializable userCustomFieldValue = userCustomAttributes.getAttribute(customUserAttributeName);
            if (userCustomFieldValue != null) {
                String userCustomFieldValueString = userCustomFieldValue.toString();
                List assetCategories = AssetCategoryLocalServiceUtil.search((long)companyGroup.getGroupId(), (String)userCustomFieldValueString, (String[])new String[0], (int)-1, (int)-1);
                for (AssetCategory assetCategory : assetCategories) {
                    allCategoryIdsList.add(assetCategory.getCategoryId());
                }
            }
            ++n2;
        }
        assetEntryQuery.setAllCategoryIds(allCategoryIdsList.getArray());
    }

    public static AssetEntryQuery getAssetEntryQuery(PortletPreferences portletPreferences, long[] scopeGroupIds) throws Exception {
        String[] queryValues;
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        long[] allAssetCategoryIds = new long[]{};
        long[] anyAssetCategoryIds = new long[]{};
        long[] notAllAssetCategoryIds = new long[]{};
        long[] notAnyAssetCategoryIds = new long[]{};
        String[] allAssetTagNames = new String[]{};
        String[] anyAssetTagNames = new String[]{};
        String[] notAllAssetTagNames = new String[]{};
        String[] notAnyAssetTagNames = new String[]{};
        int i = 0;
        while ((queryValues = portletPreferences.getValues("queryValues" + i, null)) != null && queryValues.length != 0) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i, ""));
            String queryName = portletPreferences.getValue("queryName" + i, "");
            if (Validator.equals((Object)queryName, (Object)"assetCategories")) {
                long[] assetCategoryIds = GetterUtil.getLongValues((String[])queryValues);
                if (queryContains && (queryAndOperator || assetCategoryIds.length == 1)) {
                    allAssetCategoryIds = assetCategoryIds;
                } else if (queryContains && !queryAndOperator) {
                    anyAssetCategoryIds = assetCategoryIds;
                } else if (!queryContains && queryAndOperator) {
                    notAllAssetCategoryIds = assetCategoryIds;
                } else {
                    notAnyAssetCategoryIds = assetCategoryIds;
                }
            } else if (queryContains && queryAndOperator) {
                allAssetTagNames = queryValues;
            } else if (queryContains && !queryAndOperator) {
                anyAssetTagNames = queryValues;
            } else if (!queryContains && queryAndOperator) {
                notAllAssetTagNames = queryValues;
            } else {
                notAnyAssetTagNames = queryValues;
            }
            ++i;
        }
        long[] allAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String[])allAssetTagNames);
        long[] anyAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String[])anyAssetTagNames);
        long[] notAllAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String[])notAllAssetTagNames);
        long[] notAnyAssetTagIds = AssetTagLocalServiceUtil.getTagIds((long[])scopeGroupIds, (String[])notAnyAssetTagNames);
        assetEntryQuery.setAllCategoryIds(allAssetCategoryIds);
        assetEntryQuery.setAllTagIds(allAssetTagIds);
        assetEntryQuery.setAnyCategoryIds(anyAssetCategoryIds);
        assetEntryQuery.setAnyTagIds(anyAssetTagIds);
        assetEntryQuery.setNotAllCategoryIds(notAllAssetCategoryIds);
        assetEntryQuery.setNotAllTagIds(notAllAssetTagIds);
        assetEntryQuery.setNotAnyCategoryIds(notAnyAssetCategoryIds);
        assetEntryQuery.setNotAnyTagIds(notAnyAssetTagIds);
        return assetEntryQuery;
    }

    public static String[] getAssetTagNames(PortletPreferences portletPreferences, long scopeGroupId) throws Exception {
        String[] queryValues;
        String[] allAssetTagNames = new String[]{};
        int i = 0;
        while ((queryValues = portletPreferences.getValues("queryValues" + i, null)) != null && queryValues.length != 0) {
            boolean queryContains = GetterUtil.getBoolean((String)portletPreferences.getValue("queryContains" + i, ""));
            boolean queryAndOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("queryAndOperator" + i, ""));
            String queryName = portletPreferences.getValue("queryName" + i, "");
            if (!Validator.equals((Object)queryName, (Object)"assetCategories") && queryContains && (queryAndOperator || queryValues.length == 1)) {
                allAssetTagNames = queryValues;
            }
            ++i;
        }
        return allAssetTagNames;
    }

    public static String getClassName(AssetRendererFactory assetRendererFactory) {
        Class<?> clazz = assetRendererFactory.getClass();
        String className = clazz.getName();
        int pos = className.lastIndexOf(".");
        return className.substring(pos + 1);
    }

    public static long[] getClassNameIds(PortletPreferences portletPreferences, long[] availableClassNameIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyAssetType", Boolean.TRUE.toString()));
        if (anyAssetType) {
            return availableClassNameIds;
        }
        long defaultClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("anyAssetType", null));
        if (defaultClassNameId > 0L) {
            return new long[]{defaultClassNameId};
        }
        long[] classNameIds = GetterUtil.getLongValues((String[])portletPreferences.getValues("classNameIds", null));
        if (classNameIds != null) {
            return classNameIds;
        }
        return availableClassNameIds;
    }

    public static Long[] getClassTypeIds(PortletPreferences portletPreferences, String className, Long[] availableClassTypeIds) {
        boolean anyAssetType = GetterUtil.getBoolean((String)portletPreferences.getValue("anyClassType" + className, Boolean.TRUE.toString()));
        if (anyAssetType) {
            return availableClassTypeIds;
        }
        long defaultClassTypeId = GetterUtil.getLong((String)portletPreferences.getValue("anyClassType" + className, null));
        if (defaultClassTypeId > 0L) {
            return new Long[]{defaultClassTypeId};
        }
        Long[] classTypeIds = ArrayUtil.toArray((long[])StringUtil.split((String)portletPreferences.getValue("classTypeIds" + className, null), (long)0L));
        if (classTypeIds != null) {
            return classTypeIds;
        }
        return availableClassTypeIds;
    }

    public static long[] getGroupIds(PortletPreferences portletPreferences, long scopeGroupId, Layout layout) {
        boolean defaultScope = GetterUtil.getBoolean((String)portletPreferences.getValue("defaultScope", null), (boolean)true);
        if (defaultScope) {
            return new long[]{scopeGroupId};
        }
        long defaultScopeId = GetterUtil.getLong((String)portletPreferences.getValue("defaultScope", null));
        if (defaultScopeId > 0L) {
            return new long[]{defaultScopeId};
        }
        String[] scopeIds = portletPreferences.getValues("scopeIds", new String[]{"group_" + scopeGroupId});
        long[] groupIds = new long[scopeIds.length];
        int i = 0;
        while (i < scopeIds.length) {
            try {
                String[] scopeIdFragments = StringUtil.split((String)scopeIds[i], (char)'_');
                if (scopeIdFragments[0].equals("Layout")) {
                    long scopeIdLayoutId = GetterUtil.getLong((String)scopeIdFragments[1]);
                    Layout scopeIdLayout = LayoutLocalServiceUtil.getLayout((long)scopeGroupId, (boolean)layout.isPrivateLayout(), (long)scopeIdLayoutId);
                    Group scopeIdGroup = scopeIdLayout.getScopeGroup();
                    groupIds[i] = scopeIdGroup.getGroupId();
                } else {
                    long scopeIdGroupId;
                    groupIds[i] = scopeIdFragments[1].equals("default") ? scopeGroupId : (scopeIdGroupId = GetterUtil.getLong((String)scopeIdFragments[1]));
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return groupIds;
    }

    public static long getRecentFolderId(PortletRequest portletRequest, String className) {
        Long classPK = AssetPublisherUtil._getRecentFolderIds(portletRequest).get(className);
        if (classPK == null) {
            return 0L;
        }
        return classPK;
    }

    public static void removeAndStoreSelection(List<String> assetEntryUuids, PortletPreferences portletPreferences) throws Exception {
        if (assetEntryUuids.size() == 0) {
            return;
        }
        Object[] assetEntryXmls = portletPreferences.getValues("assetEntryXml", new String[0]);
        List assetEntryXmlsList = ListUtil.fromArray((Object[])assetEntryXmls);
        Iterator itr = assetEntryXmlsList.iterator();
        while (itr.hasNext()) {
            String assetEntryXml = (String)itr.next();
            Document document = SAXReaderUtil.read((String)assetEntryXml);
            Element rootElement = document.getRootElement();
            String assetEntryUuid = rootElement.elementText("asset-entry-uuid");
            if (!assetEntryUuids.contains(assetEntryUuid)) continue;
            itr.remove();
        }
        portletPreferences.setValues("assetEntryXml", assetEntryXmlsList.toArray(new String[assetEntryXmlsList.size()]));
        portletPreferences.store();
    }

    public static void removeRecentFolderId(PortletRequest portletRequest, String className, long classPK) {
        if (AssetPublisherUtil.getRecentFolderId(portletRequest, className) == classPK) {
            AssetPublisherUtil._getRecentFolderIds(portletRequest).remove(className);
        }
    }

    private static String _getAssetEntryXml(String assetEntryType, String assetEntryUuid) {
        String xml;
        block2: {
            xml = null;
            try {
                Document document = SAXReaderUtil.createDocument((String)"UTF-8");
                Element assetEntryElement = document.addElement("asset-entry");
                Element assetEntryTypeElement = assetEntryElement.addElement("asset-entry-type");
                assetEntryTypeElement.addText(assetEntryType);
                Element assetEntryUuidElement = assetEntryElement.addElement("asset-entry-uuid");
                assetEntryUuidElement.addText(assetEntryUuid);
                xml = document.formattedString("");
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)ioe);
            }
        }
        return xml;
    }

    private static Map<String, Long> _getRecentFolderIds(PortletRequest portletRequest) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        String key = AssetPublisherUtil.class + "_" + themeDisplay.getScopeGroupId();
        HashMap<String, Long> recentFolderIds = (HashMap<String, Long>)session.getAttribute(key);
        if (recentFolderIds == null) {
            recentFolderIds = new HashMap<String, Long>();
        }
        session.setAttribute(key, recentFolderIds);
        return recentFolderIds;
    }
}

