/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.asset.NoSuchCategoryException;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.model.impl.AssetCategoryImpl;
import com.liferay.portlet.asset.service.persistence.AssetCategoryFinder;
import com.liferay.portlet.asset.service.persistence.AssetEntryUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetCategoryFinderImpl
extends BasePersistenceImpl<AssetCategory>
implements AssetCategoryFinder {
    public static String COUNT_BY_G_C_N = String.valueOf(AssetCategoryFinder.class.getName()) + ".countByG_C_N";
    public static String COUNT_BY_G_N_V = String.valueOf(AssetCategoryFinder.class.getName()) + ".countByG_N_V";
    public static String COUNT_BY_G_N_P = String.valueOf(AssetCategoryFinder.class.getName()) + ".countByG_N_P";
    public static String FIND_BY_ENTRY_ID = String.valueOf(AssetCategoryFinder.class.getName()) + ".findByEntryId";
    public static String FIND_BY_G_N = String.valueOf(AssetCategoryFinder.class.getName()) + ".findByG_N";
    public static String FIND_BY_C_C = String.valueOf(AssetCategoryFinder.class.getName()) + ".findByC_C";
    public static String FIND_BY_G_N_V = String.valueOf(AssetCategoryFinder.class.getName()) + ".findByG_N_V";
    public static String FIND_BY_G_N_P = String.valueOf(AssetCategoryFinder.class.getName()) + ".findByG_N_P";

    public int countByG_C_N(long groupId, long classNameId, String name) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_C_N);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(classNameId);
            qPos.add(name);
            qPos.add(name);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_N_V(long groupId, String name, long vocabularyId) throws SystemException {
        return this.doCountByG_N_V(groupId, name, vocabularyId, false);
    }

    public int countByG_N_P(long groupId, String name, String[] categoryProperties) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, categoryProperties);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int filterCountByG_N_V(long groupId, String name, long vocabularyId) throws SystemException {
        return this.doCountByG_N_V(groupId, name, vocabularyId, true);
    }

    public List<AssetCategory> filterFindByG_N_V(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.doFindByG_N_V(groupId, name, vocabularyId, start, end, obc, true);
    }

    public List<AssetCategory> findByEntryId(long entryId) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ENTRY_ID);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("AssetCategory", AssetCategoryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(entryId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public AssetCategory findByG_N(long groupId, String name) throws NoSuchCategoryException, SystemException {
        name = name.trim().toLowerCase();
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("AssetCategory", AssetCategoryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(name);
            List categories = q.list();
            if (!categories.isEmpty()) {
                AssetCategory assetCategory = (AssetCategory)categories.get(0);
                return assetCategory;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        StringBundler sb = new StringBundler(6);
        sb.append("No AssetCategory exists with the key ");
        sb.append("{groupId=");
        sb.append(groupId);
        sb.append(", name=");
        sb.append(name);
        sb.append("}");
        throw new NoSuchCategoryException(sb.toString());
    }

    public List<AssetCategory> findByC_C(long classNameId, long classPK) throws SystemException {
        List list;
        AssetEntry entry;
        Session session;
        block5: {
            session = null;
            entry = AssetEntryUtil.fetchByC_C((long)classNameId, (long)classPK);
            if (entry != null) break block5;
            List<AssetCategory> list2 = Collections.emptyList();
            this.closeSession(session);
            return list2;
        }
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_C);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("AssetCategory", AssetCategoryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(entry.getEntryId());
            list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1);
        }
        catch (Exception e) {
            try {
                throw new SystemException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
        return list;
    }

    public List<AssetCategory> findByG_N_V(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.doFindByG_N_V(groupId, name, vocabularyId, start, end, obc, false);
    }

    public List<AssetCategory> findByG_N_P(long groupId, String name, String[] categoryProperties) throws SystemException {
        return this.findByG_N_P(groupId, name, categoryProperties, -1, -1);
    }

    public List<AssetCategory> findByG_N_P(long groupId, String name, String[] categoryProperties, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_P);
            sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(categoryProperties));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("AssetCategory", AssetCategoryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, categoryProperties);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_N_V(long groupId, String name, long vocabularyId, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_N_V);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetCategory.class.getName(), (String)"AssetCategory.categoryId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(vocabularyId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<AssetCategory> doFindByG_N_V(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc, boolean inlineSQLHelper) throws SystemException {
        name = name.trim().toLowerCase();
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_N_V);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)AssetVocabulary.class.getName(), (String)"AssetCategory.categoryId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("AssetCategory", AssetCategoryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(name);
            qPos.add(name);
            qPos.add(vocabularyId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(String[] categoryProperties) {
        if (categoryProperties.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(categoryProperties.length * 3 + 2);
        sb.append(" INNER JOIN AssetCategoryProperty ON ");
        sb.append(" (AssetCategoryProperty.categoryId = ");
        sb.append(" AssetCategory.categoryId) AND ");
        int i = 0;
        while (i < categoryProperties.length) {
            sb.append("(AssetCategoryProperty.key_ = ? AND ");
            sb.append("AssetCategoryProperty.value = ?) ");
            if (i + 1 < categoryProperties.length) {
                sb.append(" AND ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected void setJoin(QueryPos qPos, String[] categoryProperties) {
        int i = 0;
        while (i < categoryProperties.length) {
            String[] categoryProperty = StringUtil.split((String)categoryProperties[i], (char)':');
            String key = "";
            if (categoryProperty.length > 0) {
                key = GetterUtil.getString((String)categoryProperty[0]);
            }
            String value = "";
            if (categoryProperty.length > 1) {
                value = GetterUtil.getString((String)categoryProperty[1]);
            }
            qPos.add(key);
            qPos.add(value);
            ++i;
        }
    }
}

