/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.base.AssetVocabularyServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetVocabularyServiceImpl
extends AssetVocabularyServiceBaseImpl {
    public AssetVocabulary addVocabulary(Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addVocabulary("", titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary addVocabulary(String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), title, titleMap, descriptionMap, settings, serviceContext);
    }

    public void deleteVocabularies(long[] vocabularyIds) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        long[] lArray = vocabularyIds;
        int n = vocabularyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long vocabularyId = lArray[n2];
            AssetVocabularyPermission.check(permissionChecker, vocabularyId, "DELETE");
            this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
            ++n2;
        }
    }

    public void deleteVocabulary(long vocabularyId) throws PortalException, SystemException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
        this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
    }

    public List<AssetVocabulary> getCompanyVocabularies(long companyId) throws PortalException, SystemException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getCompanyVocabularies(companyId));
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) throws PortalException, SystemException {
        return this.getGroupsVocabularies(groupIds, null);
    }

    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className) throws PortalException, SystemException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getGroupsVocabularies(groupIds, className));
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException, SystemException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getGroupVocabularies(groupId));
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.assetVocabularyPersistence.filterFindByGroupId(groupId, start, end, obc);
    }

    public List<AssetVocabulary> getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator obc) throws SystemException {
        return this.assetVocabularyFinder.filterFindByG_N(groupId, name, start, end, obc);
    }

    public int getGroupVocabulariesCount(long groupId) throws SystemException {
        return this.assetVocabularyPersistence.filterCountByGroupId(groupId);
    }

    public int getGroupVocabulariesCount(long groupId, String name) throws SystemException {
        return this.assetVocabularyFinder.filterCountByG_N(groupId, name);
    }

    public JSONObject getJSONGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List<AssetVocabulary> vocabularies;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        int page = end / (end - start);
        jsonObject.put("page", page);
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            vocabularies = this.getGroupVocabularies(groupId, name, start, end, obc);
            total = this.getGroupVocabulariesCount(groupId, name);
        } else {
            vocabularies = this.getGroupVocabularies(groupId, start, end, obc);
            total = this.getGroupVocabulariesCount(groupId);
        }
        String vocabulariesJSON = JSONFactoryUtil.looseSerialize(vocabularies);
        JSONArray vocabulariesJSONArray = JSONFactoryUtil.createJSONArray((String)vocabulariesJSON);
        jsonObject.put("vocabularies", vocabulariesJSONArray);
        jsonObject.put("total", total);
        return jsonObject;
    }

    public List<AssetVocabulary> getVocabularies(long[] vocabularyIds) throws PortalException, SystemException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getVocabularies(vocabularyIds));
    }

    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException, SystemException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "VIEW");
        return this.assetVocabularyLocalService.getVocabulary(vocabularyId);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateVocabulary(vocabularyId, "", titleMap, descriptionMap, settings, serviceContext);
    }

    public AssetVocabulary updateVocabulary(long vocabularyId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "UPDATE");
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, title, titleMap, descriptionMap, settings, serviceContext);
    }

    protected List<AssetVocabulary> filterVocabularies(List<AssetVocabulary> vocabularies) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        vocabularies = ListUtil.copy(vocabularies);
        Iterator itr = vocabularies.iterator();
        while (itr.hasNext()) {
            AssetVocabulary vocabulary = (AssetVocabulary)itr.next();
            if (AssetVocabularyPermission.contains(permissionChecker, vocabulary, "VIEW")) continue;
            itr.remove();
        }
        return vocabularies;
    }
}

