/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCache;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetEntryDisplay;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.base.AssetEntryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.portlet.asset.service.permission.AssetTagPermission;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryServiceImpl
extends AssetEntryServiceBaseImpl {
    public List<AssetEntry> getCompanyEntries(long companyId, int start, int end) throws SystemException {
        return this.assetEntryLocalService.getCompanyEntries(companyId, start, end);
    }

    public int getCompanyEntriesCount(long companyId) throws SystemException {
        return this.assetEntryLocalService.getCompanyEntriesCount(companyId);
    }

    public AssetEntryDisplay[] getCompanyEntryDisplays(long companyId, int start, int end, String languageId) throws SystemException {
        return this.assetEntryLocalService.getCompanyEntryDisplays(companyId, start, end, languageId);
    }

    public List<AssetEntry> getEntries(AssetEntryQuery entryQuery) throws PortalException, SystemException {
        AssetEntryQuery filteredEntryQuery = this.setupQuery(entryQuery);
        if (this.isRemovedFilters(entryQuery, filteredEntryQuery)) {
            return new ArrayList<AssetEntry>();
        }
        Object[] results = this.filterQuery(entryQuery);
        return (List)results[0];
    }

    public int getEntriesCount(AssetEntryQuery entryQuery) throws PortalException, SystemException {
        AssetEntryQuery filteredEntryQuery = this.setupQuery(entryQuery);
        if (this.isRemovedFilters(entryQuery, filteredEntryQuery)) {
            return 0;
        }
        Object[] results = this.filterQuery(entryQuery);
        return (Integer)results[1];
    }

    public AssetEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.assetEntryLocalService.getEntry(entryId);
    }

    public AssetEntry incrementViewCounter(String className, long classPK) throws PortalException, SystemException {
        if (!PropsValues.ASSET_ENTRY_INCREMENT_VIEW_COUNTER_ENABLED) {
            return null;
        }
        User user = this.getGuestOrUser();
        this.assetEntryLocalService.incrementViewCounter(user.getUserId(), className, classPK, 1);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(className, classPK);
        if (!user.isDefaultUser()) {
            this.socialActivityLocalService.addActivity(user.getUserId(), assetEntry.getGroupId(), className, classPK, 10001, "", 0L);
        }
        return assetEntry;
    }

    public AssetEntryDisplay[] searchEntryDisplays(long companyId, long[] groupIds, String className, String keywords, String languageId, int start, int end) throws SystemException {
        return this.assetEntryLocalService.searchEntryDisplays(companyId, groupIds, className, keywords, languageId, start, end);
    }

    public int searchEntryDisplaysCount(long companyId, long[] groupIds, String className, String keywords, String languageId) throws SystemException {
        return this.assetEntryLocalService.searchEntryDisplaysCount(companyId, groupIds, className, keywords, languageId);
    }

    public AssetEntry updateEntry(long groupId, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException, SystemException {
        return this.assetEntryLocalService.updateEntry(this.getUserId(), groupId, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync);
    }

    protected long[] filterCategoryIds(long[] categoryIds) throws PortalException, SystemException {
        ArrayList<Long> viewableCategoryIds = new ArrayList<Long>();
        long[] lArray = categoryIds;
        int n = categoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long categoryId = lArray[n2];
            if (AssetCategoryPermission.contains(this.getPermissionChecker(), categoryId, "VIEW")) {
                viewableCategoryIds.add(categoryId);
            }
            ++n2;
        }
        return ArrayUtil.toArray((Long[])viewableCategoryIds.toArray(new Long[viewableCategoryIds.size()]));
    }

    protected long[] filterTagIds(long[] tagIds) throws PortalException, SystemException {
        ArrayList<Long> viewableTagIds = new ArrayList<Long>();
        long[] lArray = tagIds;
        int n = tagIds.length;
        int n2 = 0;
        while (n2 < n) {
            long tagId = lArray[n2];
            if (AssetTagPermission.contains(this.getPermissionChecker(), tagId, "VIEW")) {
                viewableTagIds.add(tagId);
            }
            ++n2;
        }
        return ArrayUtil.toArray((Long[])viewableTagIds.toArray(new Long[viewableTagIds.size()]));
    }

    protected Object[] filterQuery(AssetEntryQuery entryQuery) throws PortalException, SystemException {
        String key;
        ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.REQUEST, (Serializable)((Object)AssetEntryServiceImpl.class.getName()));
        Object[] results = (Object[])threadLocalCache.get(key = entryQuery.toString());
        if (results != null) {
            return results;
        }
        int end = entryQuery.getEnd();
        int start = entryQuery.getStart();
        if (entryQuery.isEnablePermissions()) {
            entryQuery.setEnd(end + PropsValues.ASSET_FILTER_SEARCH_LIMIT);
            entryQuery.setStart(0);
        }
        ArrayList entries = this.assetEntryLocalService.getEntries(entryQuery);
        List<AssetEntry> filteredEntries = null;
        int filteredEntriesCount = 0;
        if (entryQuery.isEnablePermissions()) {
            PermissionChecker permissionChecker = this.getPermissionChecker();
            filteredEntries = new ArrayList();
            for (AssetEntry entry : entries) {
                String className = entry.getClassName();
                long classPK = entry.getClassPK();
                AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
                try {
                    if (assetRendererFactory.hasPermission(permissionChecker, classPK, "VIEW")) {
                        filteredEntries.add(entry);
                    }
                }
                catch (Exception exception) {}
                if (filteredEntries.size() > end) break;
            }
            filteredEntriesCount = filteredEntries.size();
            if (end != -1 && start != -1) {
                if (end > filteredEntriesCount) {
                    end = filteredEntriesCount;
                }
                if (start > filteredEntriesCount) {
                    start = filteredEntriesCount;
                }
                filteredEntries = filteredEntries.subList(start, end);
            }
            entryQuery.setEnd(end);
            entryQuery.setStart(start);
        } else {
            filteredEntries = entries;
            filteredEntriesCount = entries.size();
        }
        results = new Object[]{filteredEntries, filteredEntriesCount};
        threadLocalCache.put(key, (Object)results);
        return results;
    }

    protected boolean isRemovedFilters(AssetEntryQuery entryQuery, AssetEntryQuery filteredEntryQuery) {
        return entryQuery.getAllCategoryIds().length > 0 && filteredEntryQuery.getAllCategoryIds().length == 0 || entryQuery.getAllTagIds().length > 0 && filteredEntryQuery.getAllTagIds().length == 0 || entryQuery.getAnyCategoryIds().length > 0 && filteredEntryQuery.getAnyCategoryIds().length == 0 || entryQuery.getAnyTagIds().length > 0 && filteredEntryQuery.getAnyTagIds().length == 0;
    }

    protected AssetEntryQuery setupQuery(AssetEntryQuery entryQuery) throws PortalException, SystemException {
        AssetEntryQuery filteredEntryQuery = new AssetEntryQuery(entryQuery);
        filteredEntryQuery.setAllCategoryIds(this.filterCategoryIds(entryQuery.getAllCategoryIds()));
        filteredEntryQuery.setAllTagIds(this.filterTagIds(entryQuery.getAllTagIds()));
        filteredEntryQuery.setAnyCategoryIds(this.filterCategoryIds(entryQuery.getAnyCategoryIds()));
        filteredEntryQuery.setAnyTagIds(this.filterTagIds(entryQuery.getAnyTagIds()));
        return filteredEntryQuery;
    }
}

