/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.base.AssetCategoryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.util.Autocomplete;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetCategoryServiceImpl
extends AssetCategoryServiceBaseImpl {
    public AssetCategory addCategory(long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    public void deleteCategories(long[] categoryIds) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        long[] lArray = categoryIds;
        int n = categoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long categoryId = lArray[n2];
            AssetCategory category = this.assetCategoryPersistence.fetchByPrimaryKey(categoryId);
            if (category != null) {
                AssetCategoryPermission.check(permissionChecker, categoryId, "DELETE");
                this.assetCategoryLocalService.deleteCategory(category);
            }
            ++n2;
        }
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        this.assetCategoryLocalService.deleteCategory(categoryId);
    }

    public List<AssetCategory> getCategories(String className, long classPK) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getCategories(className, classPK));
    }

    public AssetCategory getCategory(long categoryId) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        return this.assetCategoryLocalService.getCategory(categoryId);
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId));
    }

    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId, start, end, obc));
    }

    public JSONObject getJSONVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List<AssetCategory> categories;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        int page = end / (end - start);
        jsonObject.put("page", page);
        int total = 0;
        if (Validator.isNotNull((String)name)) {
            name = CustomSQLUtil.keywords((String)name)[0];
            categories = this.getVocabularyCategories(groupId, name, vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, name, vocabularyId);
        } else {
            categories = this.getVocabularyCategories(vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, vocabularyId);
        }
        String categoriesJSON = JSONFactoryUtil.looseSerialize(categories);
        JSONArray categoriesJSONArray = JSONFactoryUtil.createJSONArray((String)categoriesJSON);
        jsonObject.put("categories", categoriesJSONArray);
        jsonObject.put("total", total);
        return jsonObject;
    }

    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
    }

    public List<AssetCategory> getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(parentCategoryId, vocabularyId, start, end, obc));
    }

    public List<AssetCategory> getVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.assetCategoryFinder.filterFindByG_N_V(groupId, name, vocabularyId, start, end, obc);
    }

    public int getVocabularyCategoriesCount(long groupId, long vocabularyId) throws SystemException {
        return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
    }

    public int getVocabularyCategoriesCount(long groupId, String name, long vocabularyId) throws SystemException {
        return this.assetCategoryFinder.filterCountByG_N_V(groupId, name, vocabularyId);
    }

    public List<AssetCategory> getVocabularyRootCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyRootCategories(vocabularyId, start, end, obc));
    }

    public AssetCategory moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.moveCategory(categoryId, parentCategoryId, vocabularyId, serviceContext);
    }

    public List<AssetCategory> search(long groupId, String keywords, long vocabularyId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.filterCategories(this.assetCategoryFinder.findByG_N_V(groupId, CustomSQLUtil.keywords((String)keywords)[0], vocabularyId, start, end, obc));
    }

    public JSONArray search(long groupId, String name, String[] categoryProperties, int start, int end) throws PortalException, SystemException {
        List<AssetCategory> categories = this.assetCategoryLocalService.search(groupId, name, categoryProperties, start, end);
        categories = this.filterCategories(categories);
        return Autocomplete.listToJson(categories, (String)"name", (String)"name");
    }

    public AssetCategory updateCategory(long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.updateCategory(this.getUserId(), categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    protected List<AssetCategory> filterCategories(List<AssetCategory> categories) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        categories = ListUtil.copy(categories);
        Iterator itr = categories.iterator();
        while (itr.hasNext()) {
            AssetCategory category = (AssetCategory)itr.next();
            if (AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            itr.remove();
        }
        return categories;
    }
}

