/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetEntryDisplay;
import com.liferay.portlet.asset.service.AssetEntryServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(AssetEntryServiceHttp.class);
    private static final Class<?>[] _getCompanyEntriesParameterTypes0 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getCompanyEntriesCountParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getCompanyEntryDisplaysParameterTypes2 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, String.class};
    private static final Class<?>[] _getEntriesParameterTypes3 = new Class[]{AssetEntryQuery.class};
    private static final Class<?>[] _getEntriesCountParameterTypes4 = new Class[]{AssetEntryQuery.class};
    private static final Class<?>[] _getEntryParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _incrementViewCounterParameterTypes6 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _searchEntryDisplaysParameterTypes7 = new Class[]{Long.TYPE, long[].class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _searchEntryDisplaysCountParameterTypes8 = new Class[]{Long.TYPE, long[].class, String.class, String.class, String.class};
    private static final Class<?>[] _updateEntryParameterTypes9 = new Class[]{Long.TYPE, String.class, Long.TYPE, String.class, Long.TYPE, long[].class, String[].class, Boolean.TYPE, Date.class, Date.class, Date.class, Date.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.class, Boolean.TYPE};

    public static List<AssetEntry> getCompanyEntries(HttpPrincipal httpPrincipal, long companyId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getCompanyEntries", (Class[])_getCompanyEntriesParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getCompanyEntriesCount(HttpPrincipal httpPrincipal, long companyId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getCompanyEntriesCount", (Class[])_getCompanyEntriesCountParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntryDisplay[] getCompanyEntryDisplays(HttpPrincipal httpPrincipal, long companyId, int start, int end, String languageId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getCompanyEntryDisplays", (Class[])_getCompanyEntryDisplaysParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntryDisplay[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<AssetEntry> getEntries(HttpPrincipal httpPrincipal, AssetEntryQuery entryQuery) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getEntries", (Class[])_getEntriesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryQuery});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getEntriesCount(HttpPrincipal httpPrincipal, AssetEntryQuery entryQuery) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getEntriesCount", (Class[])_getEntriesCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryQuery});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntry getEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getEntry", (Class[])_getEntryParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntry incrementViewCounter(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "incrementViewCounter", (Class[])_incrementViewCounterParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntryDisplay[] searchEntryDisplays(HttpPrincipal httpPrincipal, long companyId, long[] groupIds, String className, String keywords, String languageId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "searchEntryDisplays", (Class[])_searchEntryDisplaysParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, groupIds, className, keywords, languageId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntryDisplay[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int searchEntryDisplaysCount(HttpPrincipal httpPrincipal, long companyId, long[] groupIds, String className, String keywords, String languageId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "searchEntryDisplaysCount", (Class[])_searchEntryDisplaysCountParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, groupIds, className, keywords, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntry updateEntry(HttpPrincipal httpPrincipal, long groupId, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "updateEntry", (Class[])_updateEntryParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

