/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.http;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategorySoap;
import com.liferay.portlet.asset.service.AssetCategoryServiceUtil;
import java.rmi.RemoteException;
import java.util.List;

public class AssetCategoryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(AssetCategoryServiceSoap.class);

    public static void deleteCategories(long[] categoryIds) throws RemoteException {
        try {
            AssetCategoryServiceUtil.deleteCategories((long[])categoryIds);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteCategory(long categoryId) throws RemoteException {
        try {
            AssetCategoryServiceUtil.deleteCategory((long)categoryId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getCategories(String className, long classPK) throws RemoteException {
        try {
            List returnValue = AssetCategoryServiceUtil.getCategories((String)className, (long)classPK);
            return AssetCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap getCategory(long categoryId) throws RemoteException {
        try {
            AssetCategory returnValue = AssetCategoryServiceUtil.getCategory((long)categoryId);
            return AssetCategorySoap.toSoapModel((AssetCategory)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getChildCategories(long parentCategoryId) throws RemoteException {
        try {
            List returnValue = AssetCategoryServiceUtil.getChildCategories((long)parentCategoryId);
            return AssetCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getChildCategories(long parentCategoryId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = AssetCategoryServiceUtil.getChildCategories((long)parentCategoryId, (int)start, (int)end, (OrderByComparator)obc);
            return AssetCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getJSONVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            JSONObject returnValue = AssetCategoryServiceUtil.getJSONVocabularyCategories((long)groupId, (String)name, (long)vocabularyId, (int)start, (int)end, (OrderByComparator)obc);
            return returnValue.toString();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = AssetCategoryServiceUtil.getVocabularyCategories((long)vocabularyId, (int)start, (int)end, (OrderByComparator)obc);
            return AssetCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = AssetCategoryServiceUtil.getVocabularyCategories((long)parentCategoryId, (long)vocabularyId, (int)start, (int)end, (OrderByComparator)obc);
            return AssetCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = AssetCategoryServiceUtil.getVocabularyCategories((long)groupId, (String)name, (long)vocabularyId, (int)start, (int)end, (OrderByComparator)obc);
            return AssetCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getVocabularyCategoriesCount(long groupId, long vocabularyId) throws RemoteException {
        try {
            int returnValue = AssetCategoryServiceUtil.getVocabularyCategoriesCount((long)groupId, (long)vocabularyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getVocabularyCategoriesCount(long groupId, String name, long vocabularyId) throws RemoteException {
        try {
            int returnValue = AssetCategoryServiceUtil.getVocabularyCategoriesCount((long)groupId, (String)name, (long)vocabularyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyRootCategories(long vocabularyId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = AssetCategoryServiceUtil.getVocabularyRootCategories((long)vocabularyId, (int)start, (int)end, (OrderByComparator)obc);
            return AssetCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws RemoteException {
        try {
            AssetCategory returnValue = AssetCategoryServiceUtil.moveCategory((long)categoryId, (long)parentCategoryId, (long)vocabularyId, (ServiceContext)serviceContext);
            return AssetCategorySoap.toSoapModel((AssetCategory)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] search(long groupId, String keywords, long vocabularyId, int start, int end, OrderByComparator obc) throws RemoteException {
        try {
            List returnValue = AssetCategoryServiceUtil.search((long)groupId, (String)keywords, (long)vocabularyId, (int)start, (int)end, (OrderByComparator)obc);
            return AssetCategorySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String search(long groupId, String name, String[] categoryProperties, int start, int end) throws RemoteException {
        try {
            JSONArray returnValue = AssetCategoryServiceUtil.search((long)groupId, (String)name, (String[])categoryProperties, (int)start, (int)end);
            return returnValue.toString();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

