/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.action;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.captcha.CaptchaImpl;
import com.liferay.portal.captcha.recaptcha.ReCaptchaImpl;
import com.liferay.portal.captcha.simplecaptcha.SimpleCaptchaImpl;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThreadUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.LuceneIndexer;
import com.liferay.portal.search.lucene.cluster.LuceneClusterUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ServiceComponentLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.admin.util.CleanUpPermissionsUtil;
import com.liferay.portlet.documentlibrary.util.DLPreviewableProcessor;
import com.liferay.portlet.documentlibrary.util.PDFProcessorUtil;
import com.liferay.util.log4j.Log4JUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.apache.log4j.Level;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class EditServerAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(EditServerAction.class);
    private static MethodKey _loadIndexesFromClusterMethodKey = new MethodKey(LuceneClusterUtil.class.getName(), "loadIndexesFromCluster", new Class[]{long[].class, Address.class});

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.admin.error");
            return;
        }
        PortletPreferences preferences = PrefsPropsUtil.getPreferences();
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = null;
        if (cmd.equals("addLogLevel")) {
            this.addLogLevel(actionRequest);
        } else if (cmd.equals("cacheDb")) {
            this.cacheDb();
        } else if (cmd.equals("cacheMulti")) {
            this.cacheMulti();
        } else if (cmd.equals("cacheSingle")) {
            this.cacheSingle();
        } else if (cmd.equals("cleanUpPermissions")) {
            CleanUpPermissionsUtil.cleanUpAddToPagePermissions(actionRequest);
        } else if (cmd.startsWith("convertProcess.")) {
            redirect = this.convertProcess(actionRequest, actionResponse, cmd);
        } else if (cmd.equals("dlPreviews")) {
            DLPreviewableProcessor.deleteFiles();
        } else if (cmd.equals("gc")) {
            this.gc();
        } else if (cmd.equals("reindex")) {
            this.reindex(actionRequest);
        } else if (cmd.equals("runScript")) {
            this.runScript(portletConfig, actionRequest, actionResponse);
        } else if (cmd.equals("shutdown")) {
            this.shutdown(actionRequest);
        } else if (cmd.equals("threadDump")) {
            this.threadDump();
        } else if (cmd.equals("updateCaptcha")) {
            this.updateCaptcha(actionRequest, preferences);
        } else if (cmd.equals("updateExternalServices")) {
            this.updateExternalServices(actionRequest, preferences);
        } else if (cmd.equals("updateFileUploads")) {
            this.updateFileUploads(actionRequest, preferences);
        } else if (cmd.equals("updateLogLevels")) {
            this.updateLogLevels(actionRequest);
        } else if (cmd.equals("updateMail")) {
            this.updateMail(actionRequest, preferences);
        } else if (cmd.equals("verifyPluginTables")) {
            this.verifyPluginTables();
        }
        this.sendRedirect(actionRequest, actionResponse, redirect);
    }

    protected void addLogLevel(ActionRequest actionRequest) throws Exception {
        String loggerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"loggerName");
        String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)"priority");
        Log4JUtil.setLevel((String)loggerName, (String)priority, (boolean)true);
    }

    protected void cacheDb() throws Exception {
        CacheRegistryUtil.clear();
    }

    protected void cacheMulti() throws Exception {
        MultiVMPoolUtil.clear();
    }

    protected void cacheSingle() throws Exception {
        WebCachePoolUtil.clear();
    }

    protected String convertProcess(ActionRequest actionRequest, ActionResponse actionResponse, String cmd) throws Exception {
        String path;
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        PortletSession portletSession = actionRequest.getPortletSession();
        String className = StringUtil.replaceFirst((String)cmd, (String)"convertProcess.", (String)"");
        ConvertProcess convertProcess = (ConvertProcess)InstancePool.get((String)className);
        String[] parameters = convertProcess.getParameterNames();
        if (parameters != null) {
            String[] values = new String[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                String parameter = String.valueOf(className) + "." + parameters[i];
                if (parameters[i].contains("=")) {
                    String[] parameterPair = StringUtil.split((String)parameters[i], (char)'=');
                    parameter = String.valueOf(className) + "." + parameterPair[0];
                }
                values[i] = ParamUtil.getString((PortletRequest)actionRequest, (String)parameter);
                ++i;
            }
            convertProcess.setParameterValues(values);
        }
        if ((path = convertProcess.getPath()) != null) {
            PortletURL portletURL = actionResponseImpl.createRenderURL();
            portletURL.setWindowState(WindowState.MAXIMIZED);
            portletURL.setParameter("struts_action", path);
            return portletURL.toString();
        }
        MaintenanceUtil.maintain(portletSession.getId(), className);
        MessageBusUtil.sendMessage((String)"liferay/convert_process", (Object)className);
        return null;
    }

    protected void gc() throws Exception {
        Runtime.getRuntime().gc();
    }

    protected String getFileExtensions(ActionRequest actionRequest, String name) {
        String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
        return value.replace(", .", ",.");
    }

    protected void reindex(ActionRequest actionRequest) throws Exception {
        String portletId = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletId");
        long[] companyIds = PortalInstances.getCompanyIds();
        if (LuceneHelperUtil.isLoadIndexFromClusterEnabled()) {
            MessageValuesThreadLocal.setValue("CLUSTER_FORWARD_MESSAGE", true);
        }
        if (Validator.isNull((String)portletId)) {
            long[] lArray = companyIds;
            int n = companyIds.length;
            int n2 = 0;
            while (n2 < n) {
                long companyId = lArray[n2];
                try {
                    LuceneIndexer indexer = new LuceneIndexer(companyId);
                    indexer.reindex();
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
                ++n2;
            }
        } else {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyIds[0], (String)portletId);
            if (portlet == null) {
                return;
            }
            List indexers = portlet.getIndexerInstances();
            if (indexers == null) {
                return;
            }
            for (Indexer indexer : indexers) {
                long[] lArray = companyIds;
                int n = companyIds.length;
                int n3 = 0;
                while (n3 < n) {
                    long companyId = lArray[n3];
                    ShardUtil.pushCompanyService((long)companyId);
                    try {
                        SearchEngineUtil.deletePortletDocuments((long)companyId, (String)portletId);
                        indexer.reindex(new String[]{String.valueOf(companyId)});
                    }
                    catch (Exception e) {
                        _log.error((Object)e, (Throwable)e);
                    }
                    ShardUtil.popCompanyService();
                    ++n3;
                }
            }
        }
        if (LuceneHelperUtil.isLoadIndexFromClusterEnabled()) {
            Address localClusterNodeAddress = ClusterExecutorUtil.getLocalClusterNodeAddress();
            ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)new MethodHandler(_loadIndexesFromClusterMethodKey, new Object[]{companyIds, localClusterNodeAddress}), (boolean)true);
            ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
            return;
        }
    }

    protected void runScript(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String language = ParamUtil.getString((PortletRequest)actionRequest, (String)"language");
        String script = ParamUtil.getString((PortletRequest)actionRequest, (String)"script");
        PortletContext portletContext = portletConfig.getPortletContext();
        Map portletObjects = ScriptingUtil.getPortletObjects((PortletConfig)portletConfig, (PortletContext)portletContext, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)unsyncByteArrayOutputStream);
        portletObjects.put("out", unsyncPrintWriter);
        try {
            SessionMessages.add((PortletRequest)actionRequest, (String)"language", (Object)language);
            SessionMessages.add((PortletRequest)actionRequest, (String)"script", (Object)script);
            ScriptingUtil.exec(null, (Map)portletObjects, (String)language, (String)script);
            unsyncPrintWriter.flush();
            SessionMessages.add((PortletRequest)actionRequest, (String)"script_output", (Object)unsyncByteArrayOutputStream.toString());
        }
        catch (ScriptingException se) {
            SessionErrors.add((PortletRequest)actionRequest, (String)ScriptingException.class.getName(), (Object)((Object)se));
            _log.error((Object)se.getMessage());
        }
    }

    protected void shutdown(ActionRequest actionRequest) throws Exception {
        long minutes = (long)ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minutes") * 60000L;
        String message = ParamUtil.getString((PortletRequest)actionRequest, (String)"message");
        if (minutes <= 0L) {
            ShutdownUtil.cancel();
        } else {
            ShutdownUtil.shutdown(minutes, message);
        }
    }

    protected void threadDump() throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)ThreadUtil.threadDump());
        } else {
            _log.error((Object)("Thread dumps require the log level to be at least INFO for " + ((Object)((Object)this)).getClass().getName()));
        }
    }

    protected void updateCaptcha(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean reCaptchaEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"reCaptchaEnabled");
        String reCaptchaPrivateKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        String reCaptchaPublicKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        SimpleCaptchaImpl captcha = null;
        captcha = reCaptchaEnabled ? new ReCaptchaImpl() : new SimpleCaptchaImpl();
        this.validateCaptcha(actionRequest);
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.setValue("captcha.engine.impl", captcha.getClass().getName());
            preferences.setValue("captcha.engine.recaptcha.key.private", reCaptchaPrivateKey);
            preferences.setValue("captcha.engine.recaptcha.key.public", reCaptchaPublicKey);
            preferences.store();
            CaptchaImpl captchaImpl = (CaptchaImpl)CaptchaUtil.getCaptcha();
            captchaImpl.setCaptcha(captcha);
        }
    }

    protected void updateExternalServices(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        boolean imageMagickEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"imageMagickEnabled");
        String imageMagickPath = ParamUtil.getString((PortletRequest)actionRequest, (String)"imageMagickPath");
        boolean openOfficeEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"openOfficeEnabled");
        int openOfficePort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"openOfficePort");
        boolean xugglerEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"xugglerEnabled");
        preferences.setValue("imagemagick.enabled", String.valueOf(imageMagickEnabled));
        preferences.setValue("imagemagick.global.search.path", imageMagickPath);
        preferences.setValue("openoffice.server.enabled", String.valueOf(openOfficeEnabled));
        preferences.setValue("openoffice.server.port", String.valueOf(openOfficePort));
        preferences.setValue("xuggler.enabled", String.valueOf(xugglerEnabled));
        preferences.store();
        PDFProcessorUtil.reset();
    }

    protected void updateFileUploads(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        long dlFileEntryThumbnailMaxHeight = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileEntryThumbnailMaxHeight");
        long dlFileEntryThumbnailMaxWidth = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileEntryThumbnailMaxWidth");
        String dlFileExtensions = this.getFileExtensions(actionRequest, "dlFileExtensions");
        long dlFileMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileMaxSize");
        String journalImageExtensions = this.getFileExtensions(actionRequest, "journalImageExtensions");
        long journalImageSmallMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"journalImageSmallMaxSize");
        String shoppingImageExtensions = this.getFileExtensions(actionRequest, "shoppingImageExtensions");
        long scImageMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageMaxSize");
        long scImageThumbnailMaxHeight = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageThumbnailMaxHeight");
        long scImageThumbnailMaxWidth = ParamUtil.getLong((PortletRequest)actionRequest, (String)"scImageThumbnailMaxWidth");
        long shoppingImageLargeMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageLargeMaxSize");
        long shoppingImageMediumMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageMediumMaxSize");
        long shoppingImageSmallMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageSmallMaxSize");
        long uploadServletRequestImplMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"uploadServletRequestImplMaxSize");
        String uploadServletRequestImplTempDir = ParamUtil.getString((PortletRequest)actionRequest, (String)"uploadServletRequestImplTempDir");
        long usersImageMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"usersImageMaxSize");
        preferences.setValue("dl.file.entry.thumbnail.max.height", String.valueOf(dlFileEntryThumbnailMaxHeight));
        preferences.setValue("dl.file.entry.thumbnail.max.width", String.valueOf(dlFileEntryThumbnailMaxWidth));
        preferences.setValue("dl.file.extensions", dlFileExtensions);
        preferences.setValue("dl.file.max.size", String.valueOf(dlFileMaxSize));
        preferences.setValue("journal.image.extensions", journalImageExtensions);
        preferences.setValue("journal.image.small.max.size", String.valueOf(journalImageSmallMaxSize));
        preferences.setValue("shopping.image.extensions", shoppingImageExtensions);
        preferences.setValue("shopping.image.large.max.size", String.valueOf(shoppingImageLargeMaxSize));
        preferences.setValue("shopping.image.medium.max.size", String.valueOf(shoppingImageMediumMaxSize));
        preferences.setValue("shopping.image.small.max.size", String.valueOf(shoppingImageSmallMaxSize));
        preferences.setValue("sc.image.max.size", String.valueOf(scImageMaxSize));
        preferences.setValue("sc.image.thumbnail.max.height", String.valueOf(scImageThumbnailMaxHeight));
        preferences.setValue("sc.image.thumbnail.max.width", String.valueOf(scImageThumbnailMaxWidth));
        preferences.setValue("com.liferay.portal.upload.UploadServletRequestImpl.max.size", String.valueOf(uploadServletRequestImplMaxSize));
        if (Validator.isNotNull((String)uploadServletRequestImplTempDir)) {
            preferences.setValue("com.liferay.portal.upload.UploadServletRequestImpl.temp.dir", uploadServletRequestImplTempDir);
            UploadServletRequestImpl.setTempDir(new File(uploadServletRequestImplTempDir));
        }
        preferences.setValue("users.image.max.size", String.valueOf(usersImageMaxSize));
        preferences.store();
    }

    protected void updateLogLevels(ActionRequest actionRequest) throws Exception {
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("logLevel")) continue;
            String loggerName = name.substring(8, name.length());
            String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)name, (String)Level.INFO.toString());
            Log4JUtil.setLevel((String)loggerName, (String)priority, (boolean)true);
        }
    }

    protected void updateMail(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String advancedProperties = ParamUtil.getString((PortletRequest)actionRequest, (String)"advancedProperties");
        String pop3Host = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Host");
        String pop3Password = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Password");
        int pop3Port = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"pop3Port");
        boolean pop3Secure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"pop3Secure");
        String pop3User = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3User");
        String smtpHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpHost");
        String smtpPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpPassword");
        int smtpPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"smtpPort");
        boolean smtpSecure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"smtpSecure");
        String smtpUser = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpUser");
        String storeProtocol = "pop3";
        if (pop3Secure) {
            storeProtocol = "pop3s";
        }
        String transportProtocol = "smtp";
        if (smtpSecure) {
            transportProtocol = "smtps";
        }
        preferences.setValue("mail.session.mail", "true");
        preferences.setValue("mail.session.mail.advanced.properties", advancedProperties);
        preferences.setValue("mail.session.mail.pop3.host", pop3Host);
        preferences.setValue("mail.session.mail.pop3.password", pop3Password);
        preferences.setValue("mail.session.mail.pop3.port", String.valueOf(pop3Port));
        preferences.setValue("mail.session.mail.pop3.user", pop3User);
        preferences.setValue("mail.session.mail.smtp.host", smtpHost);
        preferences.setValue("mail.session.mail.smtp.password", smtpPassword);
        preferences.setValue("mail.session.mail.smtp.port", String.valueOf(smtpPort));
        preferences.setValue("mail.session.mail.smtp.user", smtpUser);
        preferences.setValue("mail.session.mail.store.protocol", storeProtocol);
        preferences.setValue("mail.session.mail.transport.protocol", transportProtocol);
        preferences.store();
        MailServiceUtil.clearSession();
    }

    protected void validateCaptcha(ActionRequest actionRequest) throws Exception {
        boolean reCaptchaEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"reCaptchaEnabled");
        if (!reCaptchaEnabled) {
            return;
        }
        String reCaptchaPrivateKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        String reCaptchaPublicKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        if (Validator.isNull((String)reCaptchaPublicKey)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        } else if (Validator.isNull((String)reCaptchaPrivateKey)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        }
    }

    protected void verifyPluginTables() throws Exception {
        ServiceComponentLocalServiceUtil.verifyDB();
    }
}

