/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.activities.action;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;
import com.liferay.portlet.social.service.SocialActivityInterpreterLocalServiceUtil;
import com.liferay.portlet.social.service.SocialActivityLocalServiceUtil;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    @Override
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        resourceResponse.setContentType("text/xml; charset=UTF-8");
        OutputStream outputStream = resourceResponse.getPortletOutputStream();
        try {
            byte[] bytes = this.getRSS((PortletRequest)resourceRequest);
            outputStream.write(bytes);
        }
        finally {
            outputStream.close();
        }
    }

    protected List<SocialActivity> getActivities(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        Group group = GroupLocalServiceUtil.getGroup((long)themeDisplay.getScopeGroupId());
        int start = 0;
        int end = 10;
        if (group.isOrganization()) {
            return SocialActivityLocalServiceUtil.getOrganizationActivities((long)group.getOrganizationId(), (int)start, (int)end);
        }
        if (group.isRegularSite()) {
            return SocialActivityLocalServiceUtil.getGroupActivities((long)group.getGroupId(), (int)start, (int)end);
        }
        if (group.isUser()) {
            return SocialActivityLocalServiceUtil.getUserActivities((long)group.getClassPK(), (int)start, (int)end);
        }
        return Collections.emptyList();
    }

    protected byte[] getRSS(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        String feedTitle = ParamUtil.getString((PortletRequest)portletRequest, (String)"feedTitle");
        syndFeed.setDescription(feedTitle);
        syndFeed.setFeedType(RSSUtil.FEED_TYPE_DEFAULT);
        String feedLink = String.valueOf(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay)) + "/-/" + "activities/rss";
        syndFeed.setLink(feedLink);
        syndFeed.setTitle(feedTitle);
        ArrayList<SyndEntryImpl> syndEntries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(syndEntries);
        List<SocialActivity> activities = this.getActivities(portletRequest);
        for (SocialActivity activity : activities) {
            SocialActivityFeedEntry activityFeedEntry = SocialActivityInterpreterLocalServiceUtil.interpret((SocialActivity)activity, (ThemeDisplay)themeDisplay);
            if (activityFeedEntry == null) continue;
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType(RSSUtil.FEED_TYPE_DEFAULT);
            syndContent.setValue(activityFeedEntry.getBody());
            syndEntry.setDescription((SyndContent)syndContent);
            if (Validator.isNotNull((String)activityFeedEntry.getLink())) {
                syndEntry.setLink(activityFeedEntry.getLink());
            }
            syndEntry.setPublishedDate(new Date(activity.getCreateDate()));
            syndEntry.setTitle(HtmlUtil.extractText((String)activityFeedEntry.getTitle()));
            syndEntries.add(syndEntry);
        }
        String rss = "";
        try {
            rss = RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
        return rss.getBytes("UTF-8");
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }
}

