/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashCode;
import com.liferay.portal.kernel.util.HashCodeFactoryUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.BasePreferencesImpl;
import com.liferay.portlet.Preference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesImpl
extends BasePreferencesImpl
implements Cloneable,
PortletPreferences,
Serializable {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesImpl.class);
    private PortletPreferences _defaultPreferences;
    private long _plid;
    private String _portletId;

    public PortletPreferencesImpl() {
        this(0L, 0L, 0, 0L, null, Collections.emptyMap());
    }

    public PortletPreferencesImpl(long companyId, long ownerId, int ownerType, long plid, String portletId, Map<String, Preference> preferences) {
        super(companyId, ownerId, ownerType, preferences);
        this._plid = plid;
        this._portletId = portletId;
    }

    public Object clone() {
        return new PortletPreferencesImpl(this.getCompanyId(), this.getOwnerId(), this.getOwnerType(), this._plid, this._portletId, this.getOriginalPreferences());
    }

    public boolean equals(Object obj) {
        PortletPreferencesImpl portletPreferences = (PortletPreferencesImpl)obj;
        if (this == portletPreferences) {
            return true;
        }
        return this.getCompanyId() == portletPreferences.getCompanyId() && this.getOwnerId() == portletPreferences.getOwnerId() && this.getOwnerType() == portletPreferences.getOwnerType() && this.getPlid() == portletPreferences.getPlid() && this.getPortletId().equals(portletPreferences.getPortletId()) && this.getMap().equals(portletPreferences.getMap());
    }

    public long getPlid() {
        return this._plid;
    }

    public int hashCode() {
        HashCode hashCode = HashCodeFactoryUtil.getHashCode();
        hashCode.append(this.getCompanyId());
        hashCode.append(this.getOwnerId());
        hashCode.append(this.getOwnerType());
        hashCode.append(this._plid);
        hashCode.append((Object)this._portletId);
        hashCode.append(this.getPreferences());
        return hashCode.toHashCode();
    }

    @Override
    public void reset(String key) throws ReadOnlyException {
        block8: {
            if (this.isReadOnly(key)) {
                throw new ReadOnlyException(key);
            }
            if (this._defaultPreferences == null) {
                try {
                    if (this._portletId != null) {
                        this._defaultPreferences = PortletPreferencesLocalServiceUtil.getDefaultPreferences((long)this.getCompanyId(), (String)this._portletId);
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
        String[] defaultValues = null;
        if (this._defaultPreferences != null) {
            defaultValues = this._defaultPreferences.getValues(key, defaultValues);
        }
        if (defaultValues != null) {
            this.setValues(key, defaultValues);
        } else {
            Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
            modifiedPreferences.remove(key);
        }
    }

    @Override
    public void store() throws IOException, ValidatorException {
        if (this._portletId == null) {
            throw new UnsupportedOperationException();
        }
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this.getCompanyId(), (String)this._portletId);
            PreferencesValidator preferencesValidator = PortalUtil.getPreferencesValidator((Portlet)portlet);
            if (preferencesValidator != null) {
                preferencesValidator.validate((PortletPreferences)this);
            }
            PortletPreferencesLocalServiceUtil.updatePreferences((long)this.getOwnerId(), (int)this.getOwnerType(), (long)this._plid, (String)this._portletId, (PortletPreferences)this);
        }
        catch (SystemException se) {
            throw new IOException(se.getMessage());
        }
    }

    protected String getPortletId() {
        return this._portletId;
    }
}

