/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.simple.Element;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.xml.StAXReaderUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortletPreferencesFactory;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.Preference;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesFactoryImpl
implements PortletPreferencesFactory {
    public PortletPreferences fromDefaultXML(String xml) throws SystemException {
        PortletPreferencesImpl portletPreferencesImpl = new PortletPreferencesImpl();
        Map<String, Preference> preferencesMap = portletPreferencesImpl.getPreferences();
        this.populateMap(xml, preferencesMap);
        return portletPreferencesImpl;
    }

    public PortletPreferencesImpl fromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws SystemException {
        HashMap<String, Preference> preferencesMap = new HashMap<String, Preference>();
        this.populateMap(xml, preferencesMap);
        return new PortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, preferencesMap);
    }

    public PortalPreferencesImpl fromXML(long companyId, long ownerId, int ownerType, String xml) throws SystemException {
        HashMap<String, Preference> preferencesMap = new HashMap<String, Preference>();
        this.populateMap(xml, preferencesMap);
        return new PortalPreferencesImpl(companyId, ownerId, ownerType, preferencesMap, false);
    }

    public PortletPreferences getLayoutPortletSetup(Layout layout, String portletId) throws SystemException {
        long ownerId = 0L;
        int ownerType = 3;
        return PortletPreferencesLocalServiceUtil.getPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)portletId);
    }

    public PortalPreferences getPortalPreferences(HttpServletRequest request) throws SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        return this.getPortalPreferences(request.getSession(), themeDisplay.getCompanyId(), themeDisplay.getUserId(), themeDisplay.isSignedIn());
    }

    public PortalPreferences getPortalPreferences(HttpSession session, long companyId, long userId, boolean signedIn) throws SystemException {
        long ownerId = userId;
        int ownerType = 4;
        PortalPreferences portalPreferences = null;
        if (signedIn) {
            PortalPreferencesWrapper portalPreferencesWrapper = (PortalPreferencesWrapper)PortalPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType);
            portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
        } else {
            if (session != null) {
                portalPreferences = (PortalPreferences)session.getAttribute("PORTAL_PREFERENCES");
            }
            if (portalPreferences == null) {
                PortalPreferencesWrapper portalPreferencesWrapper = (PortalPreferencesWrapper)PortalPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType);
                PortalPreferencesImpl portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
                portalPreferences = (PortalPreferences)portalPreferencesImpl.clone();
                if (session != null) {
                    session.setAttribute("PORTAL_PREFERENCES", (Object)portalPreferences);
                }
            }
        }
        portalPreferences.setSignedIn(signedIn);
        return portalPreferences;
    }

    public PortalPreferences getPortalPreferences(long companyId, long userId, boolean signedIn) throws SystemException {
        return this.getPortalPreferences(null, companyId, userId, signedIn);
    }

    public PortalPreferences getPortalPreferences(PortletRequest portletRequest) throws SystemException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getPortalPreferences(request);
    }

    public PortletPreferences getPortletPreferences(HttpServletRequest request, String portletId) throws PortalException, SystemException {
        PortletPreferencesIds portletPreferencesIds = this.getPortletPreferencesIds(request, portletId);
        return PortletPreferencesLocalServiceUtil.getPreferences((PortletPreferencesIds)portletPreferencesIds);
    }

    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest request, Layout layout, String portletId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request, (String)portletId, (boolean)true);
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        boolean modeEditGuest = false;
        String portletMode = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_mode");
        if (portletMode.equals(LiferayPortletMode.EDIT_GUEST.toString()) || layoutTypePortlet != null && layoutTypePortlet.hasModeEditGuestPortletId(portletId)) {
            modeEditGuest = true;
        }
        return this.getPortletPreferencesIds(scopeGroupId, userId, layout, portletId, modeEditGuest);
    }

    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest request, String portletId) throws PortalException, SystemException {
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        return this.getPortletPreferencesIds(request, layout, portletId);
    }

    public PortletPreferencesIds getPortletPreferencesIds(long scopeGroupId, long userId, Layout layout, String portletId, boolean modeEditGuest) throws PortalException, SystemException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        long ownerId = 0L;
        int ownerType = 0;
        long plid = 0L;
        if (modeEditGuest) {
            boolean hasUpdateLayoutPermission = LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE");
            if (layout.isPrivateLayout() || !hasUpdateLayoutPermission) {
                throw new PrincipalException();
            }
        }
        if (portlet.isPreferencesCompanyWide()) {
            ownerId = layout.getCompanyId();
            ownerType = 1;
            plid = 0L;
            portletId = PortletConstants.getRootPortletId((String)portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            ownerId = 0L;
            ownerType = 3;
            plid = layout.getPlid();
            if (!portlet.isPreferencesOwnedByGroup()) {
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getDefaultUserId((long)layout.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        } else {
            plid = 0L;
            if (portlet.isPreferencesOwnedByGroup()) {
                ownerId = scopeGroupId;
                ownerType = 2;
                portletId = PortletConstants.getRootPortletId((String)portletId);
            } else {
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getDefaultUserId((long)layout.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        }
        return new PortletPreferencesIds(layout.getCompanyId(), ownerId, ownerType, plid, portletId);
    }

    public PortletPreferences getPortletSetup(HttpServletRequest request, String portletId) throws PortalException, SystemException {
        return this.getPortletSetup(request, portletId, null);
    }

    public PortletPreferences getPortletSetup(HttpServletRequest request, String portletId, String defaultPreferences) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long scopeGroupId = PortalUtil.getScopeGroupId((HttpServletRequest)request, (String)portletId, (boolean)true);
        return this.getPortletSetup(scopeGroupId, themeDisplay.getLayout(), portletId, defaultPreferences);
    }

    public PortletPreferences getPortletSetup(Layout layout, String portletId, String defaultPreferences) throws SystemException {
        return this.getPortletSetup(0L, layout, portletId, defaultPreferences);
    }

    public PortletPreferences getPortletSetup(long scopeGroupId, Layout layout, String portletId, String defaultPreferences) throws SystemException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)layout.getCompanyId(), (String)portletId);
        boolean uniquePerLayout = false;
        boolean uniquePerGroup = false;
        if (portlet.isPreferencesCompanyWide()) {
            portletId = PortletConstants.getRootPortletId((String)portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            uniquePerLayout = true;
            if (portlet.isPreferencesOwnedByGroup()) {
                uniquePerGroup = true;
            }
        } else if (portlet.isPreferencesOwnedByGroup()) {
            uniquePerGroup = true;
            portletId = PortletConstants.getRootPortletId((String)portletId);
        }
        long ownerId = 0L;
        int ownerType = 3;
        long plid = layout.getPlid();
        if (!uniquePerLayout) {
            plid = 0L;
            if (uniquePerGroup) {
                ownerId = scopeGroupId > 0L ? scopeGroupId : layout.getGroupId();
                ownerType = 2;
            } else {
                ownerId = layout.getCompanyId();
                ownerType = 1;
            }
        }
        return PortletPreferencesLocalServiceUtil.getPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
    }

    public PortletPreferences getPortletSetup(PortletRequest portletRequest) throws PortalException, SystemException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        String portletId = PortalUtil.getPortletId((PortletRequest)portletRequest);
        return this.getPortletSetup(request, portletId);
    }

    public PortletPreferences getPortletSetup(PortletRequest portletRequest, String portletId) throws PortalException, SystemException {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return this.getPortletSetup(request, portletId);
    }

    public Map<Long, PortletPreferences> getPortletSetupMap(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) throws SystemException {
        HashMap<Long, PortletPreferences> portletSetupMap = new HashMap<Long, PortletPreferences>();
        List portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences((long)companyId, (long)groupId, (long)ownerId, (int)ownerType, (String)portletId, (boolean)privateLayout);
        for (com.liferay.portal.model.PortletPreferences portletPreferences : portletPreferencesList) {
            PortletPreferences portletSetup = PortletPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)portletPreferences.getPlid(), (String)portletId);
            portletSetupMap.put(portletPreferences.getPlid(), portletSetup);
        }
        return portletSetupMap;
    }

    public PortletPreferences getPreferences(HttpServletRequest request) {
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletPreferencesImpl portletPreferences = null;
        if (portletRequest != null) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletRequest.getPreferences();
            portletPreferences = portletPreferencesWrapper.getPortletPreferencesImpl();
        }
        return portletPreferences;
    }

    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        return PortalUtil.getPreferencesValidator((Portlet)portlet);
    }

    public PortletPreferences getStrictLayoutPortletSetup(Layout layout, String portletId) throws SystemException {
        long ownerId = 0L;
        int ownerType = 3;
        return PortletPreferencesLocalServiceUtil.getStrictPreferences((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)layout.getPlid(), (String)portletId);
    }

    public String toXML(PortalPreferences portalPreferences) {
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)portalPreferences;
        Map<String, Preference> preferencesMap = portalPreferencesImpl.getPreferences();
        return this.toXML(preferencesMap);
    }

    public String toXML(PortletPreferences portletPreferences) {
        PortletPreferencesImpl portletPreferencesImpl = (PortletPreferencesImpl)portletPreferences;
        Map<String, Preference> preferencesMap = portletPreferencesImpl.getPreferences();
        return this.toXML(preferencesMap);
    }

    protected void populateMap(String xml, Map<String, Preference> preferencesMap) throws SystemException {
        if (Validator.isNull((String)xml)) {
            return;
        }
        XMLEventReader xmlEventReader = null;
        try {
            try {
                XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
                xmlEventReader = xmlInputFactory.createXMLEventReader((Reader)new UnsyncStringReader(xml));
                while (xmlEventReader.hasNext()) {
                    StartElement startElement;
                    String elementName;
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (!xmlEvent.isStartElement() || !(elementName = (startElement = xmlEvent.asStartElement()).getName().getLocalPart()).equals("preference")) continue;
                    Preference preference = this.readPreference(xmlEventReader);
                    preferencesMap.put(preference.getName(), preference);
                }
            }
            catch (XMLStreamException xse) {
                throw new SystemException((Throwable)xse);
            }
        }
        catch (Throwable throwable) {
            if (xmlEventReader != null) {
                try {
                    xmlEventReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            throw throwable;
        }
        if (xmlEventReader != null) {
            try {
                xmlEventReader.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
    }

    protected Preference readPreference(XMLEventReader xmlEventReader) throws XMLStreamException {
        String name = null;
        ArrayList<String> values = new ArrayList<String>();
        boolean readOnly = false;
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            String elementName;
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                String value;
                StartElement startElement = xmlEvent.asStartElement();
                elementName = startElement.getName().getLocalPart();
                if (elementName.equals("name")) {
                    name = StAXReaderUtil.read(xmlEventReader);
                    continue;
                }
                if (elementName.equals("value")) {
                    value = StAXReaderUtil.read(xmlEventReader);
                    values.add(value);
                    continue;
                }
                if (!elementName.equals("read-only")) continue;
                value = StAXReaderUtil.read(xmlEventReader);
                readOnly = GetterUtil.getBoolean((String)value);
                continue;
            }
            if (xmlEvent.isEndElement() && (elementName = (endElement = xmlEvent.asEndElement()).getName().getLocalPart()).equals("preference")) break;
        }
        return new Preference(name, values.toArray(new String[values.size()]), readOnly);
    }

    protected String toXML(Map<String, Preference> preferencesMap) {
        Element portletPreferencesElement = new Element("portlet-preferences", false);
        for (Map.Entry<String, Preference> entry : preferencesMap.entrySet()) {
            Preference preference = entry.getValue();
            Element preferenceElement = portletPreferencesElement.addElement("preference");
            preferenceElement.addElement("name", preference.getName());
            String[] stringArray = preference.getValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                preferenceElement.addElement("value", value);
                ++n2;
            }
            if (!preference.isReadOnly()) continue;
            preferenceElement.addElement("read-only", (Object)Boolean.TRUE);
        }
        return portletPreferencesElement.toXMLString();
    }
}

