/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashCode;
import com.liferay.portal.kernel.util.HashCodeFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portlet.BasePreferencesImpl;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.Preference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.portlet.ReadOnlyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalPreferencesImpl
extends BasePreferencesImpl
implements Cloneable,
PortalPreferences,
Serializable {
    private static final String _RANDOM_KEY = "r";
    private static Log _log = LogFactoryUtil.getLog(PortalPreferences.class);
    private boolean _signedIn;

    public PortalPreferencesImpl() {
        this(0L, 0L, 0, Collections.emptyMap(), false);
    }

    public PortalPreferencesImpl(long companyId, long ownerId, int ownerType, Map<String, Preference> preferences, boolean signedIn) {
        super(companyId, ownerId, ownerType, preferences);
        this._signedIn = signedIn;
    }

    public Object clone() {
        return new PortalPreferencesImpl(this.getCompanyId(), this.getOwnerId(), this.getOwnerType(), this.getOriginalPreferences(), this.isSignedIn());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        PortalPreferencesImpl portalPreferences = (PortalPreferencesImpl)obj;
        if (this == portalPreferences) {
            return true;
        }
        return this.getCompanyId() == portalPreferences.getCompanyId() && this.getOwnerId() == portalPreferences.getOwnerId() && this.getOwnerType() == portalPreferences.getOwnerType() && this.getMap().equals(portalPreferences.getMap());
    }

    @Override
    public String getValue(String namespace, String key) {
        return this.getValue(namespace, key, null);
    }

    public String getValue(String namespace, String key, String defaultValue) {
        key = this._encodeKey(namespace, key);
        return super.getValue(key, defaultValue);
    }

    public String[] getValues(String namespace, String key) {
        return this.getValues(namespace, key, null);
    }

    public String[] getValues(String namespace, String key, String[] defaultValue) {
        key = this._encodeKey(namespace, key);
        return super.getValues(key, defaultValue);
    }

    public int hashCode() {
        HashCode hashCode = HashCodeFactoryUtil.getHashCode();
        hashCode.append(this.getCompanyId());
        hashCode.append(this.getOwnerId());
        hashCode.append(this.getOwnerType());
        hashCode.append(this.getPreferences());
        return hashCode.toHashCode();
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    @Override
    public void reset(String key) throws ReadOnlyException {
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException(key);
        }
        Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
        modifiedPreferences.remove(key);
    }

    public void resetValues(String namespace) {
        try {
            Map<String, Preference> preferences = this.getPreferences();
            for (Map.Entry<String, Preference> entry : preferences.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(namespace) || this.isReadOnly(key)) continue;
                this.reset(key);
            }
            this.store();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public void setValue(String namespace, String key, String value) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        key = this._encodeKey(namespace, key);
        try {
            if (value != null) {
                super.setValue(key, value);
            } else {
                this.reset(key);
            }
            if (this._signedIn) {
                this.store();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void setValues(String namespace, String key, String[] values) {
        if (Validator.isNull((String)key) || key.equals(_RANDOM_KEY)) {
            return;
        }
        key = this._encodeKey(namespace, key);
        try {
            if (values != null) {
                super.setValues(key, values);
            } else {
                this.reset(key);
            }
            if (this._signedIn) {
                this.store();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public void store() throws IOException {
        try {
            PortalPreferencesLocalServiceUtil.updatePreferences((long)this.getOwnerId(), (int)this.getOwnerType(), (PortalPreferences)this);
        }
        catch (SystemException se) {
            throw new IOException(se.getMessage());
        }
    }

    private String _encodeKey(String namespace, String key) {
        if (Validator.isNull((String)namespace)) {
            return key;
        }
        return String.valueOf(namespace) + "#" + key;
    }
}

