/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portlet.Preference;
import com.liferay.util.xml.XMLFormatter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePreferencesImpl
implements Serializable {
    private static final String _NULL_VALUE = "NULL_VALUE";
    private long _companyId;
    private Map<String, Preference> _modifiedPreferences;
    private Map<String, Preference> _originalPreferences;
    private long _ownerId;
    private int _ownerType;

    public BasePreferencesImpl(long companyId, long ownerId, int ownerType, Map<String, Preference> preferences) {
        this._companyId = companyId;
        this._ownerId = ownerId;
        this._ownerType = ownerType;
        this._originalPreferences = preferences;
    }

    public Map<String, String[]> getMap() {
        ConcurrentHashMap<String, String[]> map = new ConcurrentHashMap<String, String[]>();
        Map<String, Preference> preferences = this.getPreferences();
        for (Map.Entry<String, Preference> entry : preferences.entrySet()) {
            String key = entry.getKey();
            Preference preference = entry.getValue();
            String[] actualValues = this.getActualValues(preference.getValues());
            if (actualValues == null) continue;
            map.put(key, actualValues);
        }
        return Collections.unmodifiableMap(map);
    }

    public Enumeration<String> getNames() {
        Map<String, Preference> preferences = this.getPreferences();
        return Collections.enumeration(preferences.keySet());
    }

    public long getOwnerId() {
        return this._ownerId;
    }

    public int getOwnerType() {
        return this._ownerType;
    }

    public String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        String[] values = null;
        if (preference != null) {
            values = preference.getValues();
        }
        if (values != null && values.length > 0) {
            return this.getActualValue(values[0]);
        }
        return this.getActualValue(def);
    }

    public String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        String[] values = null;
        if (preference != null) {
            values = preference.getValues();
        }
        if (values != null && values.length > 0) {
            return this.getActualValues(values);
        }
        return this.getActualValues(def);
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Preference> preferences = this.getPreferences();
        Preference preference = preferences.get(key);
        return preference != null && preference.isReadOnly();
    }

    public void reset() {
        Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
        modifiedPreferences.clear();
    }

    public abstract void reset(String var1) throws ReadOnlyException;

    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        value = this.getXmlSafeValue(value);
        Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
        Preference preference = modifiedPreferences.get(key);
        if (preference == null) {
            preference = new Preference(key, value);
            modifiedPreferences.put(key, preference);
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException(key);
        }
        preference.setValues(new String[]{value});
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        values = this.getXmlSafeValues(values);
        Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
        Preference preference = modifiedPreferences.get(key);
        if (preference == null) {
            preference = new Preference(key, values);
            modifiedPreferences.put(key, preference);
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException(key);
        }
        preference.setValues(values);
    }

    public abstract void store() throws IOException, ValidatorException;

    protected String getActualValue(String value) {
        if (value == null || value.equals(_NULL_VALUE)) {
            return null;
        }
        return XMLFormatter.fromCompactSafe((String)value);
    }

    protected String[] getActualValues(String[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 1 && this.getActualValue(values[0]) == null) {
            return null;
        }
        String[] actualValues = new String[values.length];
        System.arraycopy(values, 0, actualValues, 0, values.length);
        int i = 0;
        while (i < actualValues.length) {
            actualValues[i] = this.getActualValue(actualValues[i]);
            ++i;
        }
        return actualValues;
    }

    protected long getCompanyId() {
        return this._companyId;
    }

    protected Map<String, Preference> getModifiedPreferences() {
        if (this._modifiedPreferences == null) {
            this._modifiedPreferences = new ConcurrentHashMap<String, Preference>();
            for (Map.Entry<String, Preference> entry : this._originalPreferences.entrySet()) {
                String key = entry.getKey();
                Preference preference = entry.getValue();
                this._modifiedPreferences.put(key, (Preference)preference.clone());
            }
        }
        return this._modifiedPreferences;
    }

    protected Map<String, Preference> getOriginalPreferences() {
        return this._originalPreferences;
    }

    protected Map<String, Preference> getPreferences() {
        if (this._modifiedPreferences == null) {
            if (this._originalPreferences == Collections.emptyMap()) {
                this._originalPreferences = new ConcurrentHashMap<String, Preference>();
            }
            return this._originalPreferences;
        }
        return this._modifiedPreferences;
    }

    protected String getXmlSafeValue(String value) {
        if (value == null) {
            return _NULL_VALUE;
        }
        return XMLFormatter.toCompactSafe((String)value);
    }

    protected String[] getXmlSafeValues(String[] values) {
        if (values == null) {
            return new String[]{this.getXmlSafeValue(null)};
        }
        String[] xmlSafeValues = new String[values.length];
        System.arraycopy(values, 0, xmlSafeValues, 0, values.length);
        int i = 0;
        while (i < xmlSafeValues.length) {
            if (xmlSafeValues[i] == null) {
                xmlSafeValues[i] = this.getXmlSafeValue(xmlSafeValues[i]);
            }
            ++i;
        }
        return xmlSafeValues;
    }
}

