/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webserver;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.freemarker.FreeMarkerContext;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngineUtil;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.Validator_IW;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ImageServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerEntry;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.util.AudioProcessorUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.portlet.documentlibrary.util.ImageProcessorImpl;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import com.liferay.portlet.documentlibrary.util.PDFProcessorUtil;
import com.liferay.portlet.documentlibrary.util.VideoProcessorUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.DDLUtil;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServerServlet
extends HttpServlet {
    private static final String _DATE_FORMAT_PATTERN = "d MMM yyyy HH:mm z";
    private static final String _PATH_DDL = "ddl";
    private static final String _TEMPLATE_FTL = "com/liferay/portal/webserver/dependencies/template.ftl";
    private static Log _log = LogFactoryUtil.getLog(WebServerServlet.class);
    private static Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"d MMM yyyy HH:mm z");
    private boolean _lastModified = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasFiles(HttpServletRequest request) {
        try {
            User user = WebServerServlet._getUser(request);
            String path = HttpUtil.fixPath((String)request.getPathInfo());
            String[] pathArray = StringUtil.split((String)path, (char)'/');
            if (pathArray.length == 0) {
                return true;
            }
            if (_PATH_DDL.equals(pathArray[0])) {
                WebServerServlet._checkDDLRecord(pathArray);
                return true;
            }
            if (Validator.isNumber((String)pathArray[0])) {
                WebServerServlet._checkFileEntry(pathArray);
                return true;
            }
            long groupId = WebServerServlet._getGroupId(user.getCompanyId(), pathArray[0]);
            long folderId = 0L;
            int i = 1;
            while (true) {
                if (i >= pathArray.length) {
                    return true;
                }
                try {
                    Folder folder = DLAppLocalServiceUtil.getFolder((long)groupId, (long)folderId, (String)pathArray[i]);
                    folderId = folder.getFolderId();
                }
                catch (NoSuchFolderException noSuchFolderException) {
                    if (i != pathArray.length - 1) {
                        return false;
                    }
                    pathArray = new String[]{String.valueOf(groupId), String.valueOf(folderId), pathArray[i]};
                    WebServerServlet._checkFileEntry(pathArray);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._lastModified = GetterUtil.getBoolean((String)servletConfig.getInitParameter("last_modified"), (boolean)true);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        User user = null;
        try {
            String path;
            String[] pathArray;
            user = WebServerServlet._getUser(request);
            PrincipalThreadLocal.setName((long)user.getUserId());
            PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)request));
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            if (this._lastModified) {
                long ifModifiedSince;
                long lastModified = this.getLastModified(request);
                if (lastModified > 0L && (ifModifiedSince = request.getDateHeader("If-Modified-Since")) > 0L && ifModifiedSince == lastModified) {
                    response.setStatus(304);
                    return;
                }
                if (lastModified > 0L) {
                    response.setDateHeader("Last-Modified", lastModified);
                }
            }
            if ((pathArray = StringUtil.split((String)(path = HttpUtil.fixPath((String)request.getPathInfo())), (char)'/')).length == 0) {
                this.sendGroups(response, user, String.valueOf(request.getServletPath()) + "/" + path);
            } else if (_PATH_DDL.equals(pathArray[0])) {
                this.sendDDLRecordFile(request, response, pathArray);
            } else if (Validator.isNumber((String)pathArray[0])) {
                this.sendFile(request, response, user, pathArray);
            } else {
                if (this.isLegacyImageGalleryImageId(request, response)) {
                    return;
                }
                Image image = this.getImage(request, true);
                if (image != null) {
                    this.writeImage(image, request, response);
                } else {
                    this.sendDocumentLibrary(request, response, user, String.valueOf(request.getServletPath()) + "/" + path, pathArray);
                }
            }
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfee), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (PrincipalException pe) {
            this.processPrincipalException(pe, user, request, response);
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected boolean isLegacyImageGalleryImageId(HttpServletRequest request, HttpServletResponse response) {
        DLFileEntry dlFileEntry;
        long imageId;
        block10: {
            block9: {
                try {
                    imageId = this.getImageId(request);
                    if (imageId != 0L) break block9;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            dlFileEntry = DLFileEntryServiceUtil.fetchFileEntryByImageId((long)imageId);
            if (dlFileEntry != null) break block10;
            return false;
        }
        StringBundler sb = new StringBundler(9);
        sb.append("/documents/");
        sb.append(dlFileEntry.getGroupId());
        sb.append("/");
        sb.append(dlFileEntry.getFolderId());
        sb.append("/");
        sb.append(HttpUtil.encodeURL((String)HtmlUtil.unescape((String)dlFileEntry.getTitle()), (boolean)true));
        sb.append("?version=");
        sb.append(dlFileEntry.getVersion());
        if (imageId == dlFileEntry.getSmallImageId()) {
            sb.append("&imageThumbnail=1");
        } else if (imageId == dlFileEntry.getSmallImageId()) {
            sb.append("&imageThumbnail=2");
        } else if (imageId == dlFileEntry.getSmallImageId()) {
            sb.append("&imageThumbnail=3");
        }
        response.setHeader("Location", sb.toString());
        response.setStatus(301);
        return true;
    }

    protected Image getDefaultImage(HttpServletRequest request, long imageId) {
        String path = GetterUtil.getString((String)request.getPathInfo());
        if (path.startsWith("/company_logo") || path.startsWith("/layout_set_logo") || path.startsWith("/logo")) {
            return ImageLocalServiceUtil.getDefaultCompanyLogo();
        }
        if (path.startsWith("/organization_logo")) {
            return ImageLocalServiceUtil.getDefaultOrganizationLogo();
        }
        if (path.startsWith("/user_female_portrait")) {
            return ImageLocalServiceUtil.getDefaultUserFemalePortrait();
        }
        if (path.startsWith("/user_male_portrait")) {
            return ImageLocalServiceUtil.getDefaultUserMalePortrait();
        }
        if (path.startsWith("/user_portrait")) {
            return ImageLocalServiceUtil.getDefaultUserMalePortrait();
        }
        return null;
    }

    protected FileEntry getFileEntry(String[] pathArray) throws Exception {
        if (pathArray.length == 1) {
            long dlFileShortcutId = GetterUtil.getLong((String)pathArray[0]);
            DLFileShortcut dlFileShortcut = DLAppServiceUtil.getFileShortcut((long)dlFileShortcutId);
            return DLAppServiceUtil.getFileEntry((long)dlFileShortcut.getToFileEntryId());
        }
        if (pathArray.length == 2) {
            long groupId = GetterUtil.getLong((String)pathArray[0]);
            return DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)pathArray[1], (long)groupId);
        }
        long groupId = GetterUtil.getLong((String)pathArray[0]);
        long folderId = GetterUtil.getLong((String)pathArray[1]);
        String fileName = pathArray[2];
        if (fileName.contains("?")) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        return DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
    }

    protected Image getImage(HttpServletRequest request, boolean getDefault) throws PortalException, SystemException {
        Image image = null;
        long imageId = this.getImageId(request);
        if (imageId > 0L) {
            image = ImageServiceUtil.getImage((long)imageId);
            String path = GetterUtil.getString((String)request.getPathInfo());
            if (path.startsWith("/user_female_portrait") || path.startsWith("/user_male_portrait") || path.startsWith("/user_portrait")) {
                image = this.getUserPortraitImageResized(image, imageId);
            }
        } else {
            String uuid = ParamUtil.getString((HttpServletRequest)request, (String)"uuid");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            boolean igSmallImage = ParamUtil.getBoolean((HttpServletRequest)request, (String)"igSmallImage");
            if (Validator.isNotNull((String)uuid) && groupId > 0L) {
                try {
                    FileEntry fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                    image = this.convertFileEntry(igSmallImage, fileEntry);
                }
                catch (Exception exception) {}
            }
        }
        if (getDefault && image == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Get a default image for " + imageId));
            }
            image = this.getDefaultImage(request, imageId);
        }
        return image;
    }

    protected Image convertFileEntry(boolean smallImage, FileEntry fileEntry) throws PortalException, SystemException {
        try {
            ImageImpl image = new ImageImpl();
            image.setModifiedDate(fileEntry.getModifiedDate());
            InputStream is = null;
            is = smallImage ? ImageProcessorUtil.getThumbnailAsStream((FileVersion)fileEntry.getFileVersion(), (int)ImageProcessorImpl.THUMBNAIL_INDEX_DEFAULT) : fileEntry.getContentStream();
            byte[] bytes = FileUtil.getBytes((InputStream)is);
            image.setTextObj(bytes);
            image.setType(fileEntry.getExtension());
            return image;
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected byte[] getImageBytes(HttpServletRequest request, Image image) {
        try {
            if (!PropsValues.IMAGE_AUTO_SCALE) {
                return image.getTextObj();
            }
            ImageBag imageBag = null;
            if (image.getImageId() == 0L) {
                imageBag = ImageToolUtil.read((byte[])image.getTextObj());
                RenderedImage renderedImage = imageBag.getRenderedImage();
                image.setHeight(renderedImage.getHeight());
                image.setWidth(renderedImage.getWidth());
            }
            int height = ParamUtil.getInteger((HttpServletRequest)request, (String)"height", (int)image.getHeight());
            int width = ParamUtil.getInteger((HttpServletRequest)request, (String)"width", (int)image.getWidth());
            if (height >= image.getHeight() && width >= image.getWidth()) {
                return image.getTextObj();
            }
            if (image.getImageId() != 0L) {
                imageBag = ImageToolUtil.read((byte[])image.getTextObj());
            }
            RenderedImage renderedImage = ImageToolUtil.scale((RenderedImage)imageBag.getRenderedImage(), (int)height, (int)width);
            return ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error scaling image " + image.getImageId()), (Throwable)e);
            }
            return image.getTextObj();
        }
    }

    protected long getImageId(HttpServletRequest request) {
        long imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"image_id");
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"img_id");
        }
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong((HttpServletRequest)request, (String)"i_id");
        }
        if (imageId <= 0L) {
            long companyId = ParamUtil.getLong((HttpServletRequest)request, (String)"companyId");
            String screenName = ParamUtil.getString((HttpServletRequest)request, (String)"screenName");
            try {
                if (companyId > 0L && Validator.isNotNull((String)screenName)) {
                    User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
                    imageId = user.getPortraitId();
                }
            }
            catch (Exception exception) {}
        }
        return imageId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getLastModified(HttpServletRequest request) {
        try {
            Date modifiedDate = null;
            Image image = this.getImage(request, true);
            if (image != null) {
                modifiedDate = image.getModifiedDate();
            } else {
                String path = HttpUtil.fixPath((String)request.getPathInfo());
                String[] pathArray = StringUtil.split((String)path, (char)'/');
                if (pathArray.length == 0) {
                    return -1L;
                }
                if (pathArray[0].equals("language")) {
                    return -1L;
                }
                FileEntry fileEntry = null;
                try {
                    fileEntry = this.getFileEntry(pathArray);
                }
                catch (Exception exception) {}
                if (fileEntry == null) {
                    return -1L;
                }
                String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
                if (Validator.isNotNull((String)version)) {
                    FileVersion fileVersion = fileEntry.getFileVersion(version);
                    modifiedDate = fileVersion.getModifiedDate();
                } else {
                    modifiedDate = fileEntry.getModifiedDate();
                }
            }
            if (modifiedDate != null) return modifiedDate.getTime() / 1000L * 1000L;
            modifiedDate = PortalUtil.getUptime();
            return modifiedDate.getTime() / 1000L * 1000L;
        }
        catch (PrincipalException pe) {
            if (!_log.isWarnEnabled()) return -1L;
            _log.warn((Object)pe, (Throwable)pe);
            return -1L;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return -1L;
    }

    protected Image getUserPortraitImageResized(Image image, long imageId) throws PortalException, SystemException {
        if (image == null) {
            return null;
        }
        if (image.getHeight() > PropsValues.USERS_IMAGE_MAX_HEIGHT || image.getWidth() > PropsValues.USERS_IMAGE_MAX_WIDTH) {
            User user = UserLocalServiceUtil.getUserByPortraitId((long)imageId);
            UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])image.getTextObj());
            return ImageLocalServiceUtil.getImage((long)imageId);
        }
        return image;
    }

    protected void processPrincipalException(Throwable t, User user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!user.isDefaultUser()) {
            PortalUtil.sendError((int)401, (Exception)((Exception)t), (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        String redirect = String.valueOf(request.getContextPath()) + "/c" + "/portal/login";
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        redirect = HttpUtil.addParameter((String)redirect, (String)"redirect", (String)currentURL);
        response.sendRedirect(redirect);
    }

    protected void sendDDLRecordFile(HttpServletRequest request, HttpServletResponse response, String[] pathArray) throws Exception {
        if (pathArray.length == 3) {
            long recordId = GetterUtil.getLong((String)pathArray[1]);
            String fieldName = GetterUtil.getString((String)pathArray[2]);
            DDLUtil.sendRecordFileUpload((HttpServletRequest)request, (HttpServletResponse)response, (long)recordId, (String)fieldName);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void sendDocumentLibrary(HttpServletRequest request, HttpServletResponse response, User user, String path, String[] pathArray) throws Exception {
        if (!PropsValues.WEB_SERVER_SERVLET_DIRECTORY_INDEXING_ENABLED) {
            response.setStatus(403);
            return;
        }
        groupId = WebServerServlet._getGroupId(user.getCompanyId(), pathArray[0]);
        folderId = 0L;
        i = 1;
        while (i < pathArray.length) {
            name = pathArray[i];
            try {
                folder = DLAppServiceUtil.getFolder((long)groupId, (long)folderId, (String)name);
                folderId = folder.getFolderId();
            }
            catch (NoSuchFolderException nsfe) {
                if (i != pathArray.length - 1) {
                    throw nsfe;
                }
                title = name;
                this.sendFile(response, user, groupId, folderId, title);
                return;
            }
            ++i;
        }
        try {
            this.sendFile(response, user, groupId, folderId, "index.html");
            return;
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                try {
                    this.sendFile(response, user, groupId, folderId, "index.htm");
                    return;
                }
                catch (NoSuchFileEntryException v0) {
                }
                catch (PrincipalException v1) {}
            } else {
                throw e;
            }
            webServerEntries = new ArrayList<WebServerEntry>();
            webServerEntries.add(new WebServerEntry(path, "../"));
            folders = DLAppServiceUtil.getFolders((long)groupId, (long)folderId);
            ** for (folder : folders)
        }
lbl-1000:
        // 1 sources

        {
            webServerEntry = new WebServerEntry(path, String.valueOf(folder.getName()) + "/", folder.getCreateDate(), folder.getModifiedDate(), folder.getDescription(), 0L);
            webServerEntries.add(webServerEntry);
            continue;
        }
lbl43:
        // 1 sources

        fileEntries = DLAppServiceUtil.getFileEntries((long)groupId, (long)folderId);
        for (FileEntry fileEntry : fileEntries) {
            webServerEntry = new WebServerEntry(path, fileEntry.getTitle(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getDescription(), fileEntry.getSize());
            webServerEntries.add(webServerEntry);
        }
        this.sendHTML(response, path, webServerEntries);
    }

    protected void sendFile(HttpServletRequest request, HttpServletResponse response, User user, String[] pathArray) throws Exception {
        FileEntry fileEntry = this.getFileEntry(pathArray);
        if (fileEntry == null) {
            throw new NoSuchFileEntryException();
        }
        String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
        if (Validator.isNull((String)version) && Validator.isNotNull((String)fileEntry.getVersion())) {
            version = fileEntry.getVersion();
        }
        String tempFileId = DLUtil.getTempFileId((long)fileEntry.getFileEntryId(), (String)version);
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        String fileName = fileVersion.getTitle();
        String extension = fileVersion.getExtension();
        if (Validator.isNotNull((String)extension) && !fileName.endsWith("." + extension)) {
            fileName = String.valueOf(fileName) + "." + extension;
        }
        boolean converted = false;
        String targetExtension = ParamUtil.getString((HttpServletRequest)request, (String)"targetExtension");
        int imageThumbnail = ParamUtil.getInteger((HttpServletRequest)request, (String)"imageThumbnail");
        int documentThumbnail = ParamUtil.getInteger((HttpServletRequest)request, (String)"documentThumbnail");
        int previewFileIndex = ParamUtil.getInteger((HttpServletRequest)request, (String)"previewFileIndex");
        boolean audioPreview = ParamUtil.getBoolean((HttpServletRequest)request, (String)"audioPreview");
        boolean videoPreview = ParamUtil.getBoolean((HttpServletRequest)request, (String)"videoPreview");
        int videoThumbnail = ParamUtil.getInteger((HttpServletRequest)request, (String)"videoThumbnail");
        InputStream inputStream = null;
        long contentLength = 0L;
        if (imageThumbnail > 0 && imageThumbnail <= 3) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(fileVersion.getExtension());
            int thumbnailIndex = imageThumbnail - 1;
            inputStream = ImageProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = ImageProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else if (documentThumbnail > 0 && documentThumbnail <= 3) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("png");
            int thumbnailIndex = documentThumbnail - 1;
            inputStream = PDFProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = PDFProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else if (previewFileIndex > 0) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("png");
            inputStream = PDFProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (int)previewFileIndex);
            contentLength = PDFProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (int)previewFileIndex);
            converted = true;
        } else if (audioPreview) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("mp3");
            inputStream = AudioProcessorUtil.getPreviewAsStream((FileVersion)fileVersion);
            contentLength = AudioProcessorUtil.getPreviewFileSize((FileVersion)fileVersion);
            converted = true;
        } else if (videoPreview) {
            String type = ParamUtil.getString((HttpServletRequest)request, (String)"type");
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(type);
            inputStream = VideoProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (String)type);
            contentLength = VideoProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (String)type);
            response.setHeader("Accept-Ranges", "bytes");
            List ranges = null;
            try {
                ranges = ServletResponseUtil.getRanges((HttpServletRequest)request, (HttpServletResponse)response, (long)contentLength);
            }
            catch (IOException ioe) {
                if (_log.isErrorEnabled()) {
                    _log.error((Throwable)ioe);
                }
                response.setHeader("Content-Range", "bytes */" + contentLength);
                response.sendError(416);
                return;
            }
            if (ranges != null && ranges.size() > 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Video range requested");
                }
                String contentType = MimeTypesUtil.getContentType((String)fileName);
                ServletResponseUtil.write((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (List)ranges, (InputStream)inputStream, (long)contentLength, (String)contentType);
                return;
            }
            converted = true;
        } else if (videoThumbnail > 0 && videoThumbnail <= 3) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat("jpg");
            int thumbnailIndex = videoThumbnail - 1;
            inputStream = VideoProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = VideoProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else {
            File convertedFile;
            inputStream = fileVersion.getContentStream(true);
            contentLength = fileVersion.getSize();
            if (Validator.isNotNull((String)targetExtension) && (convertedFile = DocumentConversionUtil.convert(tempFileId, inputStream, extension, targetExtension)) != null) {
                fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(targetExtension);
                inputStream = new FileInputStream(convertedFile);
                contentLength = convertedFile.length();
                converted = true;
            }
        }
        String contentType = null;
        contentType = converted ? MimeTypesUtil.getContentType((String)fileName) : fileVersion.getMimeType();
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)inputStream, (long)contentLength, (String)contentType);
    }

    protected void sendFile(HttpServletResponse response, User user, long groupId, long folderId, String title) throws Exception {
        FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
        String contentType = fileEntry.getMimeType();
        response.setContentType(contentType);
        InputStream inputStream = fileEntry.getContentStream();
        ServletResponseUtil.write((HttpServletResponse)response, (InputStream)inputStream);
    }

    protected void sendGroups(HttpServletResponse response, User user, String path) throws Exception {
        if (!PropsValues.WEB_SERVER_SERVLET_DIRECTORY_INDEXING_ENABLED) {
            response.setStatus(403);
            return;
        }
        ArrayList<WebServerEntry> webServerEntries = new ArrayList<WebServerEntry>();
        List groups = WebDAVUtil.getGroups((User)user);
        for (Group group : groups) {
            String name = HttpUtil.fixPath((String)group.getFriendlyURL());
            WebServerEntry webServerEntry = new WebServerEntry(path, String.valueOf(name) + "/", null, null, group.getDescription(), 0L);
            webServerEntries.add(webServerEntry);
        }
        this.sendHTML(response, path, webServerEntries);
    }

    protected void sendHTML(HttpServletResponse response, String path, List<WebServerEntry> webServerEntries) throws Exception {
        FreeMarkerContext freeMarkerContext = FreeMarkerEngineUtil.getWrappedRestrictedToolsContext();
        freeMarkerContext.put("dateFormat", (Object)_dateFormat);
        freeMarkerContext.put("entries", webServerEntries);
        freeMarkerContext.put("path", (Object)HttpUtil.encodePath((String)path));
        freeMarkerContext.put("serverInfo", (Object)ReleaseInfo.getServerInfo());
        freeMarkerContext.put("validator", (Object)Validator_IW.getInstance());
        String html = FreeMarkerUtil.process(_TEMPLATE_FTL, freeMarkerContext);
        response.setContentType("text/html; charset=UTF-8");
        ServletResponseUtil.write((HttpServletResponse)response, (String)html);
    }

    protected void writeImage(Image image, HttpServletRequest request, HttpServletResponse response) {
        block6: {
            if (image == null) {
                return;
            }
            String contentType = null;
            String type = image.getType();
            if (!type.equals("na")) {
                contentType = MimeTypesUtil.getContentType((String)("A." + type));
                response.setContentType(contentType);
            }
            String fileName = ParamUtil.getString((HttpServletRequest)request, (String)"fileName");
            try {
                byte[] bytes = this.getImageBytes(request, image);
                if (Validator.isNotNull((String)fileName)) {
                    ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (byte[])bytes, (String)contentType);
                } else {
                    ServletResponseUtil.write((HttpServletResponse)response, (byte[])bytes);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    private static void _checkDDLRecord(String[] pathArray) throws Exception {
        if (pathArray.length == 2) {
            long recordId = GetterUtil.getLong((String)pathArray[1]);
            DDLRecordLocalServiceUtil.getRecord((long)recordId);
        }
    }

    private static void _checkFileEntry(String[] pathArray) throws Exception {
        if (pathArray.length == 1) {
            long dlFileShortcutId = GetterUtil.getLong((String)pathArray[0]);
            DLFileShortcut dlFileShortcut = DLAppLocalServiceUtil.getFileShortcut((long)dlFileShortcutId);
            DLAppLocalServiceUtil.getFileEntry((long)dlFileShortcut.getToFileEntryId());
        } else if (pathArray.length != 2) {
            long groupId = GetterUtil.getLong((String)pathArray[0]);
            long folderId = GetterUtil.getLong((String)pathArray[1]);
            String fileName = pathArray[2];
            try {
                DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
            }
            catch (RepositoryException repositoryException) {}
        }
    }

    private static long _getGroupId(long companyId, String name) throws Exception {
        try {
            Group group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)("/" + name));
            return group.getGroupId();
        }
        catch (NoSuchGroupException noSuchGroupException) {
            User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)name);
            Group group = user.getGroup();
            return group.getGroupId();
        }
    }

    private static User _getUser(HttpServletRequest request) throws Exception {
        User user;
        HttpSession session = request.getSession();
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession((HttpSession)session);
        }
        if ((user = PortalUtil.getUser((HttpServletRequest)request)) != null) {
            return user;
        }
        String userIdString = (String)session.getAttribute("j_username");
        String password = (String)session.getAttribute("j_password");
        if (userIdString != null && password != null) {
            long userId = GetterUtil.getLong((String)userIdString);
            user = UserLocalServiceUtil.getUser((long)userId);
        } else {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            Company company = CompanyLocalServiceUtil.getCompany((long)companyId);
            user = company.getDefaultUser();
        }
        return user;
    }
}

