/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.WebDAVProps;
import com.liferay.portal.service.WebDAVPropsLocalServiceUtil;
import com.liferay.portal.webdav.InvalidRequestException;
import com.liferay.portal.webdav.LockException;
import com.liferay.portal.webdav.methods.BasePropMethodImpl;
import com.liferay.util.xml.XMLFormatter;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProppatchMethodImpl
extends BasePropMethodImpl {
    private static Log _log = LogFactoryUtil.getLog(ProppatchMethodImpl.class);

    @Override
    public int process(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            Set<QName> props = this.processInstructions(webDavRequest);
            return this.writeResponseXML(webDavRequest, props);
        }
        catch (InvalidRequestException ire) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)ire.getMessage(), (Throwable)((Object)ire));
            }
            return 400;
        }
        catch (LockException lockException) {
            return 423;
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    protected WebDAVProps getStoredProperties(WebDAVRequest webDavRequest) throws PortalException, SystemException {
        Lock lock;
        WebDAVStorage storage = webDavRequest.getWebDAVStorage();
        Resource resource = storage.getResource(webDavRequest);
        WebDAVProps webDavProps = null;
        if (resource.getPrimaryKey() <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"There is no primary key set for resource");
            }
            throw new InvalidRequestException();
        }
        if (resource.isLocked() && ((lock = resource.getLock()) == null || !lock.getUuid().equals(webDavRequest.getLockUuid()))) {
            throw new LockException();
        }
        webDavProps = WebDAVPropsLocalServiceUtil.getWebDAVProps((long)webDavRequest.getCompanyId(), (String)resource.getClassName(), (long)resource.getPrimaryKey());
        return webDavProps;
    }

    protected Set<QName> processInstructions(WebDAVRequest webDavRequest) throws InvalidRequestException, LockException {
        try {
            HashSet<QName> newProps = new HashSet<QName>();
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            WebDAVProps webDavProps = this.getStoredProperties(webDavRequest);
            String xml = new String(FileUtil.getBytes((InputStream)request.getInputStream()));
            if (Validator.isNull((String)xml)) {
                return newProps;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Request XML: \n" + XMLFormatter.toString((String)xml, (String)"    ")));
            }
            Document document = SAXReaderUtil.read((String)xml);
            Element rootElement = document.getRootElement();
            for (Element instructionElement : rootElement.elements()) {
                List propElements = instructionElement.elements();
                if (propElements.size() != 1) {
                    throw new InvalidRequestException("There should only be one <prop /> per set or remove instruction.");
                }
                Element propElement = (Element)propElements.get(0);
                if (!propElement.getName().equals("prop") || !propElement.getNamespaceURI().equals(WebDAVUtil.DAV_URI.getURI())) {
                    throw new InvalidRequestException("Invalid <prop /> element " + propElement);
                }
                List customPropElements = propElement.elements();
                for (Element customPropElement : customPropElements) {
                    String name = customPropElement.getName();
                    String prefix = customPropElement.getNamespacePrefix();
                    String uri = customPropElement.getNamespaceURI();
                    String text = customPropElement.getText();
                    Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
                    if (instructionElement.getName().equals("set")) {
                        if (Validator.isNull((String)text)) {
                            webDavProps.addProp(name, prefix, uri);
                        } else {
                            webDavProps.addProp(name, prefix, uri, text);
                        }
                        newProps.add(SAXReaderUtil.createQName((String)customPropElement.getName(), (Namespace)namespace));
                        continue;
                    }
                    if (instructionElement.getName().equals("remove")) {
                        webDavProps.removeProp(name, prefix, uri);
                        continue;
                    }
                    throw new InvalidRequestException("Instead of set/remove instruction, received " + instructionElement);
                }
            }
            WebDAVPropsLocalServiceUtil.storeWebDAVProps((WebDAVProps)webDavProps);
            return newProps;
        }
        catch (LockException le) {
            throw le;
        }
        catch (Exception e) {
            throw new InvalidRequestException(e);
        }
    }
}

