/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Group;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public Resource getResource(WebDAVRequest webDavRequest) throws WebDAVException {
        this.verifyGroup(webDavRequest);
        String path = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        return new BaseResourceImpl(path, "", "");
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        this.verifyGroup(webDavRequest);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String path = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        for (String token : WebDAVUtil.getStorageTokens()) {
            resources.add((Resource)new BaseResourceImpl(path, token, token));
        }
        return resources;
    }

    protected void verifyGroup(WebDAVRequest webDavRequest) throws WebDAVException {
        String path = webDavRequest.getPath();
        try {
            long userId = webDavRequest.getUserId();
            List groups = WebDAVUtil.getGroups((long)userId);
            for (Group group : groups) {
                if (!path.equals(group.getFriendlyURL())) continue;
                return;
            }
        }
        catch (Exception exception) {}
        throw new WebDAVException("Invalid group for given credentials " + webDavRequest.getRootPath() + path);
    }
}

