/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.store.StoreFactory;

public class VerifyProperties
extends VerifyProcess {
    private static final String[][] _MIGRATED_SYSTEM_KEYS = new String[][]{{"com.liferay.filters.compression.CompressionFilter", "com.liferay.portal.servlet.filters.gzip.GZipFilter"}, {"com.liferay.filters.doubleclick.DoubleClickFilter", "com.liferay.portal.servlet.filters.doubleclick.DoubleClickFilter"}, {"com.liferay.filters.strip.StripFilter", "com.liferay.portal.servlet.filters.strip.StripFilter"}, {"com.liferay.util.Http.max.connections.per.host", "com.liferay.portal.util.HttpImpl.max.connections.per.host"}, {"com.liferay.util.Http.max.total.connections", "com.liferay.portal.util.HttpImpl.max.total.connections"}, {"com.liferay.util.Http.proxy.auth.type", "com.liferay.portal.util.HttpImpl.proxy.auth.type"}, {"com.liferay.util.Http.proxy.ntlm.domain", "com.liferay.portal.util.HttpImpl.proxy.ntlm.domain"}, {"com.liferay.util.Http.proxy.ntlm.host", "com.liferay.portal.util.HttpImpl.proxy.ntlm.host"}, {"com.liferay.util.Http.proxy.password", "com.liferay.portal.util.HttpImpl.proxy.password"}, {"com.liferay.util.Http.proxy.username", "com.liferay.portal.util.HttpImpl.proxy.username"}, {"com.liferay.util.Http.timeout", "com.liferay.portal.util.HttpImpl.timeout"}, {"com.liferay.util.servlet.UploadServletRequest.max.size", "com.liferay.portal.upload.UploadServletRequestImpl.max.size"}, {"com.liferay.util.servlet.UploadServletRequest.temp.dir", "com.liferay.portal.upload.UploadServletRequestImpl.temp.dir"}, {"com.liferay.util.servlet.fileupload.LiferayFileItem.threshold.size", "com.liferay.portal.upload.LiferayFileItem.threshold.size"}, {"com.liferay.util.servlet.fileupload.LiferayInputStream.threshold.size", "com.liferay.portal.upload.LiferayInputStream.threshold.size"}};
    private static final String[] _OBSOLETE_PORTAL_KEYS = new String[]{"auth.max.failures.limit", "cas.validate.url", "commons.pool.enabled", "jbi.workflow.url", "lucene.analyzer", "message.boards.thread.locking.enabled", "portal.security.manager.enable", "shard.available.names", "webdav.storage.class", "webdav.storage.show.edit.url", "webdav.storage.show.view.url", "webdav.storage.tokens", "xss.allow"};
    private static final String[] _OBSOLETE_SYSTEM_KEYS = new String[]{"com.liferay.util.Http.proxy.host", "com.liferay.util.Http.proxy.port", "com.liferay.util.XSSUtil.regexp.pattern"};
    private static final String[][] _RENAMED_PORTAL_KEYS = new String[][]{{"amazon.license.0", "amazon.access.key.id"}, {"amazon.license.1", "amazon.access.key.id"}, {"amazon.license.2", "amazon.access.key.id"}, {"amazon.license.3", "amazon.access.key.id"}, {"cdn.host", "cdn.host.http"}, {"com.liferay.portal.servlet.filters.compression.CompressionFilter", "com.liferay.portal.servlet.filters.gzip.GZipFilter"}, {"default.guest.friendly.url", "default.guest.public.layout.friendly.url"}, {"default.guest.layout.column", "default.guest.public.layout.column"}, {"default.guest.layout.name", "default.guest.public.layout.name"}, {"default.guest.layout.template.id", "default.guest.public.layout.template.id"}, {"default.user.layout.column", "default.user.public.layout.column"}, {"default.user.layout.name", "default.user.public.layout.name"}, {"default.user.layout.template.id", "default.user.public.layout.template.id"}, {"default.user.private.layout.lar", "default.user.private.layouts.lar"}, {"default.user.public.layout.lar", "default.user.public.layouts.lar"}, {"dl.hook.cmis.credentials.password", "dl.store.cmis.credentials.password"}, {"dl.hook.cmis.credentials.username", "dl.store.cmis.credentials.username"}, {"dl.hook.cmis.repository.url", "dl.store.cmis.repository.url"}, {"dl.hook.cmis.system.root.dir", "dl.store.cmis.system.root.dir"}, {"dl.hook.file.system.root.dir", "dl.store.file.system.root.dir"}, {"dl.hook.impl", "dl.store.impl"}, {"dl.hook.jcr.fetch.delay", "dl.store.jcr.fetch.delay"}, {"dl.hook.jcr.fetch.max.failures", "dl.store.jcr.fetch.max.failures"}, {"dl.hook.jcr.move.version.labels", "dl.store.jcr.move.version.labels"}, {"dl.hook.s3.access.key", "dl.store.s3.access.key"}, {"dl.hook.s3.bucket.name", "dl.store.s3.bucket.name"}, {"dl.hook.s3.secret.key", "dl.store.s3.secret.key"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.calendar.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.calendar.configuration.jsp"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.invitation.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.invitation.configuration.jsp"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.journal.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.journal.configuration.jsp"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.message_boards.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.message_boards.configuration.jsp"}, {"editor.wysiwyg.portal-web.docroot.html.portlet.shopping.edit_configuration.jsp", "editor.wysiwyg.portal-web.docroot.html.portlet.shopping.configuration.jsp"}, {"lucene.store.jdbc.auto.clean.up", "lucene.store.jdbc.auto.clean.up.enabled"}, {"referer.url.domains.allowed", "redirect.url.domains.allowed"}, {"referer.url.ips.allowed", "redirect.url.ips.allowed"}, {"referer.url.security.mode", "redirect.url.security.mode"}, {"tags.asset.increment.view.counter.enabled", "asset.entry.increment.view.counter.enabled"}};
    private static final String[][] _RENAMED_SYSTEM_KEYS = new String[][]{{"com.liferay.portal.kernel.util.StringBundler.unsafe.create.threshold", "com.liferay.portal.kernel.util.StringBundler.threadlocal.buffer.limit"}};
    private static Log _log = LogFactoryUtil.getLog(VerifyProperties.class);

    protected void doVerify() throws Exception {
        String[] key;
        String newKey;
        String oldKey;
        String[] keys;
        String[][] stringArray = _MIGRATED_SYSTEM_KEYS;
        int n = _MIGRATED_SYSTEM_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            keys = stringArray[n2];
            oldKey = keys[0];
            newKey = keys[1];
            this.verifyMigratedSystemProperty(oldKey, newKey);
            ++n2;
        }
        stringArray = _RENAMED_SYSTEM_KEYS;
        n = _RENAMED_SYSTEM_KEYS.length;
        n2 = 0;
        while (n2 < n) {
            keys = stringArray[n2];
            oldKey = keys[0];
            newKey = keys[1];
            this.verifyRenamedSystemProperty(oldKey, newKey);
            ++n2;
        }
        stringArray = _OBSOLETE_SYSTEM_KEYS;
        n = _OBSOLETE_SYSTEM_KEYS.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            this.verifyObsoleteSystemProperty((String)key);
            ++n2;
        }
        stringArray = _RENAMED_PORTAL_KEYS;
        n = _RENAMED_PORTAL_KEYS.length;
        n2 = 0;
        while (n2 < n) {
            keys = stringArray[n2];
            oldKey = keys[0];
            newKey = keys[1];
            this.verifyRenamedPortalProperty(oldKey, newKey);
            ++n2;
        }
        stringArray = _OBSOLETE_PORTAL_KEYS;
        n = _OBSOLETE_PORTAL_KEYS.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            this.verifyObsoletePortalProperty((String)key);
            ++n2;
        }
        StoreFactory.checkProperties();
    }

    protected void verifyMigratedSystemProperty(String oldKey, String newKey) throws Exception {
        String value = SystemProperties.get((String)oldKey);
        if (value != null) {
            _log.error((Object)("System property \"" + oldKey + "\" was migrated to the portal property \"" + newKey + "\""));
        }
    }

    protected void verifyRenamedPortalProperty(String oldKey, String newKey) throws Exception {
        String value = PropsUtil.get(oldKey);
        if (value != null) {
            _log.error((Object)("Portal property \"" + oldKey + "\" was renamed to \"" + newKey + "\""));
        }
    }

    protected void verifyRenamedSystemProperty(String oldKey, String newKey) throws Exception {
        String value = SystemProperties.get((String)oldKey);
        if (value != null) {
            _log.error((Object)("System property \"" + oldKey + "\" was renamed to \"" + newKey + "\""));
        }
    }

    protected void verifyObsoletePortalProperty(String key) throws Exception {
        String value = PropsUtil.get(key);
        if (value != null) {
            _log.error((Object)("Portal property \"" + key + "\" is obsolete"));
        }
    }

    protected void verifyObsoleteSystemProperty(String key) throws Exception {
        String value = SystemProperties.get((String)key);
        if (value != null) {
            _log.error((Object)("System property \"" + key + "\" is obsolete"));
        }
    }
}

