/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourceCode;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ResourceCodeLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.impl.ResourcePermissionLocalServiceImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyPermission
extends VerifyProcess {
    private static Object[][] _ORGANIZATION_ACTION_IDS_TO_MASKS = new Object[][]{{"APPROVE_PROPOSAL", 2L, 0L}, {"ASSIGN_MEMBERS", 4L, 4L}, {"ASSIGN_REVIEWER", 8L, 0L}, {"MANAGE_ARCHIVED_SETUPS", 128L, 128L}, {"MANAGE_LAYOUTS", 256L, 256L}, {"MANAGE_STAGING", 512L, 512L}, {"MANAGE_TEAMS", 2048L, 1024L}, {"PUBLISH_STAGING", 16384L, 4096L}};
    private static Log _log = LogFactoryUtil.getLog(VerifyPermission.class);

    protected void checkPermissions() throws Exception {
        List modelNames = ResourceActionsUtil.getModelNames();
        for (String modelName : modelNames) {
            List actionIds = ResourceActionsUtil.getModelResourceActions((String)modelName);
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                PermissionLocalServiceUtil.checkPermissions((String)modelName, (List)actionIds);
                continue;
            }
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) continue;
            ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)actionIds, (boolean)true);
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                long companyId = lArray[n2];
                try {
                    if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                        this.deleteDefaultPrivateLayoutPermissions_5(companyId);
                    } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                        this.deleteDefaultPrivateLayoutPermissions_6(companyId);
                    } else {
                        this.deleteDefaultPrivateLayoutPermissions_1to4(companyId);
                    }
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
            ++n2;
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions_1to4(long companyId) throws Exception {
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        List permissions = PermissionLocalServiceUtil.getUserPermissions((long)defaultUserId);
        for (Permission permission : permissions) {
            Resource resource = ResourceLocalServiceUtil.getResource((long)permission.getResourceId());
            ResourceCode resourceCode = ResourceCodeLocalServiceUtil.getResourceCode((long)resource.getCodeId());
            if (!this.isPrivateLayout(resourceCode.getName(), resource.getPrimKey())) continue;
            String[] actionIds = new String[]{permission.getActionId()};
            PermissionLocalServiceUtil.unsetUserPermissions((long)defaultUserId, (String[])actionIds, (long)permission.getResourceId());
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions_5(long companyId) throws Exception {
        Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List permissions = PermissionLocalServiceUtil.getRolePermissions((long)role.getRoleId());
        for (Permission permission : permissions) {
            Resource resource = ResourceLocalServiceUtil.getResource((long)permission.getResourceId());
            ResourceCode resourceCode = ResourceCodeLocalServiceUtil.getResourceCode((long)resource.getCodeId());
            if (!this.isPrivateLayout(resourceCode.getName(), resource.getPrimKey())) continue;
            PermissionLocalServiceUtil.unsetRolePermission((long)role.getRoleId(), (long)permission.getPermissionId());
        }
    }

    protected void deleteDefaultPrivateLayoutPermissions_6(long companyId) throws Exception {
        Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List resourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions((long)role.getRoleId());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.isPrivateLayout(resourcePermission.getName(), resourcePermission.getPrimKey())) continue;
            ResourcePermissionLocalServiceUtil.deleteResourcePermission((long)resourcePermission.getResourcePermissionId());
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteDefaultPrivateLayoutPermissions();
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 5 && PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return;
        }
        this.checkPermissions();
        this.fixOrganizationRolePermissions();
    }

    protected void fixOrganizationRolePermissions() throws Exception {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            this.fixOrganizationRolePermissions_5();
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.fixOrganizationRolePermissions_6();
        }
        PermissionCacheUtil.clearCache();
    }

    protected void fixOrganizationRolePermissions_5() throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(ResourceCode.class);
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)Organization.class.getName()));
        List resouceCodes = ResourceCodeLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (ResourceCode resourceCode : resouceCodes) {
            dynamicQuery = DynamicQueryFactoryUtil.forClass(Resource.class);
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"codeId", (Object)resourceCode.getCodeId()));
            List resources = ResourceLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
            for (Resource resource : resources) {
                dynamicQuery = DynamicQueryFactoryUtil.forClass(Permission.class);
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"resourceId", (Object)resource.getResourceId()));
                List permissions = PermissionLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
                this.processPermissions(resource, permissions);
            }
        }
    }

    protected void fixOrganizationRolePermissions_6() throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(ResourcePermission.class);
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)Organization.class.getName()));
        List resourcePermissions = ResourcePermissionLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            ResourcePermission groupResourcePermission = null;
            try {
                groupResourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
            }
            catch (Exception exception) {
                ResourcePermissionLocalServiceUtil.setResourcePermissions((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId(), (String[])ResourcePermissionLocalServiceImpl.EMPTY_ACTION_IDS);
                groupResourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
            }
            long organizationActions = resourcePermission.getActionIds();
            long groupActions = groupResourcePermission.getActionIds();
            Object[][] objectArray = _ORGANIZATION_ACTION_IDS_TO_MASKS;
            int n = _ORGANIZATION_ACTION_IDS_TO_MASKS.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] actionIdToMask = objectArray[n2];
                long organizationActionMask = (Long)actionIdToMask[1];
                long groupActionMask = (Long)actionIdToMask[2];
                if ((organizationActions & organizationActionMask) == organizationActionMask) {
                    organizationActions &= organizationActionMask ^ 0xFFFFFFFFFFFFFFFFL;
                    groupActions |= groupActionMask;
                }
                ++n2;
            }
            try {
                resourcePermission.resetOriginalValues();
                resourcePermission.setActionIds(organizationActions);
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission, (boolean)false);
                groupResourcePermission.resetOriginalValues();
                groupResourcePermission.setActionIds(groupActions);
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)groupResourcePermission, (boolean)false);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected boolean isPrivateLayout(String name, String primKey) throws Exception {
        if (!name.equals(Layout.class.getName())) {
            return false;
        }
        long plid = GetterUtil.getLong((String)primKey);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        return !layout.isPublicLayout() && !layout.isTypeControlPanel();
    }

    protected void processPermissions(Resource resource, List<Permission> permissions) throws Exception {
        Resource groupResource = null;
        try {
            groupResource = ResourceLocalServiceUtil.getResource((long)resource.getCompanyId(), (String)Group.class.getName(), (int)resource.getScope(), (String)resource.getPrimKey());
        }
        catch (NoSuchResourceException noSuchResourceException) {
            groupResource = ResourceLocalServiceUtil.addResource((long)resource.getCompanyId(), (String)Group.class.getName(), (int)resource.getScope(), (String)resource.getPrimKey());
        }
        block4: for (Permission permission : permissions) {
            Object[][] objectArray = _ORGANIZATION_ACTION_IDS_TO_MASKS;
            int n = _ORGANIZATION_ACTION_IDS_TO_MASKS.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] actionIdToMask = objectArray[n2];
                String actionId = (String)actionIdToMask[0];
                long mask = (Long)actionIdToMask[2];
                if (actionId.equals(permission.getActionId())) {
                    try {
                        if (mask != 0L) {
                            permission.resetOriginalValues();
                            permission.setResourceId(groupResource.getResourceId());
                            PermissionLocalServiceUtil.updatePermission((Permission)permission, (boolean)false);
                            continue block4;
                        }
                        PermissionLocalServiceUtil.deletePermission((long)permission.getPermissionId());
                    }
                    catch (Exception e) {
                        _log.error((Object)e, (Throwable)e);
                    }
                    continue block4;
                }
                ++n2;
            }
        }
    }
}

