/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class VerifyMySQL
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyMySQL.class);

    protected void alterTableEngine(String tableName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Updating table " + tableName + " to use engine " + PropsValues.DATABASE_MYSQL_ENGINE));
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("alter table " + tableName + " engine " + PropsValues.DATABASE_MYSQL_ENGINE);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doVerify() throws Exception {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("mysql")) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("show table status");
            rs = ps.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString("Name");
                String engine = GetterUtil.getString((String)rs.getString("Engine"));
                String comment = GetterUtil.getString((String)rs.getString("Comment"));
                if (comment.equalsIgnoreCase("VIEW") || engine.equalsIgnoreCase(PropsValues.DATABASE_MYSQL_ENGINE)) continue;
                this.alterTableEngine(tableName);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

