/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.NoSuchShardException;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Shard;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ShardLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

public class VerifyGroup
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyGroup.class);

    protected void doVerify() throws Exception {
        this.verifyCompanyGroups();
        this.verifyNullFriendlyURLGroups();
        this.verifyStagedGroups();
    }

    protected void verifyCompanyGroups() throws Exception {
        List companies = CompanyLocalServiceUtil.getCompanies();
        String currentShardName = ShardUtil.getCurrentShardName();
        for (Company company : companies) {
            String shardName = null;
            try {
                shardName = company.getShardName();
            }
            catch (NoSuchShardException noSuchShardException) {
                Shard shard = ShardLocalServiceUtil.addShard((String)Company.class.getName(), (long)company.getCompanyId(), (String)PropsValues.SHARD_DEFAULT_NAME);
                shardName = shard.getName();
            }
            if (ShardUtil.isEnabled() && !shardName.equals(currentShardName)) continue;
            GroupLocalServiceUtil.checkCompanyGroup((long)company.getCompanyId());
        }
    }

    protected void verifyNullFriendlyURLGroups() throws Exception {
        List groups = GroupLocalServiceUtil.getNullFriendlyURLGroups();
        for (Group group : groups) {
            String friendlyURL = "/" + group.getGroupId();
            User user = null;
            if (group.isUser()) {
                user = UserLocalServiceUtil.getUserById((long)group.getClassPK());
                friendlyURL = "/" + user.getScreenName();
            } else if (group.getClassPK() > 0L) {
                friendlyURL = "/" + group.getClassPK();
            }
            try {
                GroupLocalServiceUtil.updateFriendlyURL((long)group.getGroupId(), (String)friendlyURL);
            }
            catch (GroupFriendlyURLException gfurle) {
                if (user != null) {
                    long userId = user.getUserId();
                    String screenName = user.getScreenName();
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Updating user screen name " + screenName + " to " + userId + " because it is generating an " + "invalid friendly URL"));
                    }
                    UserLocalServiceUtil.updateScreenName((long)userId, (String)String.valueOf(userId));
                    continue;
                }
                _log.error((Object)("Invalid Friendly URL " + friendlyURL));
                throw gfurle;
            }
        }
    }

    protected void verifyStagedGroups() throws Exception {
        List groups = GroupLocalServiceUtil.getLiveGroups();
        for (Group group : groups) {
            if (!group.hasStagingGroup()) continue;
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            typeSettingsProperties.setProperty("staged", Boolean.TRUE.toString());
            typeSettingsProperties.setProperty("stagedRemotely", Boolean.FALSE.toString());
            GroupLocalServiceUtil.updateGroup((long)group.getGroupId(), (String)typeSettingsProperties.toString());
            Group stagingGroup = group.getStagingGroup();
            if (group.getClassNameId() == stagingGroup.getClassNameId()) continue;
            stagingGroup.setClassNameId(group.getClassNameId());
            GroupLocalServiceUtil.updateGroup((Group)stagingGroup);
        }
    }
}

