/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import java.util.Date;
import java.util.List;

public class VerifyDocumentLibrary
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyDocumentLibrary.class);

    protected void doVerify() throws Exception {
        this.checkFileEntryType();
        this.removeOrphanedFileEntries();
        this.updateAssets();
    }

    protected void checkFileEntryType() throws Exception {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)0L);
        if (dlFileEntryType != null) {
            return;
        }
        Date now = new Date();
        dlFileEntryType = DLFileEntryTypeLocalServiceUtil.createDLFileEntryType((long)0L);
        dlFileEntryType.setCreateDate(now);
        dlFileEntryType.setModifiedDate(now);
        dlFileEntryType.setName("Basic Document");
        DLFileEntryTypeLocalServiceUtil.updateDLFileEntryType((DLFileEntryType)dlFileEntryType, (boolean)false);
    }

    protected void removeOrphanedFileEntries() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getOrphanedFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no group"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            try {
                DLFileEntryLocalServiceUtil.deleteFileEntry((long)dlFileEntry.getFileEntryId());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to remove file entry " + dlFileEntry.getFileEntryId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Removed orphaned file entries");
        }
    }

    protected void updateAssets() throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getNoAssetFileEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + dlFileEntries.size() + " file entries with no asset"));
        }
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            LiferayFileVersion fileVersion = new LiferayFileVersion(dlFileEntry.getFileVersion());
            try {
                DLAppHelperLocalServiceUtil.updateAsset((long)dlFileEntry.getUserId(), (FileEntry)fileEntry, (FileVersion)fileVersion, null, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for file entry " + dlFileEntry.getFileEntryId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for file entries");
        }
    }
}

