/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import java.util.List;

public class VerifyCalendar
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyCalendar.class);

    protected void doVerify() throws Exception {
        List events = CalEventLocalServiceUtil.getNoAssetEvents();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + events.size() + " events with no asset"));
        }
        for (CalEvent event : events) {
            try {
                CalEventLocalServiceUtil.updateAsset((long)event.getUserId(), (CalEvent)event, null, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for event " + event.getEventId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for events");
        }
    }
}

