/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import java.util.List;

public class VerifyBookmarks
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyBookmarks.class);

    protected void doVerify() throws Exception {
        List entries = BookmarksEntryLocalServiceUtil.getNoAssetEntries();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + entries.size() + " entries with no asset"));
        }
        for (BookmarksEntry entry : entries) {
            try {
                BookmarksEntryLocalServiceUtil.updateAsset((long)entry.getUserId(), (BookmarksEntry)entry, null, null, null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for entry " + entry.getEntryId() + ": " + e.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for entries");
        }
    }
}

