/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngine;
import com.liferay.portal.kernel.velocity.VelocityVariablesUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.velocity.FastExtendedProperties;
import com.liferay.portal.velocity.LiferayResourceCacheUtil;
import com.liferay.portal.velocity.LiferayResourceLoader;
import com.liferay.portal.velocity.StringResourceRepositoryImpl;
import com.liferay.portal.velocity.VelocityContextImpl;
import java.io.Writer;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;

public class VelocityEngineImpl
implements VelocityEngine {
    private static final String _RESOURCE_LOADER = "resource.loader";
    private static Log _log = LogFactoryUtil.getLog(VelocityEngineImpl.class);
    private VelocityContextImpl _restrictedToolsContext;
    private VelocityContextImpl _standardToolsContext;
    private org.apache.velocity.app.VelocityEngine _velocityEngine;

    public void flushTemplate(String velocityTemplateId) {
        StringResourceRepository stringResourceRepository = StringResourceLoader.getRepository();
        if (stringResourceRepository != null) {
            stringResourceRepository.removeStringResource(velocityTemplateId);
        }
        LiferayResourceCacheUtil.remove(velocityTemplateId);
    }

    public VelocityContext getEmptyContext() {
        return new VelocityContextImpl();
    }

    public VelocityContext getRestrictedToolsContext() {
        return this._restrictedToolsContext;
    }

    public VelocityContext getStandardToolsContext() {
        return this._standardToolsContext;
    }

    public VelocityContext getWrappedRestrictedToolsContext() {
        return new VelocityContextImpl(this._restrictedToolsContext.getWrappedVelocityContext());
    }

    public VelocityContext getWrappedStandardToolsContext() {
        return new VelocityContextImpl(this._standardToolsContext.getWrappedVelocityContext());
    }

    public void init() throws Exception {
        if (this._velocityEngine != null) {
            return;
        }
        this._velocityEngine = new org.apache.velocity.app.VelocityEngine();
        LiferayResourceLoader.setVelocityResourceListeners(PropsValues.VELOCITY_ENGINE_RESOURCE_LISTENERS);
        FastExtendedProperties extendedProperties = new FastExtendedProperties();
        extendedProperties.setProperty(_RESOURCE_LOADER, "string,servlet");
        extendedProperties.setProperty("string.resource.loader.cache", String.valueOf(PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_CACHE_ENABLED));
        extendedProperties.setProperty("string.resource.loader.class", StringResourceLoader.class.getName());
        extendedProperties.setProperty("string.resource.loader.repository.class", StringResourceRepositoryImpl.class.getName());
        extendedProperties.setProperty("servlet.resource.loader.cache", String.valueOf(PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_CACHE_ENABLED));
        extendedProperties.setProperty("servlet.resource.loader.class", LiferayResourceLoader.class.getName());
        extendedProperties.setProperty("resource.manager.class", PropsUtil.get("velocity.engine.resource.manager"));
        extendedProperties.setProperty("resource.manager.cache.class", PropsUtil.get("velocity.engine.resource.manager.cache"));
        extendedProperties.setProperty("velocimacro.library", PropsUtil.get("velocity.engine.velocimacro.library"));
        extendedProperties.setProperty("velocimacro.library.autoreload", String.valueOf(!PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_CACHE_ENABLED));
        extendedProperties.setProperty("velocimacro.permissions.allow.inline.to.replace.global", String.valueOf(!PropsValues.VELOCITY_ENGINE_RESOURCE_MANAGER_CACHE_ENABLED));
        extendedProperties.setProperty("runtime.log.logsystem.class", PropsUtil.get("velocity.engine.logger"));
        extendedProperties.setProperty("runtime.log.logsystem.log4j.category", PropsUtil.get("velocity.engine.logger.category"));
        this._velocityEngine.setExtendedProperties((ExtendedProperties)extendedProperties);
        this._velocityEngine.init();
        this._restrictedToolsContext = new VelocityContextImpl();
        VelocityVariablesUtil.insertHelperUtilities((VelocityContext)this._restrictedToolsContext, (String[])PropsValues.JOURNAL_TEMPLATE_VELOCITY_RESTRICTED_VARIABLES);
        this._standardToolsContext = new VelocityContextImpl();
        VelocityVariablesUtil.insertHelperUtilities((VelocityContext)this._standardToolsContext, null);
    }

    public boolean mergeTemplate(String velocityTemplateId, String velocityTemplateContent, VelocityContext velocityContext, Writer writer) throws Exception {
        if (!(!Validator.isNotNull((String)velocityTemplateContent) || PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED && this.resourceExists(velocityTemplateId))) {
            StringResourceRepository stringResourceRepository = StringResourceLoader.getRepository();
            stringResourceRepository.putStringResource(velocityTemplateId, velocityTemplateContent);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added " + velocityTemplateId + " to the Velocity template repository"));
            }
        }
        VelocityContextImpl velocityContextImpl = (VelocityContextImpl)velocityContext;
        return this._velocityEngine.mergeTemplate(velocityTemplateId, "UTF-8", (Context)velocityContextImpl.getWrappedVelocityContext(), writer);
    }

    public boolean mergeTemplate(String velocityTemplateId, VelocityContext velocityContext, Writer writer) throws Exception {
        return this.mergeTemplate(velocityTemplateId, null, velocityContext, writer);
    }

    public boolean resourceExists(String resource) {
        return this._velocityEngine.resourceExists(resource);
    }
}

