/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.velocity.VelocityResourceListener;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ServletVelocityResourceListener
extends VelocityResourceListener {
    private static Log _log = LogFactoryUtil.getLog(ServletVelocityResourceListener.class);

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        try {
            return this.doGetResourceStream(source);
        }
        catch (Exception exception) {
            throw new ResourceNotFoundException(source);
        }
    }

    protected InputStream doGetResourceStream(String source) throws Exception {
        InputStream inputStream;
        ServletContext servletContext;
        int pos = source.indexOf("_SERVLET_CONTEXT_");
        if (pos == -1) {
            return null;
        }
        String servletContextName = source.substring(0, pos);
        if (Validator.isNull((String)servletContextName)) {
            servletContextName = PortalUtil.getPathContext();
        }
        if ((servletContext = ServletContextPool.get((String)servletContextName)) == null) {
            _log.error((Object)(String.valueOf(source) + " is not valid because " + servletContextName + " does not map to a servlet context"));
            return null;
        }
        String name = source.substring(pos + "_SERVLET_CONTEXT_".length());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(name) + " is associated with the servlet context " + servletContextName + " " + servletContext));
        }
        if ((inputStream = servletContext.getResourceAsStream(name)) == null && name.endsWith("/init_custom.vm")) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("The template " + name + " should be created"));
            }
            return new UnsyncByteArrayInputStream(new byte[0]);
        }
        return inputStream;
    }
}

