/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionTreeJSClicks {
    public static final String CLASS_NAME = SessionTreeJSClicks.class.getName();
    private static Log _log = LogFactoryUtil.getLog(SessionTreeJSClicks.class);

    public static void closeLayoutNodes(HttpServletRequest request, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(request, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.closeNodes(request, treeId, layoutIds.toArray(new String[layoutIds.size()]));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void closeNode(HttpServletRequest request, String treeId, String nodeId) {
        try {
            String openNodesString = SessionTreeJSClicks.get(request, treeId);
            openNodesString = StringUtil.remove((String)openNodesString, (String)nodeId);
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId) {
        try {
            String openNodesString = "";
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        try {
            String openNodesString = SessionTreeJSClicks.get(request, treeId);
            String[] stringArray = nodeIds;
            int n = nodeIds.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeId = stringArray[n2];
                openNodesString = StringUtil.remove((String)openNodesString, (String)nodeId);
                ++n2;
            }
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static String getOpenNodes(HttpServletRequest request, String treeId) {
        try {
            return SessionTreeJSClicks.get(request, treeId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static void openLayoutNodes(HttpServletRequest request, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(request, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.openNodes(request, treeId, layoutIds.toArray(new String[layoutIds.size()]));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void openNode(HttpServletRequest request, String treeId, String nodeId) {
        try {
            String openNodesString = SessionTreeJSClicks.get(request, treeId);
            openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void openNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        try {
            String openNodesString = SessionTreeJSClicks.get(request, treeId);
            String[] stringArray = nodeIds;
            int n = nodeIds.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeId = stringArray[n2];
                openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
                ++n2;
            }
            SessionTreeJSClicks.put(request, treeId, openNodesString);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected static String get(HttpServletRequest request, String key) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            return preferences.getValue(CLASS_NAME, key);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    protected static List<String> getLayoutIds(HttpServletRequest request, boolean privateLayout, long parentLayoutId, List<String> layoutIds) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
        for (Layout layout : layouts) {
            layoutIds.add(String.valueOf(layout.getLayoutId()));
            SessionTreeJSClicks.getLayoutIds(request, privateLayout, layout.getLayoutId(), layoutIds);
        }
        return layoutIds;
    }

    protected static void put(HttpServletRequest request, String key, String value) {
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            preferences.setValue(CLASS_NAME, key, value);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

