/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.TreeNodeView;
import com.liferay.portal.kernel.util.TreeView;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.User;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PortletLister;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portal.util.comparator.PortletCategoryComparator;
import com.liferay.portal.util.comparator.PortletTitleComparator;
import com.liferay.portlet.PortletConfigFactoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletListerImpl
implements PortletLister {
    private int _depth;
    private boolean _includeInstanceablePortlets;
    private boolean _iteratePortlets;
    private LayoutTypePortlet _layoutTypePortlet;
    private List<TreeNodeView> _list;
    private int _nodeId;
    private String _rootNodeName;
    private ServletContext _servletContext;
    private User _user;

    public TreeView getTreeView() throws PortalException, SystemException {
        this._nodeId = 1;
        this._list = new ArrayList<TreeNodeView>();
        if (this._rootNodeName != null) {
            TreeNodeView rootNodeView = new TreeNodeView(this._nodeId);
            rootNodeView.setLeaf(false);
            rootNodeView.setName(this._rootNodeName);
            this._list.add(rootNodeView);
        }
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(this._user.getCompanyId(), "PORTLET_CATEGORY");
        List categories = ListUtil.fromCollection((Collection)portletCategory.getCategories());
        this.iterateCategories(categories, this._nodeId, 0);
        return new TreeView(this._list, this._depth);
    }

    public void setIncludeInstanceablePortlets(boolean includeInstanceablePortlets) {
        this._includeInstanceablePortlets = includeInstanceablePortlets;
    }

    public void setIteratePortlets(boolean iteratePortlets) {
        this._iteratePortlets = iteratePortlets;
    }

    public void setLayoutTypePortlet(LayoutTypePortlet layoutTypePortlet) {
        this._layoutTypePortlet = layoutTypePortlet;
    }

    public void setRootNodeName(String rootNodeName) {
        this._rootNodeName = rootNodeName;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public void setUser(User user) {
        this._user = user;
    }

    protected void iterateCategories(List<PortletCategory> categories, long parentId, int depth) throws PortalException, SystemException {
        categories = ListUtil.sort(categories, (Comparator)new PortletCategoryComparator(this._user.getLocale()));
        Iterator itr = categories.iterator();
        int i = 0;
        while (itr.hasNext()) {
            PortletCategory portletCategory = (PortletCategory)itr.next();
            if (portletCategory.isHidden()) continue;
            if (i == 0 && ++depth > this._depth) {
                this._depth = depth;
            }
            TreeNodeView nodeView = new TreeNodeView(++this._nodeId);
            nodeView.setDepth(depth);
            nodeView.setLeaf(false);
            if (i + 1 == categories.size()) {
                nodeView.setLs("1");
            } else {
                nodeView.setLs("0");
            }
            nodeView.setName(portletCategory.getName());
            nodeView.setObjId(portletCategory.getPath());
            nodeView.setParentId(parentId);
            this._list.add(nodeView);
            int nodeId = this._nodeId;
            List subCategories = ListUtil.fromCollection((Collection)portletCategory.getCategories());
            this.iterateCategories(subCategories, nodeId, depth);
            if (this._iteratePortlets) {
                this._iteratePortlets(portletCategory, portletCategory.getPortletIds(), nodeId, depth + 1);
            }
            ++i;
        }
    }

    private void _iteratePortlets(PortletCategory portletCategory, Set<String> portletIds, int parentNodeId, int depth) throws PortalException, SystemException {
        List<Portlet> portlets = new ArrayList();
        Iterator<String> portletIdsItr = portletIds.iterator();
        String externalPortletCategory = null;
        while (portletIdsItr.hasNext()) {
            PortletApp portletApp;
            String portletId = portletIdsItr.next();
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this._user.getCompanyId(), (String)portletId);
            if (portlet == null) continue;
            if (!portlet.isSystem() && portlet.isActive() && (!portlet.isInstanceable() || this._includeInstanceablePortlets)) {
                if (!portlet.isInstanceable() && this._layoutTypePortlet.hasPortletId(portlet.getPortletId())) {
                    portlets.add(portlet);
                } else if (portlet.hasAddPortletPermission(this._user.getUserId())) {
                    portlets.add(portlet);
                }
            }
            if (!(portletApp = portlet.getPortletApp()).isWARFile() || !Validator.isNull(externalPortletCategory)) continue;
            PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)this._servletContext);
            ResourceBundle resourceBundle = portletConfig.getResourceBundle(this._user.getLocale());
            externalPortletCategory = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)portletCategory.getName());
        }
        portlets = ListUtil.sort(portlets, (Comparator)new PortletTitleComparator(this._user.getLocale()));
        Iterator portletsItr = portlets.iterator();
        int i = 0;
        while (portletsItr.hasNext()) {
            Portlet portlet = (Portlet)portletsItr.next();
            TreeNodeView nodeView = new TreeNodeView(++this._nodeId);
            nodeView.setDepth(depth);
            nodeView.setLeaf(true);
            if (i + 1 == portlets.size()) {
                nodeView.setLs("1");
            } else {
                nodeView.setLs("0");
            }
            nodeView.setName(PortalUtil.getPortletTitle((Portlet)portlet, (User)this._user));
            nodeView.setObjId(portlet.getRootPortletId());
            nodeView.setParentId((long)parentNodeId);
            this._list.add(nodeView);
            ++i;
        }
    }
}

