/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.MultiValueMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryMultiValueMap<K extends Serializable, V extends Serializable>
extends MultiValueMap<K, V> {
    private Map<K, Set<V>> _map = new HashMap<K, Set<V>>();

    public void clear() {
        this._map.clear();
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        for (Map.Entry<K, Set<V>> entry : this._map.entrySet()) {
            Set<V> values = entry.getValue();
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    public Set<V> getAll(Object key) {
        return this._map.get(key);
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Set<K> keySet() {
        return this._map.keySet();
    }

    public V put(K key, V value) {
        Set<V> values = this._map.get(key);
        if (values == null) {
            values = new HashSet<V>();
        }
        values.add(value);
        this._map.put(key, values);
        return value;
    }

    public Set<V> putAll(K key, Collection<? extends V> values) {
        Set<V> oldValues = this._map.get(key);
        if (oldValues == null) {
            oldValues = new HashSet<V>();
        }
        oldValues.addAll(values);
        this._map.put(key, oldValues);
        return oldValues;
    }

    public V remove(Object key) {
        Serializable value = null;
        Set<V> values = this._map.remove(key);
        if (values != null && !values.isEmpty()) {
            value = (Serializable)values.iterator().next();
        }
        return (V)value;
    }
}

