/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.collections.map.ReferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationImpl
implements Localization {
    private static final String _AVAILABLE_LOCALES = "available-locales";
    private static final String _DEFAULT_LOCALE = "default-locale";
    private static final String _EMPTY_ROOT_NODE = "<root />";
    private static final String _LANGUAGE_ID = "language-id";
    private static final String _ROOT = "root";
    private static Log _log = LogFactoryUtil.getLog(LocalizationImpl.class);
    private Map<String, Map<Tuple, String>> _cache = new ReferenceMap(1, 0);

    public Object deserialize(JSONObject jsonObject) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String value = jsonObject.getString(languageId);
            if (Validator.isNotNull((String)value)) {
                map.put(locale, value);
            }
            ++n2;
        }
        return map;
    }

    public String[] getAvailableLocales(String xml) {
        String attributeValue = this._getRootAttribute(xml, _AVAILABLE_LOCALES, "");
        return StringUtil.split((String)attributeValue);
    }

    public String getDefaultLocale(String xml) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        return this._getRootAttribute(xml, _DEFAULT_LOCALE, defaultLanguageId);
    }

    public String getLocalization(String xml, String requestedLanguageId) {
        return this.getLocalization(xml, requestedLanguageId, true);
    }

    public String getLocalization(String xml, String requestedLanguageId, boolean useDefault) {
        String value;
        block34: {
            value = this._getCachedValue(xml, requestedLanguageId, useDefault);
            if (value != null) {
                return value;
            }
            value = "";
            String systemDefaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
            String priorityLanguageId = null;
            Locale requestedLocale = LocaleUtil.fromLanguageId((String)requestedLanguageId);
            if (useDefault && LanguageUtil.isDuplicateLanguageCode((String)requestedLocale.getLanguage())) {
                Locale priorityLocale = LanguageUtil.getLocale((String)requestedLocale.getLanguage());
                if (!requestedLanguageId.equals(priorityLanguageId)) {
                    priorityLanguageId = LocaleUtil.toLanguageId((Locale)priorityLocale);
                }
            }
            if (!Validator.isXml((String)xml)) {
                if (useDefault || requestedLanguageId.equals(systemDefaultLanguageId)) {
                    value = xml;
                }
                this._setCachedValue(xml, requestedLanguageId, useDefault, value);
                return value;
            }
            XMLStreamReader xmlStreamReader = null;
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                try {
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(portalClassLoader);
                    }
                    XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                    xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
                    String defaultLanguageId = "";
                    if (xmlStreamReader.hasNext()) {
                        xmlStreamReader.nextTag();
                        defaultLanguageId = xmlStreamReader.getAttributeValue(null, _DEFAULT_LOCALE);
                        if (Validator.isNull((String)defaultLanguageId)) {
                            defaultLanguageId = systemDefaultLanguageId;
                        }
                    }
                    String defaultValue = "";
                    String priorityValue = "";
                    while (xmlStreamReader.hasNext()) {
                        int event = xmlStreamReader.next();
                        if (event == 1) {
                            String languageId = xmlStreamReader.getAttributeValue(null, _LANGUAGE_ID);
                            if (Validator.isNull((String)languageId)) {
                                languageId = defaultLanguageId;
                            }
                            if (!languageId.equals(defaultLanguageId) && !languageId.equals(priorityLanguageId) && !languageId.equals(requestedLanguageId)) continue;
                            String text = xmlStreamReader.getElementText();
                            if (languageId.equals(defaultLanguageId)) {
                                defaultValue = text;
                            }
                            if (languageId.equals(priorityLanguageId)) {
                                priorityValue = text;
                            }
                            if (languageId.equals(requestedLanguageId)) {
                                value = text;
                            }
                            if (!Validator.isNotNull((String)value)) continue;
                            break;
                        }
                        if (event == 8) break;
                    }
                    if (useDefault && Validator.isNotNull((String)priorityLanguageId) && Validator.isNull((String)value) && Validator.isNotNull((String)priorityValue)) {
                        value = priorityValue;
                    }
                    if (useDefault && Validator.isNull((String)value)) {
                        value = defaultValue;
                    }
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
        this._setCachedValue(xml, requestedLanguageId, useDefault, value);
        return value;
    }

    public Map<Locale, String> getLocalizationMap(PortletPreferences preferences, String parameter) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String localeParameter = parameter.concat("_").concat(languageId);
            map.put(locale, preferences.getValue(localeParameter, ""));
            ++n2;
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(PortletRequest portletRequest, String parameter) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String localeParameter = parameter.concat("_").concat(languageId);
            map.put(locale, ParamUtil.getString((PortletRequest)portletRequest, (String)localeParameter));
            ++n2;
        }
        return map;
    }

    public Map<Locale, String> getLocalizationMap(String xml) {
        Locale[] locales = LanguageUtil.getAvailableLocales();
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            map.put(locale, this.getLocalization(xml, languageId, false));
            ++n2;
        }
        return map;
    }

    public String getLocalizationXmlFromPreferences(PortletPreferences preferences, PortletRequest portletRequest, String parameter) {
        String oldValue;
        String xml = "";
        Locale[] locales = LanguageUtil.getAvailableLocales();
        Locale defaultLocale = LocaleUtil.getDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String localParameter = String.valueOf(parameter) + "_" + languageId;
            String value = PrefsParamUtil.getString((PortletPreferences)preferences, (PortletRequest)portletRequest, (String)localParameter);
            if (Validator.isNotNull((String)value)) {
                xml = this.updateLocalization(xml, parameter, value, languageId);
            }
            ++n2;
        }
        if (Validator.isNull((String)this.getLocalization(xml, defaultLanguageId)) && Validator.isNotNull((String)(oldValue = PrefsParamUtil.getString((PortletPreferences)preferences, (PortletRequest)portletRequest, (String)parameter)))) {
            xml = this.updateLocalization(xml, parameter, oldValue);
        }
        return xml;
    }

    public Map<Locale, String> getLocalizedParameter(PortletRequest portletRequest, String parameter) {
        return this.getLocalizationMap(portletRequest, parameter);
    }

    public String getPreferencesKey(String key, String languageId) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        if (!languageId.equals(defaultLanguageId)) {
            key = String.valueOf(key) + "_" + languageId;
        }
        return key;
    }

    public String getPreferencesValue(PortletPreferences preferences, String key, String languageId) {
        return this.getPreferencesValue(preferences, key, languageId, true);
    }

    public String getPreferencesValue(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        String localizedKey = this.getPreferencesKey(key, languageId);
        String value = preferences.getValue(localizedKey, "");
        if (useDefault && Validator.isNull((String)value)) {
            value = preferences.getValue(key, "");
        }
        return value;
    }

    public String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId) {
        return this.getPreferencesValues(preferences, key, languageId, true);
    }

    public String[] getPreferencesValues(PortletPreferences preferences, String key, String languageId, boolean useDefault) {
        String localizedKey = this.getPreferencesKey(key, languageId);
        Object[] values = preferences.getValues(localizedKey, new String[0]);
        if (useDefault && Validator.isNull((Object[])values)) {
            values = preferences.getValues(key, new String[0]);
        }
        return values;
    }

    public String removeLocalization(String xml, String key, String requestedLanguageId) {
        return this.removeLocalization(xml, key, requestedLanguageId, false);
    }

    public String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata) {
        return this.removeLocalization(xml, key, requestedLanguageId, cdata, true);
    }

    public String removeLocalization(String xml, String key, String requestedLanguageId, boolean cdata, boolean localized) {
        block33: {
            if (Validator.isNull((String)xml)) {
                return "";
            }
            xml = this._sanitizeXML(xml);
            String systemDefaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
            XMLStreamReader xmlStreamReader = null;
            XMLStreamWriter xmlStreamWriter = null;
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                try {
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(portalClassLoader);
                    }
                    XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                    xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
                    String availableLocales = "";
                    String defaultLanguageId = "";
                    if (xmlStreamReader.hasNext()) {
                        xmlStreamReader.nextTag();
                        availableLocales = xmlStreamReader.getAttributeValue(null, _AVAILABLE_LOCALES);
                        defaultLanguageId = xmlStreamReader.getAttributeValue(null, _DEFAULT_LOCALE);
                        if (Validator.isNull((String)defaultLanguageId)) {
                            defaultLanguageId = systemDefaultLanguageId;
                        }
                    }
                    if (availableLocales != null && availableLocales.indexOf(requestedLanguageId) != -1) {
                        availableLocales = StringUtil.remove((String)availableLocales, (String)requestedLanguageId, (String)",");
                        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                        xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
                        xmlStreamWriter.writeStartDocument();
                        xmlStreamWriter.writeStartElement(_ROOT);
                        if (localized) {
                            xmlStreamWriter.writeAttribute(_AVAILABLE_LOCALES, availableLocales);
                            xmlStreamWriter.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
                        }
                        this._copyNonExempt(xmlStreamReader, xmlStreamWriter, requestedLanguageId, defaultLanguageId, cdata);
                        xmlStreamWriter.writeEndElement();
                        xmlStreamWriter.writeEndDocument();
                        xmlStreamWriter.close();
                        xmlStreamWriter = null;
                        xml = unsyncStringWriter.toString();
                    }
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (xmlStreamWriter != null) {
                        try {
                            xmlStreamWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (xmlStreamWriter != null) {
                    try {
                        xmlStreamWriter.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        return xml;
    }

    public void setLocalizedPreferencesValues(PortletRequest portletRequest, PortletPreferences preferences, String parameter) throws Exception {
        Map<Locale, String> map = this.getLocalizationMap(portletRequest, parameter);
        for (Map.Entry<Locale, String> entry : map.entrySet()) {
            String languageId = LocaleUtil.toLanguageId((Locale)entry.getKey());
            String value = entry.getValue();
            this.setPreferencesValue(preferences, parameter, languageId, value);
        }
    }

    public void setPreferencesValue(PortletPreferences preferences, String key, String languageId, String value) throws Exception {
        preferences.setValue(this.getPreferencesKey(key, languageId), value);
    }

    public void setPreferencesValues(PortletPreferences preferences, String key, String languageId, String[] values) throws Exception {
        preferences.setValues(this.getPreferencesKey(key, languageId), values);
    }

    public String updateLocalization(String xml, String key, String value) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        return this.updateLocalization(xml, key, value, defaultLanguageId, defaultLanguageId);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId) {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId) {
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, false);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata) {
        return this.updateLocalization(xml, key, value, requestedLanguageId, defaultLanguageId, cdata, true);
    }

    public String updateLocalization(String xml, String key, String value, String requestedLanguageId, String defaultLanguageId, boolean cdata, boolean localized) {
        block35: {
            xml = this._sanitizeXML(xml);
            XMLStreamReader xmlStreamReader = null;
            XMLStreamWriter xmlStreamWriter = null;
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                try {
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(portalClassLoader);
                    }
                    XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                    xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
                    String availableLocales = "";
                    if (xmlStreamReader.hasNext()) {
                        xmlStreamReader.nextTag();
                        availableLocales = xmlStreamReader.getAttributeValue(null, _AVAILABLE_LOCALES);
                        if (Validator.isNull((String)availableLocales)) {
                            availableLocales = defaultLanguageId;
                        }
                        if (availableLocales.indexOf(requestedLanguageId) == -1) {
                            availableLocales = StringUtil.add((String)availableLocales, (String)requestedLanguageId, (String)",");
                        }
                    }
                    UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
                    XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                    xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter((Writer)unsyncStringWriter);
                    xmlStreamWriter.writeStartDocument();
                    xmlStreamWriter.writeStartElement(_ROOT);
                    if (localized) {
                        xmlStreamWriter.writeAttribute(_AVAILABLE_LOCALES, availableLocales);
                        xmlStreamWriter.writeAttribute(_DEFAULT_LOCALE, defaultLanguageId);
                    }
                    this._copyNonExempt(xmlStreamReader, xmlStreamWriter, requestedLanguageId, defaultLanguageId, cdata);
                    xmlStreamWriter.writeStartElement(key);
                    if (localized) {
                        xmlStreamWriter.writeAttribute(_LANGUAGE_ID, requestedLanguageId);
                    }
                    if (cdata) {
                        xmlStreamWriter.writeCData(value);
                    } else {
                        xmlStreamWriter.writeCharacters(value);
                    }
                    xmlStreamWriter.writeEndElement();
                    xmlStreamWriter.writeEndElement();
                    xmlStreamWriter.writeEndDocument();
                    xmlStreamWriter.close();
                    xmlStreamWriter = null;
                    xml = unsyncStringWriter.toString();
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (xmlStreamWriter != null) {
                        try {
                            xmlStreamWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block35;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                if (xmlStreamWriter != null) {
                    try {
                        xmlStreamWriter.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        return xml;
    }

    private void _copyNonExempt(XMLStreamReader xmlStreamReader, XMLStreamWriter xmlStreamWriter, String exemptLanguageId, String defaultLanguageId, boolean cdata) throws XMLStreamException {
        while (xmlStreamReader.hasNext()) {
            int event = xmlStreamReader.next();
            if (event == 1) {
                String languageId = xmlStreamReader.getAttributeValue(null, _LANGUAGE_ID);
                if (Validator.isNull((String)languageId)) {
                    languageId = defaultLanguageId;
                }
                if (languageId.equals(exemptLanguageId)) continue;
                xmlStreamWriter.writeStartElement(xmlStreamReader.getLocalName());
                xmlStreamWriter.writeAttribute(_LANGUAGE_ID, languageId);
                while (xmlStreamReader.hasNext()) {
                    event = xmlStreamReader.next();
                    if (event == 4 || event == 12) {
                        String text = xmlStreamReader.getText();
                        if (cdata) {
                            xmlStreamWriter.writeCData(text);
                            break;
                        }
                        xmlStreamWriter.writeCharacters(xmlStreamReader.getText());
                        break;
                    }
                    if (event == 2) break;
                }
                xmlStreamWriter.writeEndElement();
                continue;
            }
            if (event == 8) break;
        }
    }

    private String _getCachedValue(String xml, String requestedLanguageId, boolean useDefault) {
        String value = null;
        Map<Tuple, String> valueMap = this._cache.get(xml);
        if (valueMap != null) {
            Tuple subkey = new Tuple(new Object[]{useDefault, requestedLanguageId});
            value = valueMap.get(subkey);
        }
        return value;
    }

    private String _getRootAttribute(String xml, String name, String defaultValue) {
        String value;
        block21: {
            value = null;
            XMLStreamReader xmlStreamReader = null;
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                try {
                    XMLInputFactory xmlInputFactory;
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(portalClassLoader);
                    }
                    if ((xmlStreamReader = (xmlInputFactory = XMLInputFactory.newInstance()).createXMLStreamReader((Reader)new UnsyncStringReader(xml))).hasNext()) {
                        xmlStreamReader.nextTag();
                        value = xmlStreamReader.getAttributeValue(null, name);
                    }
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e, (Throwable)e);
                    }
                    if (contextClassLoader != portalClassLoader) {
                        currentThread.setContextClassLoader(contextClassLoader);
                    }
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (contextClassLoader != portalClassLoader) {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (contextClassLoader != portalClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (Validator.isNull(value)) {
            value = defaultValue;
        }
        return value;
    }

    private String _sanitizeXML(String xml) {
        if (Validator.isNull((String)xml) || xml.indexOf("<root") == -1) {
            xml = _EMPTY_ROOT_NODE;
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setCachedValue(String xml, String requestedLanguageId, boolean useDefault, String value) {
        if (Validator.isNotNull((String)xml) && !xml.equals(_EMPTY_ROOT_NODE)) {
            Map<String, Map<Tuple, String>> map = this._cache;
            synchronized (map) {
                Map<Tuple, String> map2 = this._cache.get(xml);
                if (map2 == null) {
                    map2 = new HashMap<Tuple, String>();
                }
                Tuple subkey = new Tuple(new Object[]{useDefault, requestedLanguageId});
                map2.put(subkey, value);
                this._cache.put(xml, map2);
            }
        }
    }
}

