/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;

public class HtmlImpl
implements Html {
    public static final int ESCAPE_MODE_ATTRIBUTE = 1;
    public static final int ESCAPE_MODE_CSS = 2;
    public static final int ESCAPE_MODE_JS = 3;
    public static final int ESCAPE_MODE_TEXT = 4;
    public static final int ESCAPE_MODE_URL = 5;
    private static final String[] _MS_WORD_UNICODE = new String[]{"\u00ae", "\u2019", "\u201c", "\u201d"};
    private static final String[] _MS_WORD_HTML = new String[]{"&reg;", "'", "\"", "\""};
    private static final char[] _TAG_SCRIPT = new char[]{'s', 'c', 'r', 'i', 'p', 't'};

    public String escape(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        StringBundler sb = null;
        int lastReplacementIndex = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            String replacement = null;
            switch (c) {
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '\"': {
                    replacement = "&#034;";
                    break;
                }
                case '\'': {
                    replacement = "&#039;";
                    break;
                }
                case '\u00bb': {
                    replacement = "&#187;";
                    break;
                }
                case '\u2013': {
                    replacement = "&#x2013;";
                    break;
                }
                case '\u2014': {
                    replacement = "&#x2014;";
                }
            }
            if (replacement != null) {
                if (sb == null) {
                    sb = new StringBundler();
                }
                if (i > lastReplacementIndex) {
                    sb.append(text.substring(lastReplacementIndex, i));
                }
                sb.append(replacement);
                lastReplacementIndex = i + 1;
            }
            ++i;
        }
        if (sb == null) {
            return text;
        }
        if (lastReplacementIndex < text.length()) {
            sb.append(text.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    public String escape(String text, int type) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        String prefix = "";
        String postfix = "";
        if (type == 1) {
            prefix = "&#x";
            postfix = ";";
        } else if (type == 2) {
            prefix = "\\";
        } else if (type == 3) {
            prefix = "\\x";
        } else {
            if (type == 5) {
                return HttpUtil.encodeURL((String)text, (boolean)true);
            }
            return this.escape(text);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') {
                sb.append(c);
            } else {
                sb.append(prefix);
                String hexString = StringUtil.toHexString((int)c);
                if (hexString.length() == 1) {
                    sb.append(StringPool.ASCII_TABLE[48]);
                }
                sb.append(hexString);
                sb.append(postfix);
            }
            ++i;
        }
        if (sb.length() == text.length()) {
            return text;
        }
        return sb.toString();
    }

    public String escapeAttribute(String attribute) {
        return this.escape(attribute, 1);
    }

    public String escapeCSS(String css) {
        return this.escape(css, 2);
    }

    public String escapeHREF(String href) {
        String protocol;
        if (href == null) {
            return null;
        }
        if (href.length() == 0) {
            return "";
        }
        if (href.indexOf(":") == 10 && (protocol = href.substring(0, 10).toLowerCase()).equals("javascript")) {
            return StringUtil.replaceFirst((String)href, (String)":", (String)"%3a");
        }
        return href;
    }

    public String escapeJS(String js) {
        return this.escape(js, 3);
    }

    public String escapeURL(String url) {
        return this.escape(url, 5);
    }

    public String extractText(String html) {
        if (html == null) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        TextExtractor textExtractor = source.getTextExtractor();
        return textExtractor.toString();
    }

    public String fromInputSafe(String text) {
        return StringUtil.replace((String)text, (String)"&amp;", (String)"&");
    }

    public String replaceMsWordCharacters(String text) {
        return StringUtil.replace((String)text, (String[])_MS_WORD_UNICODE, (String[])_MS_WORD_HTML);
    }

    public String stripBetween(String text, String tag) {
        return StringUtil.stripBetween((String)text, (String)("<" + tag), (String)("</" + tag + ">"));
    }

    public String stripComments(String text) {
        return StringUtil.stripBetween((String)text, (String)"<!--", (String)"-->");
    }

    public String stripHtml(String text) {
        if (text == null) {
            return null;
        }
        text = this.stripComments(text);
        StringBuilder sb = new StringBuilder(text.length());
        int x = 0;
        int y = text.indexOf("<");
        while (y != -1) {
            sb.append(text.substring(x, y));
            sb.append(" ");
            boolean scriptFound = this.isScriptTag(text, y + 1);
            if (scriptFound) {
                int pos = y + _TAG_SCRIPT.length;
                if ((pos = text.indexOf(">", pos)) >= 0 && text.charAt(pos - 1) != '/') {
                    while ((pos = text.indexOf("</", pos)) >= 0) {
                        if (this.isScriptTag(text, pos + 2)) {
                            y = pos;
                            break;
                        }
                        pos += 2;
                    }
                }
            }
            if ((x = text.indexOf(">", y)) == -1 || ++x < y) break;
            y = text.indexOf("<", x);
        }
        if (y == -1) {
            sb.append(text.substring(x, text.length()));
        }
        return sb.toString();
    }

    public String toInputSafe(String text) {
        return StringUtil.replace((String)text, (String[])new String[]{"&", "\""}, (String[])new String[]{"&amp;", "&quot;"});
    }

    public String unescape(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        text = StringUtil.replace((String)text, (String)"&lt;", (String)"<");
        text = StringUtil.replace((String)text, (String)"&gt;", (String)">");
        text = StringUtil.replace((String)text, (String)"&amp;", (String)"&");
        text = StringUtil.replace((String)text, (String)"&#034;", (String)"\"");
        text = StringUtil.replace((String)text, (String)"&#039;", (String)"'");
        text = StringUtil.replace((String)text, (String)"&#040;", (String)"(");
        text = StringUtil.replace((String)text, (String)"&#041;", (String)")");
        text = StringUtil.replace((String)text, (String)"&#044;", (String)",");
        text = StringUtil.replace((String)text, (String)"&#035;", (String)"#");
        text = StringUtil.replace((String)text, (String)"&#037;", (String)"%");
        text = StringUtil.replace((String)text, (String)"&#059;", (String)";");
        text = StringUtil.replace((String)text, (String)"&#061;", (String)"=");
        text = StringUtil.replace((String)text, (String)"&#043;", (String)"+");
        text = StringUtil.replace((String)text, (String)"&#045;", (String)"-");
        return text;
    }

    public String unescapeCDATA(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        text = StringUtil.replace((String)text, (String)"&lt;![CDATA[", (String)"<![CDATA[");
        text = StringUtil.replace((String)text, (String)"]]&gt;", (String)"]]>");
        return text;
    }

    /*
     * Unable to fully structure code
     */
    public String wordBreak(String text, int columns) {
        sb = new StringBundler();
        length = 0;
        lastWrite = 0;
        pos = 0;
        pattern = Pattern.compile("([\\s<&]|$)");
        matcher = pattern.matcher(text);
        while (matcher.find()) {
            if (matcher.start() >= pos) ** GOTO lbl16
            continue;
lbl-1000:
            // 1 sources

            {
                sb.append(text.substring(lastWrite, pos += columns - length));
                sb.append("<wbr/>&shy;");
                length = 0;
                lastWrite = pos;
lbl16:
                // 2 sources

                ** while (length + matcher.start() - pos >= columns)
            }
lbl17:
            // 1 sources

            length += matcher.start() - pos;
            group = matcher.group();
            if (group.equals("&")) {
                x = text.indexOf(";", matcher.start());
                if (x == -1) continue;
                ++length;
                pos = x + 1;
                continue;
            }
            if (group.equals("<")) {
                x = text.indexOf(">", matcher.start());
                if (x == -1) continue;
                pos = x + 1;
                continue;
            }
            if (!group.equals(" ") && !group.equals("\n")) continue;
            length = 0;
            pos = matcher.start() + 1;
        }
        sb.append(text.substring(lastWrite));
        return sb.toString();
    }

    protected boolean isScriptTag(String text, int pos) {
        if (pos + _TAG_SCRIPT.length + 1 <= text.length()) {
            char item;
            int i = 0;
            while (i < _TAG_SCRIPT.length) {
                if (Character.toLowerCase(item = text.charAt(pos++)) != _TAG_SCRIPT[i]) {
                    return false;
                }
                ++i;
            }
            item = text.charAt(pos);
            return !Character.isLetter(item);
        }
        return false;
    }
}

