/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.PwdGenerator;
import com.liferay.util.ant.ExpandTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.tika.Tika;
import org.apache.tools.ant.DirectoryScanner;
import org.mozilla.intl.chardet.nsDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImpl
implements com.liferay.portal.kernel.util.File {
    private static final String[] _SAFE_FILE_NAME_1 = new String[]{"&", ")", "(", ";"};
    private static final String[] _SAFE_FILE_NAME_2 = new String[]{"_AMP_", "_CP_", "_OP_", "_SEM_"};
    private static Log _log = LogFactoryUtil.getLog(FileImpl.class);
    private static FileImpl _instance = new FileImpl();

    public static FileImpl getInstance() {
        return _instance;
    }

    public void copyDirectory(File source, File destination) throws IOException {
        if (source.exists() && source.isDirectory()) {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            File[] fileArray = source.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                if (fileArray[i].isDirectory()) {
                    this.copyDirectory(fileArray[i], new File(String.valueOf(destination.getPath()) + File.separator + fileArray[i].getName()));
                } else {
                    this.copyFile(fileArray[i], new File(String.valueOf(destination.getPath()) + File.separator + fileArray[i].getName()));
                }
                ++i;
            }
        }
    }

    public void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        this.copyDirectory(new File(sourceDirName), new File(destinationDirName));
    }

    public void copyFile(File source, File destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    public void copyFile(File source, File destination, boolean lazy) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (lazy) {
            String oldContent = null;
            try {
                oldContent = this.read(source);
            }
            catch (Exception exception) {
                return;
            }
            String newContent = null;
            try {
                newContent = this.read(destination);
            }
            catch (Exception exception) {}
            if (oldContent == null || !oldContent.equals(newContent)) {
                this.copyFile(source, destination, false);
            }
        } else {
            if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            StreamUtil.transfer((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(destination));
        }
    }

    public void copyFile(String source, String destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    public void copyFile(String source, String destination, boolean lazy) throws IOException {
        this.copyFile(new File(source), new File(destination), lazy);
    }

    public File createTempFile() {
        return this.createTempFile("");
    }

    public File createTempFile(byte[] bytes) throws IOException {
        File file = this.createTempFile("");
        this.write(file, bytes);
        return file;
    }

    public File createTempFile(InputStream is) throws IOException {
        File file = this.createTempFile("");
        this.write(file, is);
        return file;
    }

    public File createTempFile(String extension) {
        return new File(this.createTempFileName(extension));
    }

    public String createTempFileName() {
        return this.createTempFileName(null);
    }

    public String createTempFileName(String extension) {
        StringBundler sb = new StringBundler();
        sb.append(SystemProperties.get((String)"java.io.tmpdir"));
        sb.append("/");
        sb.append(Time.getTimestamp());
        sb.append(PwdGenerator.getPassword((String)PwdGenerator.KEY2, (int)8));
        if (Validator.isNotNull((String)extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    public String decodeSafeFileName(String fileName) {
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_2, (String[])_SAFE_FILE_NAME_1);
    }

    public boolean delete(File file) {
        if (file != null && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public boolean delete(String file) {
        return this.delete(new File(file));
    }

    public void deltree(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                if (fileArray[i].isDirectory()) {
                    this.deltree(fileArray[i]);
                } else {
                    fileArray[i].delete();
                }
                ++i;
            }
            directory.delete();
        }
    }

    public void deltree(String directory) {
        this.deltree(new File(directory));
    }

    public String encodeSafeFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return StringUtil.replace((String)fileName, (String[])_SAFE_FILE_NAME_1, (String[])_SAFE_FILE_NAME_2);
    }

    public boolean exists(File file) {
        return file.exists();
    }

    public boolean exists(String fileName) {
        return this.exists(new File(fileName));
    }

    public String extractText(InputStream is, String fileName) {
        String text = null;
        try {
            String mimeType;
            Tika tika = new Tika();
            boolean forkProcess = false;
            if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains((Object[])PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, (Object)(mimeType = tika.detect(is)))) {
                forkProcess = true;
            }
            text = forkProcess ? (String)((Object)ProcessExecutor.execute((ProcessCallable)new ExtractTextProcessCallable(this.getBytes(is)), (String)ClassPathUtil.getPortalClassPath())) : tika.parseToString(is);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isInfoEnabled()) {
            if (text == null) {
                _log.info((Object)("Text extraction failed for " + fileName));
            } else {
                _log.info((Object)("Text was extracted for " + fileName));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Extractor returned text:\n\n" + text));
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String[] find(String directory, String includes, String excludes) {
        if (directory.length() > 0 && (directory = this.replaceSeparator(directory)).charAt(directory.length() - 1) == '/') {
            directory = directory.substring(0, directory.length() - 1);
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(directory);
        directoryScanner.setExcludes(StringUtil.split((String)excludes));
        directoryScanner.setIncludes(StringUtil.split((String)includes));
        directoryScanner.scan();
        String[] includedFiles = directoryScanner.getIncludedFiles();
        int i = 0;
        while (i < includedFiles.length) {
            includedFiles[i] = directory.concat("/").concat(this.replaceSeparator(includedFiles[i]));
            ++i;
        }
        return includedFiles;
    }

    public String getAbsolutePath(File file) {
        return StringUtil.replace((String)file.getAbsolutePath(), (char)'\\', (char)'/');
    }

    public byte[] getBytes(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] bytes = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(bytes);
        randomAccessFile.close();
        return bytes;
    }

    public byte[] getBytes(InputStream is) throws IOException {
        return this.getBytes(is, -1);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize) throws IOException {
        return this.getBytes(inputStream, bufferSize, true);
    }

    public byte[] getBytes(InputStream inputStream, int bufferSize, boolean cleanUpStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)bufferSize, (boolean)cleanUpStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return fileName.substring(pos + 1, fileName.length()).toLowerCase();
        }
        return "";
    }

    public String getPath(String fullFileName) {
        String shortFileName;
        int pos = fullFileName.lastIndexOf(47);
        if (pos == -1) {
            pos = fullFileName.lastIndexOf(92);
        }
        if (Validator.isNull((String)(shortFileName = fullFileName.substring(0, pos)))) {
            return "/";
        }
        return shortFileName;
    }

    public String getShortFileName(String fullFileName) {
        int pos = fullFileName.lastIndexOf(47);
        if (pos == -1) {
            pos = fullFileName.lastIndexOf(92);
        }
        String shortFileName = fullFileName.substring(pos + 1, fullFileName.length());
        return shortFileName;
    }

    public boolean isAscii(File file) throws IOException {
        boolean ascii = true;
        nsDetector detector = new nsDetector(0);
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1) {
            if (ascii && !(ascii = detector.isAscii(buffer, len))) break;
        }
        detector.DataEnd();
        ((InputStream)inputStream).close();
        return ascii;
    }

    /*
     * Exception decompiling
     */
    public boolean isSameContent(File file, byte[] bytes, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isSameContent(File file, String s) {
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (String)s);
        return this.isSameContent(file, byteBuffer.array(), byteBuffer.limit());
    }

    public String[] listDirs(File file) {
        ArrayList<String> dirs = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        int i = 0;
        while (fileArray != null && i < fileArray.length) {
            if (fileArray[i].isDirectory()) {
                dirs.add(fileArray[i].getName());
            }
            ++i;
        }
        return dirs.toArray(new String[dirs.size()]);
    }

    public String[] listDirs(String fileName) {
        return this.listDirs(new File(fileName));
    }

    public String[] listFiles(File file) {
        ArrayList<String> files = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        int i = 0;
        while (fileArray != null && i < fileArray.length) {
            if (fileArray[i].isFile()) {
                files.add(fileArray[i].getName());
            }
            ++i;
        }
        return files.toArray(new String[files.size()]);
    }

    public String[] listFiles(String fileName) {
        if (Validator.isNull((String)fileName)) {
            return new String[0];
        }
        return this.listFiles(new File(fileName));
    }

    public void mkdirs(String pathName) {
        File file = new File(pathName);
        file.mkdirs();
    }

    public boolean move(File source, File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        return source.renameTo(destination);
    }

    public boolean move(String sourceFileName, String destinationFileName) {
        return this.move(new File(sourceFileName), new File(destinationFileName));
    }

    public String read(File file) throws IOException {
        return this.read(file, false);
    }

    public String read(File file, boolean raw) throws IOException {
        byte[] bytes = this.getBytes(file);
        if (bytes == null) {
            return null;
        }
        String s = new String(bytes, "UTF-8");
        if (raw) {
            return s;
        }
        return StringUtil.replace((String)s, (String)"\r\n", (String)"\n");
    }

    public String read(String fileName) throws IOException {
        return this.read(new File(fileName));
    }

    public String replaceSeparator(String fileName) {
        return StringUtil.replace((String)fileName, (char)'\\', (char)'/');
    }

    public File[] sortFiles(File[] files) {
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        ArrayList<File> directoryList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                directoryList.add(files[i]);
            } else {
                fileList.add(files[i]);
            }
            ++i;
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new File[directoryList.size()]);
    }

    public String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = this.getExtension(fileName);
        if (ext.length() > 0) {
            return fileName.substring(0, fileName.length() - ext.length() - 1);
        }
        return fileName;
    }

    public List<String> toList(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                list.add(line);
            }
            unsyncBufferedReader.close();
        }
        catch (IOException iOException) {}
        return list;
    }

    public List<String> toList(String fileName) {
        try {
            return this.toList(new FileReader(fileName));
        }
        catch (IOException iOException) {
            return new ArrayList<String>();
        }
    }

    public Properties toProperties(FileInputStream fis) {
        Properties properties = new Properties();
        try {
            properties.load(fis);
        }
        catch (IOException iOException) {}
        return properties;
    }

    public Properties toProperties(String fileName) {
        try {
            return this.toProperties(new FileInputStream(fileName));
        }
        catch (IOException iOException) {
            return new Properties();
        }
    }

    public void touch(File file) throws IOException {
        FileUtils.touch((File)file);
    }

    public void touch(String fileName) throws IOException {
        this.touch(new File(fileName));
    }

    public void unzip(File source, File destination) {
        ExpandTask.expand((File)source, (File)destination);
    }

    public void write(File file, byte[] bytes) throws IOException {
        this.write(file, bytes, 0, bytes.length);
    }

    public void write(File file, byte[] bytes, int offset, int length) throws IOException {
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(bytes, offset, length);
        fileOutputStream.close();
    }

    public void write(File file, InputStream is) throws IOException {
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        StreamUtil.transfer((InputStream)is, (OutputStream)new FileOutputStream(file));
    }

    public void write(File file, String s) throws IOException {
        this.write(file, s, false);
    }

    public void write(File file, String s, boolean lazy) throws IOException {
        this.write(file, s, lazy, false);
    }

    public void write(File file, String s, boolean lazy, boolean append) throws IOException {
        String content;
        if (s == null) {
            return;
        }
        if (file.getParent() != null) {
            this.mkdirs(file.getParent());
        }
        if (lazy && file.exists() && (content = this.read(file)).equals(s)) {
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");
        writer.write(s);
        ((Writer)writer).close();
    }

    public void write(String fileName, byte[] bytes) throws IOException {
        this.write(new File(fileName), bytes);
    }

    public void write(String fileName, InputStream is) throws IOException {
        this.write(new File(fileName), is);
    }

    public void write(String fileName, String s) throws IOException {
        this.write(new File(fileName), s);
    }

    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.write(new File(fileName), s, lazy);
    }

    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new File(fileName), s, lazy, append);
    }

    public void write(String pathName, String fileName, String s) throws IOException {
        this.write(new File(pathName, fileName), s);
    }

    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.write(new File(pathName, fileName), s, lazy);
    }

    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new File(pathName, fileName), s, lazy, append);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTextProcessCallable
    implements ProcessCallable<String> {
        private byte[] _data;

        public ExtractTextProcessCallable(byte[] data) {
            this._data = data;
        }

        public String call() throws ProcessException {
            Tika tika = new Tika();
            try {
                return tika.parseToString((InputStream)new UnsyncByteArrayInputStream(this._data));
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }
}

