/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upload.LiferayFileItem;
import com.liferay.portal.upload.LiferayFileItemFactory;
import com.liferay.portal.upload.LiferayFileUpload;
import com.liferay.portal.upload.LiferayServletRequest;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadServletRequestImpl
extends HttpServletRequestWrapper
implements UploadServletRequest {
    private static Log _log = LogFactoryUtil.getLog(UploadServletRequestImpl.class);
    private static File _tempDir;
    private LiferayServletRequest _liferayServletRequest;
    private Map<String, LiferayFileItem[]> _params;

    public static File getTempDir() throws SystemException {
        if (_tempDir == null) {
            _tempDir = new File(PrefsPropsUtil.getString("com.liferay.portal.upload.UploadServletRequestImpl.temp.dir", SystemProperties.get((String)"java.io.tmpdir")));
        }
        return _tempDir;
    }

    public static void setTempDir(File tempDir) {
        _tempDir = tempDir;
    }

    public UploadServletRequestImpl(HttpServletRequest request) {
        block7: {
            super(request);
            this._params = new LinkedHashMap<String, LiferayFileItem[]>();
            try {
                LiferayFileUpload servletFileUpload = new LiferayFileUpload((FileItemFactory)new LiferayFileItemFactory(UploadServletRequestImpl.getTempDir()), request);
                servletFileUpload.setSizeMax(PrefsPropsUtil.getLong("com.liferay.portal.upload.UploadServletRequestImpl.max.size"));
                this._liferayServletRequest = new LiferayServletRequest(request);
                List liferayFileItemsList = servletFileUpload.parseRequest((HttpServletRequest)this._liferayServletRequest);
                for (LiferayFileItem liferayFileItem : liferayFileItemsList) {
                    LiferayFileItem[] liferayFileItems;
                    if (liferayFileItem.isFormField()) {
                        liferayFileItem.setString(request.getCharacterEncoding());
                    }
                    if ((liferayFileItems = this._params.get(liferayFileItem.getFieldName())) == null) {
                        liferayFileItems = new LiferayFileItem[]{liferayFileItem};
                    } else {
                        LiferayFileItem[] newLiferayFileItems = new LiferayFileItem[liferayFileItems.length + 1];
                        System.arraycopy(liferayFileItems, 0, newLiferayFileItems, 0, liferayFileItems.length);
                        newLiferayFileItems[newLiferayFileItems.length - 1] = liferayFileItem;
                        liferayFileItems = newLiferayFileItems;
                    }
                    this._params.put(liferayFileItem.getFieldName(), liferayFileItems);
                }
            }
            catch (Exception e) {
                UploadException uploadException = new UploadException((Throwable)e);
                if (e instanceof FileUploadBase.FileSizeLimitExceededException || e instanceof FileUploadBase.SizeLimitExceededException) {
                    uploadException.setExceededSizeLimit(true);
                }
                request.setAttribute("UPLOAD_EXCEPTION", (Object)uploadException);
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cleanUp() {
        if (this._params != null && !this._params.isEmpty()) {
            Iterator<LiferayFileItem[]> iterator = this._params.values().iterator();
            while (iterator.hasNext()) {
                LiferayFileItem[] liferayFileItems;
                LiferayFileItem[] liferayFileItemArray = liferayFileItems = iterator.next();
                int n = liferayFileItems.length;
                int n2 = 0;
                while (n2 < n) {
                    LiferayFileItem liferayFileItem = liferayFileItemArray[n2];
                    liferayFileItem.delete();
                    ++n2;
                }
            }
        }
    }

    public String getContentType(String name) {
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            LiferayFileItem liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getContentType();
        }
        return null;
    }

    public File getFile(String name) {
        return this.getFile(name, false);
    }

    public File getFile(String name, boolean forceCreate) {
        File file;
        block5: {
            if (this.getFileName(name) == null) {
                return null;
            }
            LiferayFileItem[] liferayFileItems = this._params.get(name);
            file = null;
            if (liferayFileItems != null && liferayFileItems.length > 0) {
                LiferayFileItem liferayFileItem = liferayFileItems[0];
                file = liferayFileItem.getStoreLocation();
                if (liferayFileItem.isInMemory() && forceCreate) {
                    try {
                        FileUtil.write((File)file, (InputStream)liferayFileItem.getInputStream());
                    }
                    catch (IOException ioe) {
                        if (!_log.isWarnEnabled()) break block5;
                        _log.warn((Object)("Unable to write temporary file " + file.getAbsolutePath()), (Throwable)ioe);
                    }
                }
            }
        }
        return file;
    }

    public InputStream getFileAsStream(String name) throws IOException {
        return this.getFileAsStream(name, true);
    }

    public InputStream getFileAsStream(String name, boolean deleteOnClose) throws IOException {
        if (this.getFileName(name) == null) {
            return null;
        }
        InputStream inputStream = null;
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            LiferayFileItem liferayFileItem = liferayFileItems[0];
            inputStream = this.getInputStream(liferayFileItem, deleteOnClose);
        }
        return inputStream;
    }

    public String getFileName(String name) {
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            LiferayFileItem liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getFileName();
        }
        return null;
    }

    public String[] getFileNames(String name) {
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            String[] fileNames = new String[liferayFileItems.length];
            int i = 0;
            while (i < liferayFileItems.length) {
                LiferayFileItem liferayFileItem = liferayFileItems[i];
                fileNames[i] = liferayFileItem.getFileName();
                ++i;
            }
            return fileNames;
        }
        return null;
    }

    public File[] getFiles(String name) {
        String[] fileNames = this.getFileNames(name);
        if (fileNames == null) {
            return null;
        }
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            File[] files = new File[liferayFileItems.length];
            int i = 0;
            while (i < liferayFileItems.length) {
                LiferayFileItem liferayFileItem = liferayFileItems[i];
                if (Validator.isNotNull((String)liferayFileItem.getFileName())) {
                    files[i] = liferayFileItem.getStoreLocation();
                }
                ++i;
            }
            return files;
        }
        return null;
    }

    public InputStream[] getFilesAsStream(String name) throws IOException {
        return this.getFilesAsStream(name, true);
    }

    public InputStream[] getFilesAsStream(String name, boolean deleteOnClose) throws IOException {
        String[] fileNames = this.getFileNames(name);
        if (fileNames == null) {
            return null;
        }
        InputStream[] inputStreams = null;
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            inputStreams = new InputStream[liferayFileItems.length];
            int i = 0;
            while (i < liferayFileItems.length) {
                LiferayFileItem liferayFileItem = liferayFileItems[i];
                if (Validator.isNotNull((String)liferayFileItem.getFileName())) {
                    inputStreams[i] = this.getInputStream(liferayFileItem, deleteOnClose);
                }
                ++i;
            }
        }
        return inputStreams;
    }

    public String getFullFileName(String name) {
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            LiferayFileItem liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getFullFileName();
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this._liferayServletRequest.getInputStream();
    }

    public Map<String, LiferayFileItem[]> getMultipartParameterMap() {
        return this._params;
    }

    public String getParameter(String name) {
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            LiferayFileItem liferayFileItem = liferayFileItems[0];
            File storeLocationFile = liferayFileItem.getStoreLocation();
            if (storeLocationFile.length() > (long)LiferayFileItem.THRESHOLD_SIZE) {
                this._liferayServletRequest.setAttribute("FILE_ITEM_THRESHOLD_SIZE_EXCEEDED", Boolean.TRUE);
                return liferayFileItem.getEncodedString();
            }
            return liferayFileItem.getString();
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        LinkedHashSet<String> parameterNames = new LinkedHashSet<String>();
        Enumeration enu = super.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (this._params.containsKey(name)) continue;
            parameterNames.add(name);
        }
        parameterNames.addAll(this._params.keySet());
        return Collections.enumeration(parameterNames);
    }

    public String[] getParameterValues(String name) {
        String[] parentValues = super.getParameterValues(name);
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems == null || liferayFileItems.length == 0) {
            return parentValues;
        }
        if (parentValues == null || parentValues.length == 0) {
            String[] values = new String[liferayFileItems.length];
            int i = 0;
            while (i < values.length) {
                LiferayFileItem liferayFileItem = liferayFileItems[i];
                values[i] = liferayFileItem.getString();
                ++i;
            }
            return values;
        }
        String[] values = new String[parentValues.length + liferayFileItems.length];
        System.arraycopy(parentValues, 0, values, 0, parentValues.length);
        int i = parentValues.length;
        while (i < values.length) {
            values[i] = liferayFileItems[i - parentValues.length].getString();
            ++i;
        }
        return values;
    }

    public Long getSize(String name) {
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            LiferayFileItem liferayFileItem = liferayFileItems[0];
            return new Long(liferayFileItem.getSize());
        }
        return null;
    }

    public Boolean isFormField(String name) {
        LiferayFileItem[] liferayFileItems = this._params.get(name);
        if (liferayFileItems != null && liferayFileItems.length > 0) {
            LiferayFileItem liferayFileItem = liferayFileItems[0];
            return new Boolean(liferayFileItem.isFormField());
        }
        return null;
    }

    protected InputStream getInputStream(LiferayFileItem liferayFileItem, boolean deleteOnClose) throws IOException {
        InputStream inputStream = null;
        if (liferayFileItem.isInMemory() && liferayFileItem.getSize() > 0L) {
            inputStream = liferayFileItem.getInputStream();
        } else if (!liferayFileItem.isInMemory()) {
            inputStream = new ByteArrayFileInputStream(liferayFileItem.getStoreLocation(), liferayFileItem.getSizeThreshold(), deleteOnClose);
        }
        return inputStream;
    }
}

