/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upload.LiferayFileItem;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayFileUpload
extends ServletFileUpload {
    public static final String FILE_NAME = String.valueOf(LiferayFileUpload.class.getName()) + "_FILE_NAME";
    public static final String PERCENT = ProgressTracker.PERCENT;
    private HttpSession _session;

    public LiferayFileUpload(FileItemFactory fileItemFactory, HttpServletRequest request) {
        super(fileItemFactory);
        this._session = request.getSession();
    }

    public List<LiferayFileItem> parseRequest(HttpServletRequest request) throws FileUploadException {
        this._session.removeAttribute(FILE_NAME);
        this._session.removeAttribute(PERCENT);
        return super.parseRequest(request);
    }

    protected FileItem createItem(Map headers, boolean formField) throws FileUploadException {
        LiferayFileItem item = (LiferayFileItem)super.createItem(headers, formField);
        String fileName = item.getFileName();
        if (Validator.isNotNull((String)fileName)) {
            this._session.setAttribute(FILE_NAME, (Object)fileName);
        }
        return item;
    }
}

