/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.social.util.SocialCounterPeriodUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeSocial
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeSocial.class);
    private Map<String, Tuple> _equityToActivityMap = new HashMap<String, Tuple>();

    public UpgradeSocial() {
        this.putEquityToActivityMap(BlogsEntry.class, "ADD_DISCUSSION", 10005);
        this.putEquityToActivityMap(BlogsEntry.class, "ADD_ENTRY", 2);
        this.putEquityToActivityMap(BlogsEntry.class, "ADD_VOTE", 10004);
        this.putEquityToActivityMap(BlogsEntry.class, "SUBSCRIBE", 10002);
        this.putEquityToActivityMap(BlogsEntry.class, "UPDATE", 3);
        this.putEquityToActivityMap(BlogsEntry.class, "VIEW", 10001);
        this.putEquityToActivityMap(JournalArticle.class, "ADD_ARTICLE", 1);
        this.putEquityToActivityMap(JournalArticle.class, "ADD_DISCUSSION", 10005);
        this.putEquityToActivityMap(JournalArticle.class, "UPDATE", 2);
        this.putEquityToActivityMap(JournalArticle.class, "VIEW", 10001);
        this.putEquityToActivityMap(MBCategory.class, "SUBSCRIBE", 10002);
        this.putEquityToActivityMap(MBMessage.class, "ADD_MESSAGE", 1);
        this.putEquityToActivityMap(MBMessage.class, "ADD_VOTE", 10004);
        this.putEquityToActivityMap(MBMessage.class, "REPLY_TO_MESSAGE", 2);
        this.putEquityToActivityMap(MBMessage.class, "VIEW", 10001);
        this.putEquityToActivityMap(MBThread.class, "SUBSCRIBE", MBMessage.class, 10002);
        this.putEquityToActivityMap(WikiNode.class, "SUBSCRIBE", 10002);
        this.putEquityToActivityMap(WikiPage.class, "ADD_ATTACHMENT", 10006);
        this.putEquityToActivityMap(WikiPage.class, "ADD_DISCUSSION", 10005);
        this.putEquityToActivityMap(WikiPage.class, "ADD_PAGE", 1);
        this.putEquityToActivityMap(WikiPage.class, "SUBSCRIBE", 10002);
        this.putEquityToActivityMap(WikiPage.class, "UPDATE", 2);
        this.putEquityToActivityMap(WikiPage.class, "VIEW", 10001);
    }

    protected void addActivityCounter(long activityCounterId, long groupId, long companyId, long classNameId, long classPK, String name, int ownerType, int currentValue, int totalValue, int graceValue, int startPeriod, int endPeriod) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(5);
            sb.append("insert into SocialActivityCounter (activityCounterId, ");
            sb.append("groupId, companyId, classNameId, classPK, name, ");
            sb.append("ownerType, currentValue, totalValue, graceValue, ");
            sb.append("startPeriod, endPeriod) values (?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?)");
            ps = con.prepareStatement(sb.toString());
            ps.setLong(1, activityCounterId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, classNameId);
            ps.setLong(5, classPK);
            ps.setString(6, name);
            ps.setInt(7, ownerType);
            ps.setInt(8, currentValue);
            ps.setInt(9, totalValue);
            ps.setInt(10, graceValue);
            ps.setInt(11, startPeriod);
            ps.setInt(12, endPeriod);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
    }

    protected void addActivitySetting(long groupId, long companyId, long classNameId, int activityType, String name, int ownerType, int limitValue, int value) throws Exception {
        JSONObject valueJSONObject = JSONFactoryUtil.createJSONObject();
        valueJSONObject.put("enabled", true);
        valueJSONObject.put("limitPeriod", 1);
        valueJSONObject.put("limitValue", limitValue);
        valueJSONObject.put("ownerType", ownerType);
        valueJSONObject.put("value", value);
        this.addActivitySetting(this.increment(), groupId, companyId, classNameId, activityType, name, valueJSONObject.toString());
    }

    protected void addActivitySetting(long activitySettingId, long groupId, long companyId, long classNameId, int activityType, String name, String value) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("insert into SocialActivitySetting (activitySettingId, groupId, companyId, classNameId, activityType, name, value) values (?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, activitySettingId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, classNameId);
            ps.setInt(5, activityType);
            ps.setString(6, name);
            ps.setString(7, value);
            ps.executeUpdate();
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }

    protected void doUpgrade() throws Exception {
        this.migrateEquityGroupSettings();
        this.migrateEquitySettings();
        this.migrateEquityLogs();
        this.dropEquityTables();
    }

    protected void dropEquityTables() throws Exception {
        this.runSQL("drop table SocialEquityAssetEntry");
        this.runSQL("drop table SocialEquityGroupSetting");
        this.runSQL("drop table SocialEquityHistory");
        this.runSQL("drop table SocialEquityLog");
        this.runSQL("drop table SocialEquitySetting");
        this.runSQL("drop table SocialEquityUser");
    }

    protected String encodeEquityToActivityKey(long classNameId, String actionId) {
        StringBundler sb = new StringBundler(3);
        sb.append(classNameId);
        sb.append("#");
        sb.append(actionId);
        return sb.toString();
    }

    protected Object[] getActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType, int startPeriod, int endPeriod) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            Object[] objectArray;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                StringBundler sb = new StringBundler(4);
                sb.append("select activityCounterId, totalValue from ");
                sb.append("SocialActivityCounter where groupId = ? and ");
                sb.append("classNameId = ? and classPK = ? and name = ? and ");
                sb.append("ownerType = ? and startPeriod = ? and endPeriod = ?");
                ps = con.prepareStatement(sb.toString());
                ps.setLong(1, groupId);
                ps.setLong(2, classNameId);
                ps.setLong(3, classPK);
                ps.setString(4, name);
                ps.setInt(5, ownerType);
                ps.setInt(6, startPeriod);
                ps.setInt(7, endPeriod);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                long activityCounterId = rs.getLong("activityCounterId");
                int totalValue = rs.getInt("totalValue");
                objectArray = new Object[]{activityCounterId, totalValue};
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return objectArray;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return null;
    }

    protected int getTotalValue(long groupId, long classNameId, long classPK, String name, int ownerType, int startPeriod) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            int n;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                StringBundler sb = new StringBundler(4);
                sb.append("select max(totalValue) as totalValue from ");
                sb.append("SocialActivityCounter where groupId = ? and ");
                sb.append("classNameId = ? and classPK = ? and name = ? and ");
                sb.append("ownerType = ? and startPeriod < ?");
                ps = con.prepareStatement(sb.toString());
                ps.setLong(1, groupId);
                ps.setLong(2, classNameId);
                ps.setLong(3, classPK);
                ps.setString(4, name);
                ps.setInt(5, ownerType);
                ps.setInt(6, startPeriod);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                n = rs.getInt("totalValue");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return n;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0;
    }

    protected void migrateEquityGroupSettings() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select groupId, companyId, classNameId, enabled from SocialEquityGroupSetting where type_ = 1");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long classNameId = rs.getLong("classNameId");
                boolean enabled = rs.getBoolean("enabled");
                this.addActivitySetting(this.increment(), groupId, companyId, classNameId, 0, "enabled", String.valueOf(enabled));
            }
            DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
            StringBundler sb = new StringBundler(12);
            sb.append("select groupId from SocialActivitySetting where ");
            sb.append("activityType = 0 and name = 'enabled' and ");
            sb.append("value = 'true' and classNameId in (");
            long mbMessageClassNameId = PortalUtil.getClassNameId(MBMessage.class);
            sb.append(mbMessageClassNameId);
            sb.append(", ");
            long mbThreadClassNameId = PortalUtil.getClassNameId(MBThread.class);
            sb.append(mbThreadClassNameId);
            sb.append(")");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                sb = new StringBundler(6);
                sb.append("update SocialActivitySetting set value = 'true' ");
                sb.append("where groupId = ");
                sb.append(groupId);
                sb.append(" and activityType = 0 and value = 'enabled' and ");
                sb.append("classNameId = ");
                sb.append(mbThreadClassNameId);
                this.runSQL(sb.toString());
            }
            this.runSQL("delete from SocialActivitySetting where classNameId = " + mbThreadClassNameId);
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void migrateEquityLog(ResultSet rs) throws Exception {
        String className;
        long assetEntryId = rs.getLong("assetEntryId");
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchAssetEntry((long)assetEntryId);
        if (assetEntry == null) {
            return;
        }
        String actionId = rs.getString("actionId");
        if (actionId.equals("SUBSCRIBE") && (className = assetEntry.getClassName()).equals(MBThread.class.getName())) {
            MBThread mbThread = MBThreadLocalServiceUtil.fetchThread((long)assetEntry.getClassPK());
            if (mbThread == null) {
                return;
            }
            assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)MBMessage.class.getName(), (long)mbThread.getRootMessageId());
            if (assetEntry == null) {
                return;
            }
        }
        long classNameId = PortalUtil.getClassNameId(User.class);
        long classPK = rs.getLong("userId");
        String name = "participation";
        int ownerType = 1;
        int actionDate = rs.getInt("actionDate");
        Date actionDateDate = SocialCounterPeriodUtil.getDate((int)(actionDate - 365));
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod((long)actionDateDate.getTime());
        int endPeriod = SocialCounterPeriodUtil.getEndPeriod((long)actionDateDate.getTime());
        if (endPeriod == SocialCounterPeriodUtil.getEndPeriod()) {
            endPeriod = -1;
        }
        int type = rs.getInt("type_");
        int value = rs.getInt("value");
        if (type == 1) {
            name = "contribution";
            ownerType = 3;
            this.updateActivityCounter(this.increment(), assetEntry.getGroupId(), assetEntry.getCompanyId(), classNameId, assetEntry.getUserId(), name, ownerType, startPeriod, endPeriod, value);
            classNameId = assetEntry.getClassNameId();
            classPK = assetEntry.getClassPK();
            name = "popularity";
            ownerType = 2;
        }
        long equityLogId = rs.getLong("equityLogId");
        this.updateActivityCounter(equityLogId, assetEntry.getGroupId(), assetEntry.getCompanyId(), classNameId, classPK, name, ownerType, startPeriod, endPeriod, value);
    }

    protected void migrateEquityLogs() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("select AssetEntry.classNameId, AssetEntry.classPK, ");
            sb.append("SocialEquityLog.* from SocialEquityLog, AssetEntry ");
            sb.append("where SocialEquityLog.assetEntryId = ");
            sb.append("AssetEntry.entryId order by actionDate");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                this.migrateEquityLog(rs);
            }
            DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
            sb = new StringBundler(4);
            sb.append("select groupId, classNameId, classPK, name, ");
            sb.append("max(startPeriod) as startPeriod ");
            sb.append("from SocialActivityCounter group by groupId, ");
            sb.append("classNameId, classPK, name");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long classNameId = rs.getLong("classNameId");
                long classPK = rs.getLong("classPK");
                String name = rs.getString("name");
                int startPeriod = rs.getInt("startPeriod");
                sb = new StringBundler(12);
                sb.append("update SocialActivityCounter set endPeriod = ");
                sb.append(-1);
                sb.append(" where groupId = ");
                sb.append(groupId);
                sb.append(" and classNameId = ");
                sb.append(classNameId);
                sb.append(" and classPK = ");
                sb.append(classPK);
                sb.append(" and name = '");
                sb.append(name);
                sb.append("' and startPeriod = ");
                sb.append(startPeriod);
                this.runSQL(sb.toString());
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void migrateEquitySettings() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select groupId, companyId, classNameId, actionId, dailyLimit, type_, value from SocialEquitySetting");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long classNameId = rs.getLong("classNameId");
                String actionId = rs.getString("actionId");
                int dailyLimit = rs.getInt("dailyLimit");
                int type = rs.getInt("type_");
                int value = rs.getInt("value");
                Tuple tuple = this._equityToActivityMap.get(this.encodeEquityToActivityKey(classNameId, actionId));
                if (tuple == null) {
                    StringBundler sb = new StringBundler();
                    sb.append("Unknown Social Equity setting with action ");
                    sb.append(actionId);
                    sb.append("for ");
                    String className = PortalUtil.getClassName((long)classNameId);
                    sb.append(className);
                    sb.append(". Please configure this action using the ");
                    sb.append("Social Activity portlet in the Control Panel.");
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)sb.toString());
                    continue;
                }
                long activityClassNameId = GetterUtil.getLong((Object)tuple.getObject(0));
                int activityType = GetterUtil.getInteger((Object)tuple.getObject(1));
                if (type == 1) {
                    this.addActivitySetting(groupId, companyId, activityClassNameId, activityType, "contribution", 3, dailyLimit, value);
                    this.addActivitySetting(groupId, companyId, activityClassNameId, activityType, "popularity", 2, dailyLimit, value);
                    continue;
                }
                if (type != 2) continue;
                this.addActivitySetting(groupId, companyId, activityClassNameId, activityType, "participation", 1, dailyLimit, value);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void putEquityToActivityMap(Class<?> equityClass, String equityActionId, Class<?> activityClass, int activityType) {
        long equityClassNameId = PortalUtil.getClassNameId(equityClass);
        long activityClassNameId = PortalUtil.getClassNameId(activityClass);
        this._equityToActivityMap.put(this.encodeEquityToActivityKey(equityClassNameId, equityActionId), new Tuple(new Object[]{activityClassNameId, activityType}));
    }

    protected void putEquityToActivityMap(Class<?> equityClass, String equityActionId, int activityType) {
        this.putEquityToActivityMap(equityClass, equityActionId, equityClass, activityType);
    }

    protected void updateActivityCounter(long activityCounterId, long groupId, long companyId, long classNameId, long classPK, String name, int ownerType, int startPeriod, int endPeriod, int increment) throws Exception {
        Object[] activityCounter = this.getActivityCounter(groupId, classNameId, classPK, name, ownerType, startPeriod, endPeriod);
        if (activityCounter == null) {
            int totalValue = this.getTotalValue(groupId, classNameId, classPK, name, ownerType, startPeriod);
            this.addActivityCounter(activityCounterId, groupId, companyId, classNameId, classPK, name, ownerType, increment, totalValue + increment, 0, startPeriod, endPeriod);
            return;
        }
        StringBundler sb = new StringBundler(7);
        sb.append("update SocialActivityCounter set currentValue = ");
        sb.append("currentValue + ");
        sb.append(increment);
        sb.append(", totalValue = totalValue + ");
        sb.append(increment);
        sb.append(" where activityCounterId = ");
        activityCounterId = GetterUtil.getLong((Object)activityCounter[0]);
        sb.append(activityCounterId);
        this.runSQL(sb.toString());
    }
}

