/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.image.DLHook;
import com.liferay.portal.image.DatabaseHook;
import com.liferay.portal.image.FileSystemHook;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.image.Hook;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.upgrade.v6_1_0.UpgradeDocumentLibrary;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.ImageProcessorUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeImageGallery
extends UpgradeProcess {
    private static final String _IG_IMAGE_CLASS_NAME = "com.liferay.portlet.imagegallery.model.IGImage";
    private Hook _sourceHook;
    private String _sourceHookClassName;

    public UpgradeImageGallery() throws Exception {
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        this._sourceHookClassName = FileSystemHook.class.getName();
        if (Validator.isNotNull((String)PropsValues.IMAGE_HOOK_IMPL)) {
            this._sourceHookClassName = PropsValues.IMAGE_HOOK_IMPL;
        }
        this._sourceHook = (Hook)classLoader.loadClass(this._sourceHookClassName).newInstance();
    }

    protected void addDLFileEntry(String uuid, long fileEntryId, long groupId, long companyId, long userId, String userName, long versionUserId, String versionUserName, Date createDate, Date modifiedDate, long repositoryId, long folderId, String name, String extension, String mimeType, String title, String description, String extraSettings, String version, long size, int readCount, long smallImageId, long largeImageId, long custom1ImageId, long custom2ImageId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(9);
            sb.append("insert into DLFileEntry (uuid_, fileEntryId, groupId, ");
            sb.append("companyId, userId, userName, versionUserId, ");
            sb.append("versionUserName, createDate, modifiedDate, ");
            sb.append("repositoryId, folderId, name, extension, mimeType, ");
            sb.append("title, description, extraSettings, version, size_, ");
            sb.append("readCount, smallImageId, largeImageId, ");
            sb.append("custom1ImageId, custom2ImageId) values (");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setString(1, uuid);
            ps.setLong(2, fileEntryId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setLong(7, versionUserId);
            ps.setString(8, versionUserName);
            ps.setDate(9, createDate);
            ps.setDate(10, modifiedDate);
            ps.setLong(11, repositoryId);
            ps.setLong(12, folderId);
            ps.setString(13, name);
            ps.setString(14, extension);
            ps.setString(15, mimeType);
            ps.setString(16, title);
            ps.setString(17, description);
            ps.setString(18, extraSettings);
            ps.setString(19, version);
            ps.setLong(20, size);
            ps.setInt(21, readCount);
            ps.setLong(22, smallImageId);
            ps.setLong(23, largeImageId);
            ps.setLong(24, custom1ImageId);
            ps.setLong(25, custom2ImageId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addDLFileVersion(long fileVersionId, long groupId, long companyId, long userId, String userName, Date createDate, long repositoryId, long folderId, long fileEntryId, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, String version, long size, int status, long statusByUserId, String statusByUserName, Date statusDate) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(9);
            sb.append("insert into DLFileVersion (fileVersionId, groupId, ");
            sb.append("companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, repositoryId, folderId, fileEntryId, ");
            sb.append("extension, mimeType, title, description, changeLog, ");
            sb.append("extraSettings, fileEntryTypeId, version, size_, ");
            sb.append("status, statusByUserId, statusByUserName, statusDate) ");
            sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setLong(1, fileVersionId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            ps.setDate(6, createDate);
            ps.setDate(7, statusDate);
            ps.setLong(8, repositoryId);
            ps.setLong(9, folderId);
            ps.setLong(10, fileEntryId);
            ps.setString(11, extension);
            ps.setString(12, mimeType);
            ps.setString(13, title);
            ps.setString(14, description);
            ps.setString(15, changeLog);
            ps.setString(16, extraSettings);
            ps.setLong(17, fileEntryTypeId);
            ps.setString(18, version);
            ps.setLong(19, size);
            ps.setInt(20, status);
            ps.setLong(21, statusByUserId);
            ps.setString(22, statusByUserName);
            ps.setDate(23, statusDate);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addDLFolderEntry(String uuid, long folderId, long groupId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long repositoryId, long parentFolderId, String name, String description, Date lastPostDate) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(5);
            sb.append("insert into DLFolder (uuid_, folderId, groupId, ");
            sb.append("companyId, userId, userName, createDate, ");
            sb.append("modifiedDate, repositoryId, mountPoint, ");
            sb.append("parentFolderId, name, description, lastPostDate) ");
            sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            ps.setString(1, uuid);
            ps.setLong(2, folderId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setDate(7, createDate);
            ps.setDate(8, modifiedDate);
            ps.setLong(9, repositoryId);
            ps.setBoolean(10, false);
            ps.setLong(11, parentFolderId);
            ps.setString(12, name);
            ps.setString(13, description);
            ps.setDate(14, lastPostDate);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        this.updateIGFolderEntries();
        this.updateIGImageEntries();
        this.updateIGFolderPermissions();
        this.updateIGImagePermissions();
        this.migrateImageFiles();
        UpgradeDocumentLibrary upgradeDocumentLibrary = new UpgradeDocumentLibrary();
        upgradeDocumentLibrary.updateSyncs();
    }

    protected Object[] getImage(long imageId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            Object[] objectArray;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select type_, size_ from Image where imageId = " + imageId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                String type = rs.getString("type_");
                long size = rs.getLong("size_");
                objectArray = new Object[]{type, size};
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return objectArray;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return null;
    }

    protected void migrateFile(long repositoryId, long companyId, String name, Image image) throws Exception {
        InputStream is = this._sourceHook.getImageAsStream(image);
        byte[] bytes = FileUtil.getBytes((InputStream)is);
        if (name == null) {
            name = String.valueOf(image.getImageId()) + "." + image.getType();
        }
        if (DLStoreUtil.hasFile((long)companyId, (long)repositoryId, (String)name)) {
            DLStoreUtil.deleteFile((long)companyId, (long)repositoryId, (String)name);
        }
        DLStoreUtil.addFile((long)companyId, (long)repositoryId, (String)name, (boolean)true, (byte[])bytes);
    }

    protected void migrateImage(long imageId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block9: {
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                StringBundler sb = new StringBundler(8);
                sb.append("select fileVersionId, fileEntry.fileEntryId ");
                sb.append("as fileEntryId, fileEntry.groupId as groupId, ");
                sb.append("fileEntry.companyId as companyId, fileEntry.folderId ");
                sb.append("as folderId, name, largeImageId, smallImageId, ");
                sb.append("custom1ImageId, custom2ImageId from ");
                sb.append("DLFileVersion fileVersion, DLFileEntry fileEntry ");
                sb.append("where fileEntry.fileEntryId = fileVersion.fileEntryId ");
                sb.append("and (largeImageId = ? or smallImageId = ? or ");
                sb.append("custom1ImageId = ? or custom2ImageId = ?)");
                String sql = sb.toString();
                ps = con.prepareStatement(sql);
                ps.setLong(1, imageId);
                ps.setLong(2, imageId);
                ps.setLong(3, imageId);
                ps.setLong(4, imageId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    long fileVersionId = rs.getLong("fileVersionId");
                    long fileEntryId = rs.getLong("fileEntryId");
                    long companyId = rs.getLong("companyId");
                    long groupId = rs.getLong("groupId");
                    long folderId = rs.getLong("folderId");
                    String name = rs.getString("name");
                    long largeImageId = rs.getLong("largeImageId");
                    long custom1ImageId = rs.getLong("custom1ImageId");
                    long custom2ImageId = rs.getLong("custom2ImageId");
                    Image image = ImageLocalServiceUtil.getImage((long)imageId);
                    if (largeImageId == imageId) {
                        long repositoryId = DLFolderConstants.getDataRepositoryId((long)groupId, (long)folderId);
                        try {
                            this.migrateFile(repositoryId, companyId, name, image);
                        }
                        catch (Exception exception) {}
                    } else {
                        InputStream is = this._sourceHook.getImageAsStream(image);
                        ImageProcessorUtil.storeThumbnail((long)companyId, (long)groupId, (long)fileEntryId, (long)fileVersionId, (long)custom1ImageId, (long)custom2ImageId, (InputStream)is, (String)image.getType());
                    }
                    this._sourceHook.deleteImage(image);
                    break block9;
                }
                if (this._sourceHookClassName.equals(DLHook.class.getName())) break block9;
                Image image = ImageLocalServiceUtil.getImage((long)imageId);
                try {
                    this.migrateFile(0L, 0L, null, image);
                }
                catch (Exception exception) {}
                this._sourceHook.deleteImage(image);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void migrateImageFiles() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select imageId from Image");
            rs = ps.executeQuery();
            while (rs.next()) {
                long imageId = rs.getLong("imageId");
                this.migrateImage(imageId);
            }
            StringBundler sb = new StringBundler(5);
            sb.append("delete from Image where imageId in (select ");
            sb.append("smallImageId from DLFileEntry) or imageId in (select ");
            sb.append("largeImageId from DLFileEntry) or imageId in (select ");
            sb.append("custom1ImageId from DLFileEntry) or imageId in ");
            sb.append("(select custom2ImageId from DLFileEntry)");
            this.runSQL(sb.toString());
            if (this._sourceHookClassName.equals(DatabaseHook.class.getName())) {
                this.runSQL("update Image set text_ = ''");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateIGFolderEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select * from IGFolder order by folderId asc");
            rs = ps.executeQuery();
            HashMap<Long, Long> folderIds = new HashMap<Long, Long>();
            while (rs.next()) {
                boolean update;
                String uuid = rs.getString("uuid_");
                long folderId = rs.getLong("folderId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Date createDate = rs.getDate("createDate");
                Date modifiedDate = rs.getDate("modifiedDate");
                long parentFolderId = rs.getLong("parentFolderId");
                String name = rs.getString("name");
                String description = rs.getString("description");
                if (folderIds.containsKey(parentFolderId)) {
                    parentFolderId = (Long)folderIds.get(parentFolderId);
                }
                if (update = this.updateIGImageFolderId(groupId, name, parentFolderId, folderId, folderIds)) continue;
                this.addDLFolderEntry(uuid, folderId, groupId, companyId, userId, userName, createDate, modifiedDate, groupId, parentFolderId, name, description, modifiedDate);
            }
            this.runSQL("drop table IGFolder");
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateIGFolderPermissions() throws Exception {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return;
        }
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.portlet.imagegallery.model.IGFolder' and primKey = '0'");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("update ResourcePermission set name = '");
            sb.append(DLFolder.class.getName());
            sb.append("' where name = 'com.liferay.portlet.imagegallery.");
            sb.append("model.IGFolder'");
            ps = con.prepareStatement(sb.toString());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
    }

    protected void updateIGImageEntries() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select * from IGImage");
            rs = ps.executeQuery();
            while (rs.next()) {
                String uuid = rs.getString("uuid_");
                long imageId = rs.getLong("imageId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Date createDate = rs.getDate("createDate");
                Date modifiedDate = rs.getDate("modifiedDate");
                long folderId = rs.getLong("folderId");
                String title = rs.getString("name");
                String description = rs.getString("description");
                long smallImageId = rs.getLong("smallImageId");
                long largeImageId = rs.getLong("largeImageId");
                long custom1ImageId = rs.getLong("custom1ImageId");
                long custom2ImageId = rs.getLong("custom2ImageId");
                Object[] image = this.getImage(largeImageId);
                if (image == null) continue;
                String extension = (String)image[0];
                String mimeType = MimeTypesUtil.getContentType((String)("A." + extension));
                String name = String.valueOf(this.increment(DLFileEntry.class.getName()));
                long size = (Long)image[1];
                this.addDLFileEntry(uuid, imageId, groupId, companyId, userId, userName, userId, userName, createDate, modifiedDate, groupId, folderId, name, extension, mimeType, title, description, "", "1.0", size, 0, smallImageId, largeImageId, custom1ImageId, custom2ImageId);
                this.addDLFileVersion(this.increment(), groupId, companyId, userId, userName, createDate, groupId, folderId, imageId, extension, mimeType, title, description, "", "", 0L, "1.0", size, 0, userId, userName, modifiedDate);
            }
            this.runSQL("drop table IGImage");
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected boolean updateIGImageFolderId(long groupId, String name, long parentFolderId, long folderId, Map<Long, Long> folderIds) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select folderId from DLFolder where groupId = " + groupId + " and parentFolderId = " + parentFolderId + " and name = '" + name + "'");
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                long newFolderId = rs.getLong("folderId");
                this.runSQL("update IGImage set folderId = " + newFolderId + " where folderId = " + folderId);
                folderIds.put(folderId, newFolderId);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return true;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return false;
    }

    protected void updateIGImagePermissions() throws Exception {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM != 6) {
            return;
        }
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.portlet.imagegallery.model.IGImage' and primKey = '0'");
        this.runSQL("update ResourcePermission set name = '" + DLFileEntry.class.getName() + "' where name = '" + _IG_IMAGE_CLASS_NAME + "'");
    }
}

