/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class UpgradeAdminPortlets
extends UpgradeProcess {
    protected void addResource(long resourceId, long codeId, String primKey) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("insert into Resource_ (resourceId, codeId, primKey) values (?, ?, ?)");
            ps.setLong(1, resourceId);
            ps.setLong(2, codeId);
            ps.setString(3, primKey);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected long[] addResourceIds(long companyId, String name) throws Exception {
        long[] resourceIds = new long[2];
        long codeId = this.increment();
        this.runSQL("insert into ResourceCode (codeId, companyId, name, scope) values (" + codeId + ", " + companyId + ", '" + name + "', " + 1 + ")");
        long resourceId = this.increment();
        this.addResource(resourceId, codeId, String.valueOf(companyId));
        resourceIds[0] = resourceId;
        codeId = this.increment();
        this.runSQL("insert into ResourceCode (codeId, companyId, name, scope) values (" + codeId + ", " + companyId + ", '" + name + "', " + 4 + ")");
        resourceId = this.increment();
        long controlPanelGroupId = this.getControlPanelGroupId();
        this.addResource(resourceId, codeId, String.valueOf(controlPanelGroupId));
        resourceIds[1] = resourceId;
        return resourceIds;
    }

    protected void addResourcePermission(long resourcePermissionId, long companyId, String name, long scope, String primKey, long roleId, long actionIds) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("insert into ResourcePermission (resourcePermissionId, companyId, name, scope, primKey, roleId, actionIds) values (?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, resourcePermissionId);
            ps.setLong(2, companyId);
            ps.setString(3, name);
            ps.setLong(4, scope);
            ps.setString(5, primKey);
            ps.setLong(6, roleId);
            ps.setLong(7, actionIds);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            this.updateAccessInControlPanelPermission_5("33", "161");
            this.updateAccessInControlPanelPermission_5("19", "162");
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.updateAccessInControlPanelPermission_6("33", "161");
            this.updateAccessInControlPanelPermission_6("19", "162");
        }
    }

    protected long getBitwiseValue(String name, String actionId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select bitwiseValue from ResourceAction where name = ? and actionId = ?");
                ps.setString(1, name);
                ps.setString(2, actionId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("bitwiseValue");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected long getControlPanelGroupId() throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            long l;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select groupId from Group_ where name = 'Control Panel'");
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                l = rs.getLong("groupId");
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return l;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected long[] getOldResourceIds(String name) throws Exception {
        long[] lArray;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(8);
            sb.append("select Permission_.resourceId from Permission_ ");
            sb.append("inner join Resource_ on Permission_.resourceId = ");
            sb.append("Resource_.resourceId and Permission_.actionId = ");
            sb.append("'ACCESS_IN_CONTROL_PANEL' inner join ResourceCode on ");
            sb.append("ResourceCode.codeId = Resource_.codeId and ");
            sb.append("ResourceCode.name = '");
            sb.append(name);
            sb.append("'");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            ArrayList<Long> resourceIds = new ArrayList<Long>();
            while (rs.next()) {
                long resourceId = rs.getLong("resourceId");
                resourceIds.add(resourceId);
            }
            lArray = ArrayUtil.toArray((Long[])resourceIds.toArray(new Long[resourceIds.size()]));
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return lArray;
    }

    protected void updateAccessInControlPanelPermission_5(String portletFrom, String portletTo) throws Exception {
        long[] companyIds = PortalInstances.getCompanyIdsBySQL();
        if (companyIds.length == 0) {
            return;
        }
        long[] lArray = companyIds;
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            long[] newResourceIds = this.addResourceIds(companyId, portletTo);
            long[] oldResourceIds = this.getOldResourceIds(portletFrom);
            this.updatePermission(oldResourceIds, newResourceIds);
            ++n2;
        }
    }

    protected void updateAccessInControlPanelPermission_6(String portletFrom, String portletTo) throws Exception {
        long bitwiseValue = this.getBitwiseValue(portletFrom, "ACCESS_IN_CONTROL_PANEL");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select * from ResourcePermission where name = ?");
            ps.setString(1, portletFrom);
            rs = ps.executeQuery();
            while (rs.next()) {
                long resourcePermissionId = rs.getLong("resourcePermissionId");
                long actionIds = rs.getLong("actionIds");
                if ((actionIds & bitwiseValue) == 0L) continue;
                this.runSQL("update ResourcePermission set actionIds = " + (actionIds &= bitwiseValue ^ 0xFFFFFFFFFFFFFFFFL) + " where resourcePermissionId = " + resourcePermissionId);
                resourcePermissionId = this.increment();
                long companyId = rs.getLong("companyId");
                long scope = rs.getLong("scope");
                String primKey = rs.getString("primKey");
                long roleId = rs.getLong("roleId");
                actionIds = rs.getLong("actionIds");
                this.addResourcePermission(resourcePermissionId, companyId, portletTo, scope, primKey, roleId, actionIds |= bitwiseValue);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updatePermission(long[] oldResourceIds, long[] newResourceIds) throws Exception {
        int i = 0;
        while (i < newResourceIds.length) {
            try {
                long newResourceId = newResourceIds[i];
                long oldResourceId = oldResourceIds[i];
                this.runSQL("update Permission_ set resourceId = " + newResourceId + " where actionId = 'ACCESS_IN_CONTROL_PANEL' and " + "resourceId = " + oldResourceId);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
            ++i;
        }
    }
}

