/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_5;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeLayout
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select groupId, liveGroupId from Group_ where liveGroupId != 0");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long liveGroupId = rs.getLong("liveGroupId");
                this.updateUUID(groupId, liveGroupId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateUUID(long groupId, long liveGroupId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select plid, privateLayout, layoutId, friendlyURL from Layout where groupId = ?");
            ps.setLong(1, groupId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long plid = rs.getLong("plid");
                boolean privateLayout = rs.getBoolean("privateLayout");
                long layoutId = rs.getLong("layoutId");
                String friendlyURL = rs.getString("friendlyURL");
                this.updateUUID(plid, liveGroupId, privateLayout, layoutId, friendlyURL);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateUUID(long plid, long groupId, boolean privateLayout, long layoutId, String friendlyURL) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select uuid_ from Layout where groupId = ? and friendlyURL = ?");
                ps.setLong(1, groupId);
                ps.setString(2, friendlyURL);
                rs = ps.executeQuery();
                if (rs.next()) break block3;
                ps = con.prepareStatement("select uuid_ from Layout where groupId = ? and privateLayout = ? and layoutId = ?");
                ps.setLong(1, groupId);
                ps.setBoolean(2, privateLayout);
                ps.setLong(3, layoutId);
                rs = ps.executeQuery();
                if (rs.next()) break block3;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return;
        }
        String uuid = rs.getString("uuid_");
        this.runSQL("update Layout set uuid_ = '" + uuid + "' where plid = " + plid);
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

