/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_3;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeAsset
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateAssetEntry("com.liferay.portal.model.User", "User_", "userId");
        this.updateAssetEntry("com.liferay.portlet.blogs.model.BlogsEntry", "BlogsEntry", "entryId");
        this.updateAssetEntry("com.liferay.portlet.bookmarks.model.BookmarksEntry", "BookmarksEntry", "entryId");
        this.updateAssetEntry("com.liferay.portlet.calendar.model.CalEvent", "CalEvent", "eventId");
        this.updateAssetEntry("com.liferay.portlet.documentlibrary.model.DLFileEntry", "DLFileEntry", "fileEntryId");
        this.updateAssetEntry("com.liferay.portlet.documentlibrary.model.DLFileShortcut", "DLFileShortcut", "fileShortcutId");
        this.updateAssetEntry("com.liferay.portlet.imagegallery.model.IGImage", "IGImage", "imageId");
        this.updateAssetEntry("com.liferay.portlet.journal.model.JournalArticle", "JournalArticle", "resourcePrimKey", "id_");
        this.updateAssetEntry("com.liferay.portlet.messageboards.model.MBMessage", "MBMessage", "messageId");
        this.updateAssetEntry("com.liferay.portlet.wiki.model.WikiPage", "WikiPage", "resourcePrimKey", "pageId");
    }

    protected String getUuid(String tableName, String columnName1, String columnName2, long classPK) throws Exception {
        String uuid = "";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select uuid_ from " + tableName + " where " + columnName1 + " = ? or " + columnName2 + " = ?");
            ps.setLong(1, classPK);
            ps.setLong(2, classPK);
            rs = ps.executeQuery();
            while (rs.next()) {
                uuid = rs.getString("uuid_");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return uuid;
    }

    protected void updateAssetEntry(long classNameId, long classPK, String uuid) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update AssetEntry set classUuid = ? where classNameId = ? and classPK = ?");
            ps.setString(1, uuid);
            ps.setLong(2, classNameId);
            ps.setLong(3, classPK);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateAssetEntry(String className, String tableName, String columnName) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)className);
        StringBundler sb = new StringBundler(11);
        sb.append("update AssetEntry set classUuid = (select ");
        sb.append(tableName);
        sb.append(".uuid_ from ");
        sb.append(tableName);
        sb.append(" where ");
        sb.append(tableName);
        sb.append(".");
        sb.append(columnName);
        sb.append(" = AssetEntry.classPK) where (AssetEntry.classNameId = ");
        sb.append(classNameId);
        sb.append(")");
        this.runSQL(sb.toString());
    }

    protected void updateAssetEntry(String className, String tableName, String columnName1, String columnName2) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)className);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select classPK from AssetEntry where classNameId = ?");
            ps.setLong(1, classNameId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long classPK = rs.getLong("classPK");
                String uuid = this.getUuid(tableName, columnName1, columnName2, classPK);
                this.updateAssetEntry(classNameId, classPK, uuid);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

