/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_12_to_6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpgradeMessageBoards
extends UpgradeProcess {
    protected void addThreadFlag(long threadFlagId, long userId, long threadId, Timestamp modifiedDate) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("insert into MBThreadFlag (threadFlagId, userId, modifiedDate, threadId) values (?, ?, ?, ?)");
            ps.setLong(1, threadFlagId);
            ps.setLong(2, userId);
            ps.setTimestamp(3, modifiedDate);
            ps.setLong(4, threadId);
            ps.executeUpdate();
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateMessage();
        this.updateThread();
        this.updateThreadFlag();
    }

    protected void updateMessage() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("select messageFlag.messageId from MBMessageFlag ");
            sb.append("messageFlag inner join MBMessage message on ");
            sb.append("messageFlag.messageId = message.messageId where ");
            sb.append("message.parentMessageId != 0 and flag = 3");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                long messageId = rs.getLong("messageFlag.messageId");
                this.updateMessageAnswer(messageId, true);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateMessageAnswer(long messageId, boolean answer) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update MBMessage set answer = ? where messageId = " + messageId);
            ps.setBoolean(1, answer);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void updateThread() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select threadId from MBMessageFlag where flag = 2");
            rs = ps.executeQuery();
            while (rs.next()) {
                long threadId = rs.getLong("threadId");
                this.updateThreadQuestion(threadId, true);
            }
            StringBundler sb = new StringBundler(4);
            sb.append("select messageFlag.threadId from MBMessageFlag ");
            sb.append("messageFlag inner join MBMessage message on ");
            sb.append("messageFlag.messageId = message.messageId where ");
            sb.append("message.parentMessageId = 0 and flag = 3");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                long threadId = rs.getLong("messageFlag.threadId");
                this.updateThreadQuestion(threadId, true);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateThreadFlag() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select userId, threadId, modifiedDate from MBMessageFlag where flag = 1");
            rs = ps.executeQuery();
            while (rs.next()) {
                long userId = rs.getLong("userId");
                long threadId = rs.getLong("threadId");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                this.addThreadFlag(this.increment(), userId, threadId, modifiedDate);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("drop table MBMessageFlag");
    }

    protected void updateThreadQuestion(long threadId, boolean question) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("update MBThread set question = ? where threadId =" + threadId);
            ps.setBoolean(1, question);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }
}

