/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_12_to_6_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeAsset
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateAssetClassTypeId();
        this.updateIGImageClassName();
    }

    protected long getJournalStructureId(String structureId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long journalStructureId = 0L;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select id_ from JournalStructure where structureId = ?");
            ps.setString(1, structureId);
            rs = ps.executeQuery();
            if (rs.next()) {
                journalStructureId = rs.getLong("id_");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return journalStructureId;
    }

    protected void updateAssetClassTypeId() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select resourcePrimKey, structureId from JournalArticle where structureId != ''");
            rs = ps.executeQuery();
            while (rs.next()) {
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                String structureId = rs.getString("structureId");
                long journalStructureId = this.getJournalStructureId(structureId);
                this.runSQL("update AssetEntry set classTypeId = " + journalStructureId + " where classPK = " + resourcePrimKey);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateIGImageClassName() throws Exception {
        long dlFileEntryClassNameId = PortalUtil.getClassNameId((String)DLFileEntry.class.getName());
        long igImageClassNameId = PortalUtil.getClassNameId((String)"com.liferay.portlet.imagegallery.model.IGImage");
        this.runSQL("update AssetEntry set classNameId = " + dlFileEntryClassNameId + " where classNameId = " + igImageClassNameId);
    }
}

