/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_0_0;

import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.upgrade.util.UpgradeAssetPublisherManualEntries;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import javax.portlet.PortletPreferences;

public class UpgradeAssetPublisher
extends BaseUpgradePortletPreferences {
    protected String[] getAssetEntryXmls(String[] manualEntries) throws Exception {
        String[] assetEntryXmls = new String[manualEntries.length];
        int i = 0;
        while (i < manualEntries.length) {
            String manualEntry = manualEntries[i];
            Document document = SAXReaderUtil.read((String)manualEntry);
            Element rootElement = document.getRootElement();
            UpgradeAssetPublisherManualEntries.upgradeToAssetEntryIdElement(rootElement);
            UpgradeAssetPublisherManualEntries.upgradeToAssetEntryTypeElement(rootElement);
            assetEntryXmls[i] = document.formattedString("");
            ++i;
        }
        return assetEntryXmls;
    }

    protected String[] getPortletIds() {
        return new String[]{"101_INSTANCE_%"};
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        String selectionStyle;
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        long layoutId = GetterUtil.getLong((String)portletPreferences.getValue("lfr-scope-layout-id", null));
        portletPreferences.reset("lfr-scope-layout-id");
        if (layoutId != 0L) {
            portletPreferences.setValues("scope-ids", new String[]{"Layout_" + layoutId});
            portletPreferences.setValue("default-scope", Boolean.FALSE.toString());
        }
        long classNameId = GetterUtil.getLong((String)portletPreferences.getValue("class-name-id", null));
        portletPreferences.reset("class-name-id");
        if (classNameId != 0L) {
            portletPreferences.setValues("class-name-ids", new String[]{String.valueOf(classNameId)});
            portletPreferences.setValue("any-asset-type", Boolean.FALSE.toString());
        }
        boolean andOperator = GetterUtil.getBoolean((String)portletPreferences.getValue("and-operator", null));
        portletPreferences.reset("and-operator");
        String[] assetTagNames = portletPreferences.getValues("entries", null);
        String[] notAssetTagNames = portletPreferences.getValues("not-entries", null);
        int i = 0;
        if (assetTagNames != null) {
            portletPreferences.reset("entries");
            portletPreferences.setValue("queryContains" + i, Boolean.TRUE.toString());
            portletPreferences.setValue("queryAndOperator" + i, String.valueOf(andOperator));
            portletPreferences.setValue("queryName" + i, "assetTags");
            portletPreferences.setValues("queryValues" + i, assetTagNames);
            ++i;
        }
        if (notAssetTagNames != null) {
            portletPreferences.reset("not-entries");
            portletPreferences.setValue("queryContains" + i, Boolean.FALSE.toString());
            portletPreferences.setValue("queryAndOperator" + i, String.valueOf(andOperator));
            portletPreferences.setValue("queryName" + i, "assetTags");
            portletPreferences.setValues("queryValues" + i, notAssetTagNames);
            ++i;
        }
        if (Validator.isNotNull((String)(selectionStyle = portletPreferences.getValue("selection-style", null))) && !selectionStyle.equals("dynamic")) {
            String[] manualEntries = portletPreferences.getValues("manual-entries", new String[0]);
            String[] assetEntryXmls = this.getAssetEntryXmls(manualEntries);
            portletPreferences.setValues("asset-entry-xml", assetEntryXmls);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

