/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.upgrade.StagnantRowException;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.comparator.ColumnsComparator;
import com.liferay.portal.upgrade.util.BaseUpgradeTableImpl;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUpgradeTableImpl
extends BaseUpgradeTableImpl
implements UpgradeTable {
    private UpgradeColumn[] _upgradeColumns;

    @Override
    public String getExportedData(ResultSet rs) throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[][] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            boolean last = false;
            if (i + 1 == columns.length) {
                last = true;
            }
            if (this._upgradeColumns[i] == null) {
                this.appendColumn(sb, rs, (String)columns[i][0], (Integer)columns[i][1], last);
            } else {
                try {
                    Integer columnType = this._upgradeColumns[i].getOldColumnType((Integer)columns[i][1]);
                    Object oldValue = this.getValue(rs, (String)columns[i][0], columnType);
                    this._upgradeColumns[i].setOldValue(oldValue);
                    Object newValue = this._upgradeColumns[i].getNewValue(oldValue);
                    this._upgradeColumns[i].setNewValue(newValue);
                    this.appendColumn(sb, newValue, last);
                }
                catch (StagnantRowException sre) {
                    this._upgradeColumns[i].setNewValue(null);
                    throw new StagnantRowException("Column " + columns[i][0] + " with value " + sre.getMessage(), (Throwable)sre);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void setColumn(PreparedStatement ps, int index, Integer type, String value) throws Exception {
        if (this._upgradeColumns[index] != null) {
            type = this.getCreateSQL() == null ? this._upgradeColumns[index].getOldColumnType(type) : this._upgradeColumns[index].getNewColumnType(type);
        }
        super.setColumn(ps, index, type, value);
    }

    protected DefaultUpgradeTableImpl(String tableName, Object[][] columns, UpgradeColumn ... upgradeColumns) {
        super(tableName);
        UpgradeColumn upgradeColumn;
        columns = (Object[][])columns.clone();
        ArrayList<String> sortedColumnNames = new ArrayList<String>();
        UpgradeColumn[] upgradeColumnArray = upgradeColumns;
        int n = upgradeColumns.length;
        int n2 = 0;
        while (n2 < n) {
            upgradeColumn = upgradeColumnArray[n2];
            this.getSortedColumnName(sortedColumnNames, upgradeColumn);
            ++n2;
        }
        if (sortedColumnNames.size() > 0) {
            Arrays.sort(columns, new ColumnsComparator(sortedColumnNames));
        }
        this.setColumns(columns);
        this._upgradeColumns = new UpgradeColumn[columns.length];
        upgradeColumnArray = upgradeColumns;
        n = upgradeColumns.length;
        n2 = 0;
        while (n2 < n) {
            upgradeColumn = upgradeColumnArray[n2];
            this.prepareUpgradeColumns(upgradeColumn);
            ++n2;
        }
    }

    protected void getSortedColumnName(List<String> sortedColumnNames, UpgradeColumn upgradeColumn) {
        if (upgradeColumn == null) {
            return;
        }
        String name = upgradeColumn.getName();
        if (Validator.isNotNull((String)name)) {
            sortedColumnNames.add(name);
        }
    }

    protected void prepareUpgradeColumns(UpgradeColumn upgradeColumn) {
        if (upgradeColumn == null) {
            return;
        }
        Object[][] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            String name = (String)columns[i][0];
            if (upgradeColumn.isApplicable(name)) {
                this._upgradeColumns[i] = upgradeColumn;
            }
            ++i;
        }
    }
}

