/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.servicebuilder;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.tools.servicebuilder.Entity;
import com.liferay.portal.tools.servicebuilder.EntityColumn;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityFinder {
    private List<EntityColumn> _columns;
    private boolean _dbIndex;
    private String _name;
    private String _returnType;
    private boolean _unique;
    private String _where;

    public EntityFinder(String name, String returnType, boolean unique, String where, boolean dbIndex, List<EntityColumn> columns) {
        this._name = name;
        this._returnType = returnType;
        this._unique = unique;
        this._where = where;
        this._dbIndex = dbIndex;
        this._columns = columns;
    }

    public EntityColumn getColumn(String name) {
        for (EntityColumn column : this._columns) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public List<EntityColumn> getColumns() {
        return this._columns;
    }

    public String getHumanConditions(boolean arrayable) {
        if (this._columns.size() == 1) {
            return this._columns.get(0).getHumanCondition(arrayable);
        }
        Iterator<EntityColumn> itr = this._columns.iterator();
        StringBundler sb = new StringBundler();
        while (itr.hasNext()) {
            EntityColumn column = itr.next();
            sb.append(column.getHumanCondition(arrayable));
            if (!itr.hasNext()) continue;
            sb.append(" and ");
        }
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getNames() {
        return TextFormatter.formatPlural((String)this._name);
    }

    public String getReturnType() {
        return this._returnType;
    }

    public String getWhere() {
        return this._where;
    }

    public boolean hasArrayableOperator() {
        for (EntityColumn column : this._columns) {
            if (!column.hasArrayableOperator()) continue;
            return true;
        }
        return false;
    }

    public boolean hasColumn(String name) {
        return Entity.hasColumn(name, this._columns);
    }

    public boolean isCollection() {
        return this._returnType != null && this._returnType.equals("Collection");
    }

    public boolean isDBIndex() {
        return this._dbIndex;
    }

    public boolean isUnique() {
        return this._unique;
    }
}

