/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.servicebuilder;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityColumn
implements Cloneable,
Comparable<EntityColumn> {
    private boolean _accessor;
    private String _arrayableOperator;
    private boolean _caseSensitive;
    private String _comparator;
    private boolean _convertNull;
    private String _dbName;
    private String _ejbName;
    private boolean _filterPrimary;
    private boolean _finderPath;
    private String _humanName;
    private String _idParam;
    private String _idType;
    private boolean _jsonEnabled;
    private boolean _lazy;
    private boolean _localized;
    private String _mappingKey;
    private String _mappingTable;
    private String _methodName;
    private String _name;
    private boolean _orderByAscending;
    private boolean _orderColumn;
    private boolean _primary;
    private String _type;

    public EntityColumn(String name) {
        this(name, null, null, false, false, false, null, null, null, true, true, false, null, null, null, null, true, true, false, false);
    }

    public EntityColumn(String name, String dbName, String type, boolean primary, boolean accessor, boolean filterPrimary, String ejbName, String mappingKey, String mappingTable, boolean caseSensitive, boolean orderByAscending, boolean orderColumn, String comparator, String arrayableOperator, String idType, String idParam, boolean convertNull, boolean lazy, boolean localized, boolean jsonEnabled) {
        this._name = name;
        this._dbName = dbName;
        this._type = type;
        this._primary = primary;
        this._accessor = accessor;
        this._filterPrimary = filterPrimary;
        this._humanName = ServiceBuilder.toHumanName(name);
        this._methodName = TextFormatter.format((String)name, (int)6);
        this._ejbName = ejbName;
        this._mappingKey = mappingKey;
        this._mappingTable = mappingTable;
        this._caseSensitive = caseSensitive;
        this._orderByAscending = orderByAscending;
        this._orderColumn = orderColumn;
        this._comparator = comparator;
        this._arrayableOperator = arrayableOperator;
        this._idType = idType;
        this._idParam = idParam;
        this._convertNull = convertNull;
        this._lazy = lazy;
        this._localized = localized;
        this._jsonEnabled = jsonEnabled;
    }

    public EntityColumn(String name, String dbName, String type, boolean primary, boolean accessor, boolean filterPrimary, String ejbName, String mappingKey, String mappingTable, String idType, String idParam, boolean convertNull, boolean lazy, boolean localized, boolean jsonEnabled) {
        this(name, dbName, type, primary, accessor, filterPrimary, ejbName, mappingKey, mappingTable, true, true, false, null, null, idType, idParam, convertNull, lazy, localized, jsonEnabled);
    }

    public Object clone() {
        return new EntityColumn(this.getName(), this.getDBName(), this.getType(), this.isPrimary(), this.isAccessor(), this.isFilterPrimary(), this.getEJBName(), this.getMappingKey(), this.getMappingTable(), this.isCaseSensitive(), this.isOrderByAscending(), this.isOrderColumn(), this.getComparator(), this.getArrayableOperator(), this.getIdType(), this.getIdParam(), this.isConvertNull(), this.isLazy(), this.isLocalized(), this.isJsonEnabled());
    }

    @Override
    public int compareTo(EntityColumn entityColumn) {
        return this._name.compareTo(entityColumn._name);
    }

    public boolean equals(Object obj) {
        EntityColumn col = (EntityColumn)obj;
        String name = col.getName();
        return this._name.equals(name);
    }

    public String getArrayableOperator() {
        return this._arrayableOperator;
    }

    public String getComparator() {
        return this._comparator;
    }

    public String getDBName() {
        return this._dbName;
    }

    public String getHumanCondition(boolean arrayable) {
        StringBundler sb = new StringBundler();
        sb.append(this._name);
        sb.append(" ");
        sb.append(this.convertComparatorToHtml(this._comparator));
        sb.append(" ");
        if (arrayable && this.hasArrayableOperator()) {
            if (this.isArrayableAndOperator()) {
                sb.append("all ");
            } else {
                sb.append("any ");
            }
        }
        sb.append("&#63;");
        return sb.toString();
    }

    public String getHumanName() {
        return this._humanName;
    }

    public String getHumanNames() {
        return TextFormatter.formatPlural((String)this.getHumanName());
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public String getIdParam() {
        return this._idParam;
    }

    public String getIdType() {
        return this._idType;
    }

    public String getMappingKey() {
        return this._mappingKey;
    }

    public String getMappingTable() {
        return this._mappingTable;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String getMethodNames() {
        return TextFormatter.formatPlural((String)this._methodName);
    }

    public String getMethodUserUuidName() {
        return String.valueOf(this._methodName.substring(0, this._methodName.length() - 2)) + "Uuid";
    }

    public String getName() {
        return this._name;
    }

    public String getNames() {
        return TextFormatter.formatPlural((String)this._name);
    }

    public String getType() {
        return this._type;
    }

    public String getUserUuidHumanName() {
        return ServiceBuilder.toHumanName(this.getUserUuidName());
    }

    public String getUserUuidName() {
        return String.valueOf(this._name.substring(0, this._name.length() - 2)) + "Uuid";
    }

    public boolean hasArrayableOperator() {
        return Validator.isNotNull((String)this._arrayableOperator);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean isAccessor() {
        return this._accessor;
    }

    public boolean isArrayableAndOperator() {
        return this._arrayableOperator.equals("AND");
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public boolean isCollection() {
        return this._type.equals("Collection");
    }

    public boolean isConvertNull() {
        return this._convertNull;
    }

    public boolean isFilterPrimary() {
        return this._filterPrimary;
    }

    public boolean isFinderPath() {
        return this._finderPath;
    }

    public boolean isJsonEnabled() {
        return this._jsonEnabled;
    }

    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isLocalized() {
        return this._localized;
    }

    public boolean isMappingManyToMany() {
        return Validator.isNotNull((String)this._mappingTable);
    }

    public boolean isMappingOneToMany() {
        return Validator.isNotNull((String)this._mappingKey);
    }

    public boolean isOrderByAscending() {
        return this._orderByAscending;
    }

    public boolean isOrderColumn() {
        return this._orderColumn;
    }

    public boolean isPrimary() {
        return this._primary;
    }

    public boolean isPrimitiveType() {
        return this.isPrimitiveType(true);
    }

    public boolean isPrimitiveType(boolean includeWrappers) {
        if (Character.isLowerCase(this._type.charAt(0))) {
            return true;
        }
        if (!includeWrappers) {
            return false;
        }
        if (this._type.equals("Boolean")) {
            return true;
        }
        if (this._type.equals("Double")) {
            return true;
        }
        if (this._type.equals("Float")) {
            return true;
        }
        if (this._type.equals("Integer")) {
            return true;
        }
        if (this._type.equals("Long")) {
            return true;
        }
        return this._type.equals("Short");
    }

    public boolean isUserUuid() {
        return this._type.equals("long") && this._methodName.endsWith("UserId");
    }

    public void setArrayableOperator(String arrayableOperator) {
        this._arrayableOperator = arrayableOperator.toUpperCase();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public void setComparator(String comparator) {
        this._comparator = comparator;
    }

    public void setConvertNull(boolean convertNull) {
        this._convertNull = convertNull;
    }

    public void setDBName(String dbName) {
        this._dbName = dbName;
    }

    public void setFinderPath(boolean finderPath) {
        this._finderPath = finderPath;
    }

    public void setIdParam(String idParam) {
        this._idParam = idParam;
    }

    public void setIdType(String idType) {
        this._idType = idType;
    }

    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public void setLocalized(boolean localized) {
        this._localized = localized;
    }

    public void setOrderByAscending(boolean orderByAscending) {
        this._orderByAscending = orderByAscending;
    }

    public void setOrderColumn(boolean orderColumn) {
        this._orderColumn = orderColumn;
    }

    protected String convertComparatorToHtml(String comparator) {
        if (comparator.equals(">")) {
            return "&gt;";
        }
        if (comparator.equals("<")) {
            return "&lt;";
        }
        if (comparator.equals(">=")) {
            return "&ge;";
        }
        if (comparator.equals("<=")) {
            return "&le;";
        }
        if (comparator.equals("!=")) {
            return "&ne;";
        }
        return comparator;
    }
}

