/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.portal.kernel.util.StringBundler;
import java.util.concurrent.atomic.AtomicLong;

public class SequentialUUID {
    private static final char[] _HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String _UUID_PREFIX = "00000000-0000-0000-";
    private static SequentialUUID _instance = new SequentialUUID();
    private static AtomicLong _counter = new AtomicLong();

    public static String generate() {
        long count = _counter.getAndIncrement();
        long high = count >> 48 & 0xFFFFL;
        long low = count & 0xFFFFFFFFFFFFL;
        StringBundler sb = new StringBundler(4);
        sb.append(_UUID_PREFIX);
        sb.append(SequentialUUID.toHexString(high, 4));
        sb.append("-");
        sb.append(SequentialUUID.toHexString(low, 8));
        return sb.toString();
    }

    public static SequentialUUID getSequentialUUID() {
        return _instance;
    }

    private static String toHexString(long number, int digits) {
        char[] buffer = new char[digits];
        int i = 0;
        while (i < digits) {
            buffer[i] = 48;
            ++i;
        }
        int index = digits;
        do {
            buffer[--index] = _HEX_DIGITS[(int)(number & 0xFL)];
        } while ((number >>>= 4) != 0L);
        return new String(buffer);
    }
}

