/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.InitUtil;
import com.liferay.util.xml.XMLFormatter;

public class WebXML23Converter {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new WebXML23Converter(args[0], args[1]);
    }

    public WebXML23Converter(String input, String output) {
        try {
            String webXML24 = FileUtil.read((String)input);
            Document doc = SAXReaderUtil.read((String)webXML24);
            Element root = doc.getRootElement();
            double version = GetterUtil.getDouble((String)root.attributeValue("version"));
            if (version != 2.4) {
                System.out.println("Do not convert web.xml because it is not Servlet 2.4");
                return;
            }
            System.out.println("Convert web.xml because it is Servlet 2.4");
            for (Element filterMapping : root.elements("filter-mapping")) {
                for (Element dispatcher : filterMapping.elements("dispatcher")) {
                    dispatcher.detach();
                }
            }
            String webXML23 = doc.formattedString();
            int x = webXML23.indexOf("<web-app");
            int y = webXML23.indexOf(">", x);
            webXML23 = String.valueOf(webXML23.substring(0, x)) + "<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\"><web-app>" + webXML23.substring(y + 1, webXML23.length());
            webXML23 = StringUtil.replace((String)webXML23, (String[])new String[]{"<jsp-config>", "</jsp-config>"}, (String[])new String[]{"", ""});
            webXML23 = XMLFormatter.toString((String)webXML23);
            FileUtil.write((String)output, (String)webXML23);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

